/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;

public class SubdirectoryOrSameNameSchedulingRule
implements ISchedulingRule {
    private final String path;
    private final String name;

    private SubdirectoryOrSameNameSchedulingRule(String path, String name) {
        this.path = path;
        this.name = name;
    }

    public SubdirectoryOrSameNameSchedulingRule(File directory) {
        this(directory.getAbsolutePath(), directory.getName());
    }

    public SubdirectoryOrSameNameSchedulingRule(IResource resource) {
        this(SmartImportWizard.toAbsolutePath(resource), resource.getName());
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule == this || rule instanceof IResource) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)rule).getChildren();
            int n = iSchedulingRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule child = iSchedulingRuleArray[n2];
                if (this.contains(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof SubdirectoryOrSameNameSchedulingRule) {
            SubdirectoryOrSameNameSchedulingRule otherRule = (SubdirectoryOrSameNameSchedulingRule)rule;
            return otherRule.path.startsWith(this.path) || otherRule.name.equals(this.name);
        }
        if (rule instanceof IResource) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)rule).getChildren();
            int n = iSchedulingRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISchedulingRule child = iSchedulingRuleArray[n2];
                if (this.isConflicting(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

