/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.views.HistoryScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ScopeSetManager
extends Observable {
    private ScopeSet activeSet;
    private ScopeSet lastExplicitSet;
    private static final String ACTIVE_SET = "activeScopeSet";
    private ArrayList<ScopeSet> sets;
    private ScopeSet defSet;

    public ScopeSetManager() {
        ScopeSetManager.ensureLocation();
        this.loadScopeSets();
    }

    public void add(ScopeSet set) {
        this.sets.add(set);
        this.setChanged();
    }

    public void remove(ScopeSet set) {
        this.sets.remove(set);
        set.dispose();
        this.setChanged();
    }

    public void setActiveSet(ScopeSet set) {
        if (this.activeSet != null) {
            this.activeSet.save();
        }
        this.activeSet = set;
        if (!this.activeSet.isImplicit()) {
            this.lastExplicitSet = set;
        }
        this.setChanged();
    }

    public boolean restoreLastExplicitSet() {
        if (this.activeSet != null && this.activeSet.isImplicit() && this.lastExplicitSet != null) {
            this.setActiveSet(this.lastExplicitSet);
            this.setChanged();
            return true;
        }
        return false;
    }

    public static void ensureLocation() {
        IPath location = HelpUIPlugin.getDefault().getStateLocation();
        File dir = (location = location.append("scope_sets")).toFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public void save() {
        ScopeSetManager.ensureLocation();
        for (ScopeSet set : this.sets) {
            set.save();
        }
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ScopeSetManager.class)).getDialogSettings();
        if (this.activeSet != null) {
            settings.put(ACTIVE_SET, this.activeSet.getName());
        }
    }

    public ScopeSet[] getScopeSets(boolean implicit) {
        ArrayList<ScopeSet> result = new ArrayList<ScopeSet>();
        int i = 0;
        while (i < this.sets.size()) {
            ScopeSet set = this.sets.get(i);
            if (set.isImplicit() == implicit) {
                result.add(set);
            }
            if (!implicit && set.isImplicit() && this.activeSet == set) {
                result.add(set);
            }
            ++i;
        }
        return result.toArray(new ScopeSet[result.size()]);
    }

    private void loadScopeSets() {
        this.sets = new ArrayList();
        IPath location = HelpUIPlugin.getDefault().getStateLocation();
        location = location.append("scope_sets");
        File dir = location.toFile();
        this.defSet = null;
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".pref") || name.endsWith(".hist"));
            if (files == null) {
                files = new File[]{};
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name2 = file.getName();
                int loc = name2.lastIndexOf(".pref");
                if (loc != -1) {
                    set = new ScopeSet(name2.substring(0, loc));
                    this.sets.add(set);
                    if (set.isDefault()) {
                        this.defSet = set;
                    }
                } else {
                    loc = name2.lastIndexOf(".hist");
                    if (loc != -1) {
                        set = new HistoryScopeSet(name2.substring(0, loc), null);
                        this.sets.add(set);
                    }
                }
                ++n2;
            }
        }
        if (this.sets.size() == 1) {
            this.activeSet = this.sets.get(0);
        }
        if (this.defSet == null) {
            this.defSet = new ScopeSet();
            this.sets.add(this.defSet);
        }
    }

    public ScopeSet getDefaultScope() {
        return this.defSet;
    }

    public ScopeSet getActiveSet() {
        if (this.activeSet == null) {
            IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ScopeSetManager.class)).getDialogSettings();
            String name = settings.get(ACTIVE_SET);
            this.activeSet = this.findSet(name);
            if (this.activeSet == null) {
                return this.sets.get(0);
            }
            if (!this.activeSet.isImplicit()) {
                this.lastExplicitSet = this.activeSet;
            }
        }
        return this.activeSet;
    }

    public ScopeSet findSet(String name) {
        return this.findSet(name, false);
    }

    public HistoryScopeSet findSearchSet(String expression) {
        for (ScopeSet set : this.sets) {
            HistoryScopeSet sset;
            if (!set.isImplicit() || !(set instanceof HistoryScopeSet) || !(sset = (HistoryScopeSet)set).getExpression().equals(expression)) continue;
            return sset;
        }
        return null;
    }

    public ScopeSet findSet(String name, boolean implicit) {
        ScopeSet defaultSet = null;
        for (ScopeSet set : this.sets) {
            if (name != null && set.isImplicit() == implicit) {
                if (!set.getName().equals(name)) continue;
                return set;
            }
            if (!set.isDefault()) continue;
            defaultSet = set;
        }
        if (!implicit) {
            return defaultSet;
        }
        return null;
    }
}

