/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.knn;

import org.apache.lucene.search.AbstractKnnCollector;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.hnsw.BlockingFloatHeap;
import org.apache.lucene.util.hnsw.FloatHeap;

public final class MultiLeafKnnCollector
implements KnnCollector {
    private static final float DEFAULT_GREEDINESS = 0.9f;
    private static final int DEFAULT_INTERVAL = 255;
    private final BlockingFloatHeap globalSimilarityQueue;
    private final FloatHeap nonCompetitiveQueue;
    private final FloatHeap updatesQueue;
    private final float[] updatesScratch;
    private final int interval;
    private boolean kResultsCollected = false;
    private float cachedGlobalMinSim = Float.NEGATIVE_INFINITY;
    private final AbstractKnnCollector subCollector;

    public MultiLeafKnnCollector(int k, BlockingFloatHeap globalSimilarityQueue, AbstractKnnCollector subCollector) {
        this(k, 0.9f, 255, globalSimilarityQueue, subCollector);
    }

    public MultiLeafKnnCollector(int k, float greediness, int interval, BlockingFloatHeap globalSimilarityQueue, AbstractKnnCollector subCollector) {
        if (greediness < 0.0f || greediness > 1.0f) {
            throw new IllegalArgumentException("greediness must be in [0,1]");
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be positive");
        }
        this.interval = interval;
        this.subCollector = subCollector;
        this.globalSimilarityQueue = globalSimilarityQueue;
        this.nonCompetitiveQueue = new FloatHeap(Math.max(1, Math.round((1.0f - greediness) * (float)k)));
        this.updatesQueue = new FloatHeap(k);
        this.updatesScratch = new float[k];
    }

    @Override
    public boolean earlyTerminated() {
        return this.subCollector.earlyTerminated();
    }

    @Override
    public void incVisitedCount(int count) {
        this.subCollector.incVisitedCount(count);
    }

    @Override
    public long visitedCount() {
        return this.subCollector.visitedCount();
    }

    @Override
    public long visitLimit() {
        return this.subCollector.visitLimit();
    }

    @Override
    public int k() {
        return this.subCollector.k();
    }

    @Override
    public boolean collect(int docId, float similarity) {
        int len;
        boolean firstKResultsCollected;
        boolean localSimUpdated = this.subCollector.collect(docId, similarity);
        boolean bl = firstKResultsCollected = !this.kResultsCollected && this.subCollector.numCollected() == this.k();
        if (firstKResultsCollected) {
            this.kResultsCollected = true;
        }
        this.updatesQueue.offer(similarity);
        boolean globalSimUpdated = this.nonCompetitiveQueue.offer(similarity);
        if (this.kResultsCollected && (firstKResultsCollected || (this.subCollector.visitedCount() & (long)this.interval) == 0L) && (len = this.updatesQueue.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                this.updatesScratch[i] = this.updatesQueue.poll();
            }
            assert (this.updatesQueue.size() == 0);
            this.cachedGlobalMinSim = this.globalSimilarityQueue.offer(this.updatesScratch, len);
            globalSimUpdated = true;
        }
        return localSimUpdated || globalSimUpdated;
    }

    @Override
    public float minCompetitiveSimilarity() {
        if (!this.kResultsCollected) {
            return Float.NEGATIVE_INFINITY;
        }
        return Math.max(this.subCollector.minCompetitiveSimilarity(), Math.min(this.nonCompetitiveQueue.peek(), this.cachedGlobalMinSim));
    }

    @Override
    public TopDocs topDocs() {
        return this.subCollector.topDocs();
    }

    public String toString() {
        return "MultiLeafKnnCollector[subCollector=" + String.valueOf(this.subCollector) + "]";
    }
}

