C
C   THIS PROGRAM INPUTS SCATTERED ELECTRIC FIELD DATA FROM THE SECOND
C  FILE SPECIFIED ON THE COMMAND-LINE AND GENERATES EITHER A SAR IMAGE
C  OR A DYNAMIC SEQUENCE OF SUCH IMAGES.  GENERALLY, IT IS RUN BY THE
C  BASIC PROGRAM NCSARSIM.  IT IS CURRENTLY ASSUMED THAT, FOR LINEAR SARS,
C  THE SAR IS SIMULATED TO BE FLYING IN THE FOURTH OR FIRST QUADRANTS IN
C  THE TARGET COORDINATE SYSTEM (-90 <= AZIMUTH <= 90 DEGREES).  THE FIELD
C  DATA IN THE INPUT FILE MENTIONED ABOVE IS GENERATED BY NEC.  THE FIRST
C  PARAMETER ON THE COMMAND-LINE IS THE NAME OF NEC'S INPUT FILE.  (THIS
C  FILE IS USED HERE TO TRANSFER DATA FROM NCSARSIM TO THIS PROGRAM.)
C  GENERALLY, YOU DON'T NEED TO WORRY ABOUT THESE FILE NAMES.  NCSARSIM
C  CREATES THE COMMAND-LINE.
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMPLEX*16 IMAGE(512,512),SIGNAL(512,256),FIELD(512),J,Z1,Z2,Z3,Z4
     *,ADOWN,AUP,CDEXP
      REAL*8 KXMIN,KXMAX,KYMIN,KYMAX,KMIN,KMAX,KX,KY,IMAGER,IMAGEI,MOM2,
     .IMAGEM
      REAL*4 PADFAC,TANPSI,TANETA,SNGL
      DIMENSION PHI(256)
      INTEGER*2 NXI,NYI,N,NAZA
      INTEGER*1 INTEN(512),INTPOL,ISP,IWIN
      CHARACTER*80 IFILE(300)
      CHARACTER*78 NECLIN
      CHARACTER*3 C
      CHARACTER*2 NECPRE
      CHARACTER*1 ISAR
      COMMON /TYLOR/SLL
      DATA J,PADFAC/(0.D0,1.D0),1./
      PI=4.D0*DATAN(1.D0)
C
C   GET INPUTS FROM USER.
C
      CALL CLEAR
      WRITE(6,*)'WHAT TYPE OF SPECTRUM WINDOW/FILTER WOULD YOU LIKE?'
      WRITE(6,*)' '
      WRITE(6,*)' '
      WRITE(6,*)'1 - BARTLETT                    10 - BOHMAN'
      WRITE(6,*)' '
      WRITE(6,*)'2 - RECTANGULAR                 11 - EXACT BLACKMAN'
      WRITE(6,*)' '
      WRITE(6,*)'3 - HANNING                     12 - KAISER-BESSEL'
      WRITE(6,*)' '
      WRITE(6,*)'4 - HAMMING                     13 - TAYLOR'
      WRITE(6,*)' '
      WRITE(6,*)'5 - BLACKMAN                    14 - MODIFIED TAYLOR'
      WRITE(6,*)' '
      WRITE(6,*)'6 - COSINE                      15 - SVA'
      WRITE(6,*)' '
      WRITE(6,*)'7 - RIESZ'
      WRITE(6,*)' '
      WRITE(6,*)'8 - RIEMANN'
      WRITE(6,*)' '
      WRITE(6,*)'9 - DE LA VALLE-POUSSIN'
      WRITE(6,*)' '
      WRITE(6,*)' '
      WRITE(6,*)'INPUT AN INTEGER (1 - 15).'
   33 CONTINUE
      READ(5,*)IWIN
      IF(IWIN.LT.1.OR.IWIN.GT.15)GO TO 33
      ISVA=IWIN
      IF(IWIN.EQ.15)IWIN=2
C
C   DEFINE DEFAULT SIDELOBE LEVEL FOR OUTPUT PURPOSES.
C
      SLL=0.D0
      IF(IWIN.LT.13.OR.IWIN.GT.14)GO TO 87
      WRITE(6,*)'SIDELOBE LEVEL (dB)?'
      READ(5,*)SLL
      SLL=DABS(SLL)
   87 CONTINUE
      WRITE(6,*)'SPECTRAL THRESHOLD FACTOR?'
      READ(5,*)STFACT
      WRITE(6,*)'NUMBER OF POINTS TO USE IN AZIMUTHAL MOVING AVERAGE?'
      READ(5,*)MAVG
      MAVG=MAVG/2
      WRITE(6,*)'OUTPUT FOR LOW (0), HIGH (1), OR ULTRA-HIGH (2) RESOLUT
     .ION DISPLAY?'
      READ(5,*)IRES
      IF(IRES.NE.1.AND.IRES.NE.2)IRES=0
C
C   DEFINE CENTRAL AZIMUTH ANGLE FOR USE WITH STABILIZED SCENE PROCESS-
C  ING.  (IT'S USED AS A REFERENCE OR OFFSET.)
C
      PHIC=0.D0
      WRITE(6,*)'LOS (0) OR STABILIZED SCENE (1) POLAR INTERPOLATION?'
      READ(5,*)INTPOL
      IF(INTPOL.NE.0)INTPOL=1
C
C   SLANT PLANE IMAGES ARE NOT ALLOWED FOR STABILIZED SCENE PROCESSING.
C
      ISP=1
      IF(INTPOL.EQ.1)GO TO 67
      WRITE(6,*)'  SIMULATE TRADITIONAL SLANT PLANE SAR (0) OR TAKE INTO
     . ACCOUNT TRUE ASPECT OF'
      WRITE(6,*)'TARGET ON FLAT EARTH (1)?'
      READ(5,*)ISP
      IF(ISP.NE.1)ISP=0
   67 CONTINUE
C
C  GET "CONFIGURATION INFORMATION" FROM NEC'S INPUT FILE.
C
      OPEN(1,STATUS='OLD',FILE=' ')
C
C   ISAR = 'L' FOR LINEAR SAR AND 'C' FOR CIRCULAR SAR.
C
C   SPECTRAL IMAGE SIZE IS NX X NY BEFORE ZERO-PADDING.
C
C   BEL0 = STABILIZED SCENE SAR ZENITH ANGLE FOR LINEAR SAR OR CONSTANT
C          ZENITH ANGLE FOR CIRCULAR SAR (degrees).
C
C   NAZA = NUMBER OF AZIMUTHS FOR WHICH DATA EXISTS.
C
C   BFR = STARTING FREQUENCY (Hz).
C
C   EFR = ENDING FREQUENCY.
C
C   N = NUMBER OF FREQUENCIES.
C
C   VS = SAR SPEED (m/s).
C
C   DSAR = STABILIZED SCENE SAR DOWN RANGE FOR LINEAR SAR OR RADIUS OF
C          HORIZONTAL CIRCLE THAT CIRCULAR SAR "ORBITS" ON (m).
C
      OPEN(99,STATUS='UNKNOWN')
      READ(1,1)ISAR
      READ(1,46)NECPRE,NECLIN
      WRITE(99,*)NECLIN
      REWIND 99
      READ(99,*)NX,NY
      REWIND 99
      READ(1,46)NECPRE,NECLIN
      WRITE(99,*)NECLIN
      REWIND 99
      READ(99,*)BEL0
      REWIND 99
      READ(1,46)NECPRE,NECLIN
      WRITE(99,*)NECLIN
      REWIND 99
      READ(99,*)NAZA
      REWIND 99
      READ(1,46)NECPRE,NECLIN
      WRITE(99,*)NECLIN
      REWIND 99
      READ(99,*)BFR,EFR,N
      REWIND 99
      READ(1,46)NECPRE,NECLIN
      WRITE(99,*)NECLIN
      REWIND 99
      READ(99,*)VS,DSAR
      CLOSE(99)
      CLOSE(1)
C
C   GET NUMBER OF DYNAMIC IMAGES TO BE CONSTRUCTED.
C
      WRITE(6,98)NAZA
      READ(5,*)NAZDYN
      IF(NAZDYN.LT.2)NAZDYN=2
      IF(NAZDYN.GT.NAZA)NAZDYN=NAZA
      NOL=0
      IF(NAZDYN.EQ.NAZA)GO TO 155
      WRITE(6,156)NAZDYN-1
      READ(5,*)NOL
      IF(NOL.LT.0)NOL=0
      IF(NOL.GT.NAZDYN-1)NOL=NAZDYN-1
  155 CONTINUE
      LSTEP=NAZDYN-NOL
      NDYN=(NAZA-NOL)/LSTEP
      IF(NDYN.GT.300)NDYN=300
C
C   A LITTLE PARANOIA NEVER HURT ANYTHING.
C
      IF(NDYN.LT.1)LSTEP=1
      IF(NDYN.LT.1)NDYN=1
      IF(NDYN.GT.1)WRITE(6,*)'IMAGE MINIMUM AND MAXIMUM THRESHOLD FACTOR
     .S?'
      IF(NDYN.GT.1)READ(5,*)TFACTN,TFACTX
      WRITE(6,*)' '
      WRITE(6,*)'INPUTTING FIELD DATA.'
      WRITE(6,*)' '
C
C   INPUT FIELD DATA.  (GET AZIMUTH ANGLES IN PROCESS.  CONVERT AZIMUTH
C  ANGLES TO RADIANS, AND FOR A LINEAR SAR, TAKE THEIR TANGENTS.  (FOR
C  LINEAR SARS, IT IS THE TANGENT OF THE AZIMUTH THAT INCREMENTS
C  UNIFORMLY, NOT THE ANGLE ITSELF.  IN ALL REFERENCES TO "PHI" OR
C  "AZIMUTH," BELOW, IT IS REALLY THE TANGENT OF THE AZIMUTH THAT IS
C  MEANT UNLESS EXPLICITLY MADE CLEAR OTHERWISE.)
C
      OPEN(1,STATUS='OLD',FILE=' ')
      DO 21 I=1,NAZA
      DO 2 K=1,N
      READ(1,*)PHI(I),EMAG,PHASE
      PHI(I)=PHI(I)*PI/180.D0
      IF(ISAR.EQ.'L')PHI(I)=DTAN(PHI(I))
      SIGNAL(K,I)=EMAG*CDEXP(J*PHASE*PI/180.D0)
    2 CONTINUE
   21 CONTINUE
      CLOSE(1)
C
C   DEFINE A FEW MORE SUNDRY THINGS.
C
      DAZ=(PHI(NAZA)-PHI(1))/DFLOAT(NAZA-1)
      DF=(EFR-BFR)/DFLOAT(N-1)
C
C   AVERAGE AZIMUTHAL FIELD DATA FOR EACH FREQUENCY (IF MAVG > 0).
C
      IF(MAVG.LT.1)GO TO 88
      WRITE(6,*)'APPLYING MOVING AVERAGE ACROSS AZIMUTH.'
      WRITE(6,*)' '
      DO 89 I=1,N
      DO 90 K=1,NAZA
      FIELD(K)=(0.D0,0.D0)
      KB=K-MAVG
      IF(KB.LT.1)KB=1
      KE=KB+2*MAVG
      IF(KE.GT.NAZA)KE=NAZA
      DO 91 L=KB,KE
      FIELD(K)=FIELD(K)+SIGNAL(I,L)
   91 CONTINUE
      FIELD(K)=FIELD(K)/DFLOAT(KE-KB+1)
   90 CONTINUE
      DO 92 K=1,NAZA
      SIGNAL(I,K)=FIELD(K)
   92 CONTINUE
   89 CONTINUE
   88 CONTINUE
      IF(NDYN.GT.1)GO TO 99
      WRITE(6,*)'DYNAMIC IMAGING NOT BEING PERFORMED.'
      WRITE(6,*)' '
   99 CONTINUE
C
C   DEFINE FILE NAMES TO STORE IMAGES.
C
      DO 103 I=1,NDYN
      IF(I.LE.9)WRITE(C,107)I,'  '
      IF(I.GT.9.AND.I.LT.100)WRITE(C,108)I,' '
      IF(I.GT.99)WRITE(C,111)I
      IFILE(I)='SAR.'//C
  103 CONTINUE
      IF(NDYN.EQ.1)IFILE(1)='SAR.BIN'
C
C   INTERPOLATE SIGNAL ARRAY AND PUT ON RECTANGULAR GRID IN KX AND KY
C  FOR EACH DYNAMIC IMAGE.  FOR DYNAMIC IMAGING, GET CENTROID
C  COORDINATES AND SECOND MOMENT FOR EACH IMAGE (AND OUTPUT TO FILE), IN
C  ADDITION TO OUTPUTTING THE IMAGES.
C
      KMIN=2.D0*PI*BFR/2.9979D8
      KMAX=2.D0*PI*EFR/2.9979D8
C
C   OPEN CENTROID & SECOND MOMENT OUTPUT FILES FOR DYNAMIC IMAGING.
C
      IF(NDYN.GT.1)OPEN(1,STATUS='UNKNOWN',FILE='CENTROID.CRS')
      IF(NDYN.GT.1)OPEN(3,STATUS='UNKNOWN',FILE='CENTROID.RNG')
      IF(NDYN.GT.1)OPEN(4,STATUS='UNKNOWN',FILE='MOMENT2.TIM')
C
C   NXI AND NYI GIVE THE ACTUAL IMAGE/SPECTRAL SIZES, AFTER ZERO-PADDING
C  SPECTRUM.
C
      NXI=2*NX
      NYI=2*NY
C
C   THE AZIMUTHAL DEPENDENCE IN THE FIELD DATA IS INDEXED VIA THE SAR
C  SLOW TIME.  INITIALIZE IT AND GET SAR PULSE REPETITION INTERVAL.  (TP
C  IS NOT ACTUALLY USED IN INTERPOLATION PROCESS.)
C
      TP=0.D0
      DT=DSAR*(PHI(NAZA)-PHI(1))/VS/DFLOAT(NAZA-1)
      DO 100 L=1,NDYN
      WRITE(6,*)'  INTERPOLATING POLAR DATA TO CARTESIAN WAVE VECTOR FOR
     .MAT AND GENERATING'
      WRITE(6,*)'CARTESIAN SPECTRAL PLOT.  (SPECTRAL PLOT ISN''T GENERAT
     .ED FOR DYNAMIC IMAGING.)'
      WRITE(6,*)' '
C
C   THIS MAY NOT BE THE MOST EFFICIENT WAY OF CALCULATING THE LIMITS ON
C  THE WAVE VECTOR COMPONENTS, BUT IT'S THE SAFEST GIVEN ALL THE DIFFER-
C  ENT SQUINT ANGLE AND SAR LENGTH COMBINATIONS!  (THIS CALCULATION IS
C  BASED ON THE ASSUMPTION THAT NO DYNAMIC IMAGING IS BEING PERFORMED.
C  THAT WAY, ALL DYNAMIC IMAGES HAVE THE SAME RESOLUTIONS/SCALE
C  FACTORS.)
C
      NAZMIN=(L-1)*LSTEP+1
      NAZMAX=NAZMIN+NAZDYN-1
      IF(L.GT.1)GO TO 109
C
C   GET SLANT PLANE GEOMETRICAL PARAMETERS AND MAKE SLANT/GROUND PLANE
C  DECISIONS.  (TANPSI AND TANETA MAY CHANGE LATER.)
C
      TANPSI=SNGL(DTAN((90.D0-BEL0)*PI/180.D0))
      TANETA=0.
      BEL=(90.D0*DFLOAT(1-ISP)+DFLOAT(ISP)*BEL0)*PI/180.D0
C
C   ISC IS A SWITCH TO SKIP PROMPT, BELOW.
C
      ISC=-1
C
C  THE REST OF THIS WILL BE DONE BELOW FOR LOS PROCESSING.
C
      IF(INTPOL.NE.1)GO TO 109
      KXMAX=-1.D100
      KXMIN=1.D100
      KYMAX=KXMAX
      KYMIN=KXMIN
      DO 60 I=1,NAZA
C
C   PHIS = REAL AZIMUTH ANGLE, NOT A TANGENT, IN EARTH-FIXED COORDINATE
C          SYSTEM.
C
      PHIS=PHI(I)
      IF(ISAR.EQ.'L')PHIS=DATAN(PHIS)
C
C   ZENITH HERE IS ONLY THE ACTUAL ZENITH ANGLE FOR GROUND PLANE IMAGES.
C
      ZENITH=PI/2.D0
      IF(DABS(BEL-PI/2.D0).GT.1.D-10.AND.DABS(DCOS(PHIS)).GT.1.D-10.AND.
     .ISAR.EQ.'L')ZENITH=DATAN(DTAN(BEL)/DCOS(PHIS))
      IF(ISAR.EQ.'C')ZENITH=BEL
      TMAX=KMAX*DCOS(PHIS)*DSIN(ZENITH)
      TMIN=KMIN*DCOS(PHIS)*DSIN(ZENITH)
      IF(TMAX.GT.KXMAX)KXMAX=TMAX
      IF(TMIN.LT.KXMIN)KXMIN=TMIN
      IF(TMIN.GT.KXMAX)KXMAX=TMIN
      IF(TMAX.LT.KXMIN)KXMIN=TMAX
C
C   THIS ZENITH IS THE TRUE ZENITH ANGLE FOR LINEAR SARS.  (ACTUALLY, AS
C  IT IS RIGHT NOW, IF THIS SECTION OF CODE IS EXECUTING, LOS INTERPO-
C  LATION IS NOT BEING PERFORMED AND A GROUND PLANE IMAGE IS BEING
C  GENERATED.  HENCE, BOTH VALUES OF ZENITH ARE THE ACTUAL ZENITH ANGLE.
C  HOWEVER, WHEN I FIGURE OUT HOW TO MAKE SLANT PLANE IMAGES WITH
C  STABILIZED SCENE PROCESSING, THAT WILL CHANGE--WHICH IS WHY I'VE
C  KEPT THIS CODING STRUCTURE IN PLACE.  TWO DIFFERENT VALUES OF ZENITH
C  *ARE* USED BELOW, HOWEVER, FOR SLANT PLANE/LOS PROCESSING.)
C
      ZENITH=PI/2.D0
      IF(DABS(BEL0-90.D0).GT.1.D-10.AND.DABS(DCOS(PHIS)).GT.1.D-10.AND.
     .ISAR.EQ.'L')ZENITH=DATAN(DTAN(BEL0*PI/180.D0)/DCOS(PHIS))
      IF(ISAR.EQ.'C')ZENITH=BEL
      TMIN=KMIN*DSIN(PHIS)*DSIN(ZENITH)
      TMAX=KMAX*DSIN(PHIS)*DSIN(ZENITH)
      IF(TMIN.LT.KYMIN)KYMIN=TMIN
      IF(TMAX.LT.KYMIN)KYMIN=TMAX
      IF(TMIN.GT.KYMAX)KYMAX=TMIN
      IF(TMAX.GT.KYMAX)KYMAX=TMAX
   60 CONTINUE
  112 CONTINUE
      DKX=(KXMAX-KXMIN)/DFLOAT(NX-1)
      DKY=(KYMAX-KYMIN)/DFLOAT(NY-1)
      DKXS=DKX/2.D0/PI
      DKYS=DKY/2.D0/PI
C
C   CALCULATE RANGE AND CROSS RANGE RESOLUTIONS.  (THERE IS AN
C  ADDITIONAL FACTOR OF .5 HERE BECAUSE OF EVENTUAL ZERO-PADDING.)
C  IF THEY AREN'T EQUAL, CHANGE APPROPRIATE COMPONENT WAVE VECTOR LIMITS
C  AND RECALCULATE--AFTER ASKING USER IF THIS IS OKAY.
C
      DX=.25D0/DFLOAT(NX)/DKXS
      DY=.25D0/DFLOAT(NY)/DKYS
      IF(DABS(DX-DY).LT.1.D-5)GO TO 109
      IF(ISC.NE.-1)GO TO 114
      WRITE(6,*)'  DO YOU WANT EQUAL RANGE AND CROSS RANGE SCALES (0 = N
     .O / 1 = YES)?'
      WRITE(6,118)DX,DY
      READ(5,*)ISC
      ISC=IABS(ISC)
      WRITE(6,*)' '
  114 CONTINUE
      IF(ISC.NE.1)GO TO 109
      IF(DX.GT.DY)GO TO 113
C
C   INCREASE DX--MAKE KXMIN LARGER AND DECREASE KXMAX.
C
      WRITE(6,*)'DECREASING RANGE RESOLUTION.'
      WRITE(6,*)' '
      DKX=DKX-PI/DFLOAT(NX)/(2.D0*DY)
      KXMIN=KXMIN+DFLOAT(NX-1)*DKX/2.D0
      KXMAX=KXMAX-DFLOAT(NX-1)*DKX/2.D0
      GO TO 112
  113 CONTINUE
C
C   MAKE DY LARGER--INCREASE KYMIN AND DECREASE KYMAX.
C
      WRITE(6,*)'DECREASING CROSS RANGE RESOLUTION.'
      WRITE(6,*)' '
      DKY=DKY-PI/DFLOAT(NY)/(2.D0*DX)
      KYMIN=KYMIN+DFLOAT(NY-1)*DKY/2.D0
      KYMAX=KYMAX-DFLOAT(NY-1)*DKY/2.D0
      GO TO 112
  109 CONTINUE
      IF(INTPOL.EQ.1)GO TO 68
C
C   LOS PROCESSING IS BEING PERFORMED.  GET CENTRAL SAR AZIMUTH ANGLE IN
C  FIXED COORDINATE SYSTEM AND RECALCULATE SLANT PLANE GEOMETRICAL
C  PARAMETERS.  (THESE HAVE TO CHANGE FOR EACH VALUE OF L BECAUSE INTER-
C  POLATION PROCESS EITHER NEEDS THEM OR BECAUSE NOT CHANGING THEM JUST
C  REALLY DOESN'T MAKE ANY SENSE.  ALSO, THIS IS ONLY DONE FOR A LINEAR
C  SAR; THEY ARE ALREADY SUFFICIENTLY DEFINED FOR A CIRCULAR SAR.)
C
      PHI1=PHI(1)+DAZ*DFLOAT(NAZMIN-1)
      PHI2=PHI(1)+DAZ*DFLOAT(NAZMAX-1)
C
C   PHIC IS ALSO AN ACTUAL ANGLE, NOT A TANGENT.
C
      PHIC=(PHI1+PHI2)/2.D0
      IF(ISAR.EQ.'L')PHIC=(DATAN(PHI1)+DATAN(PHI2))/2.D0
C
C   LOS IMAGES ALSO NEED CARTESIAN GRID PARAMETERS.  (THE ONES THAT
C  WOULD HAVE BEEN DEFINED ABOVE DON'T DEFINE A SYMMETRICALLY ORIENTED
C  GRID UNLESS THE ZENITH ANGLE IS 90 DEGREES.)
C
      IF(L.GT.1)GO TO 110
      ZENITH=PI/2.D0
      IF(DABS(BEL-PI/2.D0).GT.1.D-10.AND.DABS(DCOS(PHIC)).GT.1.D-10.AND.
     .ISAR.EQ.'L')ZENITH=DATAN(DTAN(BEL)/DCOS(PHIC))
      IF(ISAR.EQ.'C')ZENITH=BEL
      DELPHI=(PHI2-PHI1)/2.D0
C
C   ONCE AGAIN, WORK WITH REAL ANGLES.
C
      IF(ISAR.EQ.'L')DELPHI=(DATAN(PHI2)-DATAN(PHI1))/2.D0
      KXMIN=KMIN*DSIN(ZENITH)*DCOS(DELPHI)
      ARG=DAZ*DFLOAT(NAZDYN-2*(NAZDYN/2)-1)/2.D0
      IF(ISAR.EQ.'L')ARG=(DATAN(PHI(NAZA))-DATAN(PHI(1)))*ARG/DAZ/
     .DFLOAT(NAZA-1)
      KXMAX=KMAX*DCOS(ARG)*DSIN(ZENITH)
      ZENITH=PI/2.D0
      IF(DABS(BEL0-90.D0).GT.1.D-10.AND.DABS(DCOS(PHIC)).GT.1.D-10.AND.
     .ISAR.EQ.'L')ZENITH=DATAN(DTAN(BEL0*PI/180.D0)/DCOS(PHIC))
      IF(ISAR.EQ.'C')ZENITH=BEL
      KYMAX=KMAX*DSIN(ZENITH)*DSIN(DELPHI)
      KYMIN=-KYMAX
C
C   STATEMENT 115 IS FOR FORCING DX AND DY TO BE THE SAME (SEE ABOVE).
C
  115 CONTINUE
      DKX=(KXMAX-KXMIN)/DFLOAT(NX-1)
      DKY=(KYMAX-KYMIN)/DFLOAT(NY-1)
      DKXS=DKX/2.D0/PI
      DKYS=DKY/2.D0/PI
      DX=.25D0/DFLOAT(NX)/DKXS
      DY=.25D0/DFLOAT(NY)/DKYS
      IF(DABS(DX-DY).LT.1.D-5)GO TO 110
      IF(ISC.NE.-1)GO TO 117
      WRITE(6,*)'  DO YOU WANT EQUAL RANGE AND CROSS RANGE SCALES (0 = N
     .O / 1 = YES)?'
      WRITE(6,118)DX,DY
      READ(5,*)ISC
      ISC=IABS(ISC)
      WRITE(6,*)' '
  117 CONTINUE
      IF(ISC.NE.1)GO TO 110
      IF(DX.GT.DY)GO TO 116
C
C   INCREASE DX--MAKE KXMIN LARGER AND DECREASE KXMAX.
C
      WRITE(6,*)'DECREASING RANGE RESOLUTION.'
      WRITE(6,*)' '
      DKX=DKX-PI/DFLOAT(NX)/(2.D0*DY)
      KXMIN=KXMIN+DFLOAT(NX-1)*DKX/2.D0
      KXMAX=KXMAX-DFLOAT(NX-1)*DKX/2.D0
      GO TO 115
  116 CONTINUE
C
C   MAKE DY LARGER--INCREASE KYMIN AND DECREASE KYMAX.
C
      WRITE(6,*)'DECREASING CROSS RANGE RESOLUTION.'
      WRITE(6,*)' '
      DKY=DKY-PI/DFLOAT(NY)/(2.D0*DX)
      KYMIN=KYMIN+DFLOAT(NY-1)*DKY/2.D0
      KYMAX=KYMAX-DFLOAT(NY-1)*DKY/2.D0
      GO TO 115
  110 CONTINUE
C
C   DON'T NEED NEW SLANT PLANE GEOMETRICAL FACTORS FOR CIRCULAR SAR.
C
      IF(ISAR.EQ.'C')GO TO 68
      TANPSI=0.
      IF(DABS(BEL0-90.D0).GT.1.D-10.AND.DABS(BEL0).GT.1.D-10)TANPSI=
     .SNGL(DCOS(PHIC)/DTAN(BEL0*PI/180.D0))
      TANETA=SNGL(DTAN(PHIC))*TANPSI
   68 CONTINUE
C
C   NX X NY IMAGE SPATIAL SPECTRUM IS PUT IN CENTER OF (2 * NX) X
C  (2 * NY) SPACE SO EDGES CAN LATER BE FILLED WITH ZEROS.
C
C   OUTPUT STATIC SPECTRAL IMAGE IN SPLOT FORMAT IF DYNAMIC IMAGING
C  ISN'T BEING PERFORMED.
C
      IF(NDYN.GT.1)GO TO 101
      OPEN(1,STATUS='UNKNOWN',FILE='PHASE.PLT')
      WRITE(1,*)'CLRPLOT'
      WRITE(1,*)'CLRDATA'
  101 CONTINUE
      DO 5 I=NY/2+1,3*NY/2
      KY=KYMIN+DKY*DFLOAT(I-NY/2-1)
C
C   MORE THAN 200 RANGE SEQUENCES AREN'T OUTPUT BECAUSE OF SPLOT'S LIMIT
C  ON THE NUMBER OF DATA SETS.
C
      IF(NDYN.EQ.1.AND.I-NY/2.LE.200)WRITE(1,*)'READY ',NX
      DO 42 K=NX/2+1,3*NX/2
      KX=KXMIN+DKX*DFLOAT(K-NX/2-1)
C
C   FOR NOW, PHIS IS A REAL ANGLE.
C
      PHIS=DATAN2(KY,KX)+PHIC
      ZENITH=PI/2.D0
      IF(DABS(BEL-PI/2.D0).GT.1.D-10.AND.DABS(DCOS(PHIS)).GT.1.D-10.AND.
     .ISAR.EQ.'L')ZENITH=DATAN(DTAN(BEL)/DCOS(PHIS))
      IF(ISAR.EQ.'C')ZENITH=BEL
C
C   ALSO NEED TRUE ZENITH ANGLE (FOR LINEAR SARS, WHICH ZENITH WON'T BE
C  FOR SLANT PLANE IMAGE).
C
      Z0=PI/2.D0
      IF(DABS(BEL0-90.D0).GT.1.D-10.AND.DABS(DCOS(PHIS)).GT.1.D-10.AND.
     .ISAR.EQ.'L')Z0=DATAN(DTAN(BEL0*PI/180.D0)/DCOS(PHIS))
      IF(ISAR.EQ.'C')Z0=ZENITH
      FS=2.9979D8*DSQRT((KX/DSIN(ZENITH))**2+(KY/DSIN(Z0))**2)/2.D0/PI
C
C   GET INDICES INTO SIGNAL.  (AZIMUTHAL INDEX IS BASED ON SAR SLOW
C  TIME.)
C
C   NOW THAT PHIS IS NO LONGER NEEDED AS A REAL ANGLE FOR A LINEAR SAR,
C  TAKE ITS TANGENT IF NECESSARY.
C
      IF(ISAR.EQ.'L')PHIS=DTAN(PHIS)
      INDFRQ=IDINT((FS-BFR)/DF+1.D-6)+1
      SLOWTM=DSAR*(PHIS-PHI(1))/VS
      INDPHI=IDINT(SLOWTM/DT+1.D-6)+1
      PHI1=PHI(1)+DAZ*DFLOAT(INDPHI-1)
      SLOW1=DSAR*(PHI1-PHI(1))/VS
C
C   FOR EACH FIELD COMPONENT, GET FOUR POINTS BOUNDING PHIS AND FS, AND
C  INTERPOLATE.
C
      IMAGE(K,I)=(0.D0,0.D0)
      IF(INDFRQ.LT.1.OR.INDFRQ.GT.N.OR.INDPHI.LT.NAZMIN.OR.INDPHI.GT.
     .NAZMAX)GO TO 75
      IF(INDFRQ.EQ.N)GO TO 49
      IF(INDPHI.EQ.NAZMAX)GO TO 53
      Z1=SIGNAL(INDFRQ,INDPHI)
      Z2=SIGNAL(INDFRQ,INDPHI+1)
      Z3=SIGNAL(INDFRQ+1,INDPHI)
      Z4=SIGNAL(INDFRQ+1,INDPHI+1)
      ADOWN=(Z2-Z1)*(SLOWTM-SLOW1)/DT+Z1
      AUP=(Z4-Z3)*(SLOWTM-SLOW1)/DT+Z3
      IMAGE(K,I)=(AUP-ADOWN)*(FS-BFR-DF*DFLOAT(INDFRQ-1))/DF+ADOWN
      GO TO 75
   49 CONTINUE
C
C   SPECIAL CASE OF FS BEING AT TOP OF ARRAY--TEST FOR FURTHER SIMPLIFY-
C  ING CASE OF PHIS ALSO BEING AT TOP BEFORE PROCEEDING.
C
      IMAGE(K,I)=SIGNAL(N,NAZMAX)
      IF(INDPHI.EQ.NAZMAX)GO TO 75
      Z1=SIGNAL(N,INDPHI)
      Z2=SIGNAL(N,INDPHI+1)
      IMAGE(K,I)=(Z2-Z1)*(SLOWTM-SLOW1)/DT+Z1
      GO TO 75
   53 CONTINUE
C
C   SPECIAL CASE OF PHIS BEING MAXIMUM ANGLE CONSIDERED BY NEC.
C
      Z1=SIGNAL(INDFRQ,NAZMAX)
      Z2=SIGNAL(INDFRQ+1,NAZMAX)
      IMAGE(K,I)=(Z2-Z1)*(FS-BFR-DF*DFLOAT(INDFRQ-1))/DF+Z1
   75 CONTINUE
C
C   WINDOW IMAGE SPECTRUM.
C
      IMAGE(K,I)=IMAGE(K,I)*WINDOW(DFLOAT(K-NX-1),DFLOAT(NX/2),IWIN)*
     .WINDOW(DFLOAT(I-NY-1),DFLOAT(NY/2),IWIN)
   42 CONTINUE
      IF(NDYN.EQ.1.AND.I-NY/2.LE.200)WRITE(1,*)(CDABS(IMAGE(K,I)),
     .K=NX/2+1,3*NX/2)
    5 CONTINUE
C
C   GET MINIMUM AND MAXIMUM SPECTRAL FIELD MAGNITUDES (FOR
C  THRESHOLDING).
C
      SMAX=-1.D0
      SMIN=1.D200
      DO 122 I=NY/2+1,3*NY/2
      DO 123 K=NX/2+1,3*NX/2
      IMAGEM=CDABS(IMAGE(K,I))
      IF(IMAGEM.GT.SMAX)SMAX=IMAGEM
      IF(IMAGEM.LT.SMIN)SMIN=IMAGEM
  123 CONTINUE
  122 CONTINUE
C
C   DEFINE SPECTRAL THRESHOLD FACTOR.
C
      THRESH=SMIN+(SMAX-SMIN)/STFACT
C
C   SET TO ZERO ANY SPECTRAL VALUE LESS THAN THRESH AND OFFSET DOWNWARDS
C  ALL OTHER VALUES, PRESERVING PHASE IN PROCESS.  (THIS TENDS TO FILTER
C  OUT "POINT SOURCES" IN IMAGE.)
C
      IF(THRESH.LE.SMIN)GO TO 126
      DO 124 I=NY/2+1,3*NY/2
      DO 125 K=NX/2+1,3*NX/2
      IMAGEM=CDABS(IMAGE(K,I))
      IF(IMAGEM.LT.THRESH)GO TO 55
      IMAGER=DREAL(IMAGE(K,I))
      IMAGEI=DREAL(-J*IMAGE(K,I))
      PHASE=0.D0
      IF(IMAGEI.NE.0.D0)PHASE=DSIGN(PI/2.D0,IMAGEI)
      IF(IMAGER.NE.0.D0)PHASE=DATAN(IMAGEI/IMAGER)
      IF(IMAGER.LT.0.D0)PHASE=PHASE+PI
      IMAGE(K,I)=(IMAGEM-THRESH)*CDEXP(J*PHASE)
      GO TO 125
   55 CONTINUE
      IMAGE(K,I)=(0.D0,0.D0)
  125 CONTINUE
  124 CONTINUE
  126 CONTINUE
C
C   FINISH SPLOT COMMAND FILE FOR STATIC IMAGE.
C
      IF(NDYN.GT.1)GO TO 102
      IF(NY.LE.200)WRITE(1,*)'READZ ',NY
      IF(NY.GT.200)WRITE(1,*)'READZ 200'
      IF(NY.LE.200)WRITE(1,*)(K-1,K=1,NY)
      IF(NY.GT.200)WRITE(1,*)(K-1,K=1,200)
      WRITE(1,*)'OFFSETX -1'
      WRITE(1,*)'SCALEX ',DKXS*2.
      WRITE(1,*)'SCALEZ ',DKYS*2.
      WRITE(1,*)'OFFSETX ',KXMIN/PI
      WRITE(1,*)'OFFSETZ ',KYMIN/PI
      WRITE(1,*)'XLABEL k-range (m^-1)'
      WRITE(1,*)'YLABEL SPECTRAL MAGNITUDE'
      WRITE(1,*)'ZLABEL k-x range (m^-1)'
      WRITE(1,*)'YSTART 0'
      WRITE(1,*)'PLOT3D SURFACE'
      CLOSE(1)
  102 CONTINUE
      WRITE(6,*)'ZERO-PADDING CARTESIAN SPECTRUM.'
      WRITE(6,*)' '
C
C   PAD EDGES OF IMAGE SPECTRUM WITH ZEROS.
C
      DO 71 I=1,NY/2
      DO 72 K=1,2*NX
      IMAGE(K,I)=(0.D0,0.D0)
      IMAGE(K,I+3*NY/2)=(0.D0,0.D0)
   72 CONTINUE
   71 CONTINUE
      DO 73 I=NY/2+1,3*NY/2
      DO 74 K=1,NX/2
      IMAGE(K,I)=(0.D0,0.D0)
      IMAGE(K+3*NX/2,I)=(0.D0,0.D0)
   74 CONTINUE
   73 CONTINUE
      WRITE(6,*)'FORMING IMAGE (FFTING).'
      WRITE(6,*)' '
C
C   FOURIER TRANSFORM IMAGE TO XY DOMAIN.
C
      CALL FFT2(IMAGE,NXI,NYI,DKXS,DKYS)
      IF(ISVA.NE.15)GO TO 70
      WRITE(6,*)'APPLYING SVA TO IMAGE.'
      WRITE(6,*)' '
C
C   PERFORM SPATIALLY VARIANT APODIZATION ON IMAGE ONE ROW/COLUMN AT A
C  TIME.
C
      DO 76 I=1,NYI
      DO 77 K=1,NXI
      FIELD(K)=IMAGE(K,I)
   77 CONTINUE
      CALL SVA(FIELD,INT4(NXI))
      DO 78 K=1,NXI
      IMAGE(K,I)=FIELD(K)
   78 CONTINUE
   76 CONTINUE
      DO 79 K=1,NXI
      DO 80 I=1,NYI
      FIELD(I)=IMAGE(K,I)
   80 CONTINUE
      CALL SVA(FIELD,INT4(NYI))
      DO 81 I=1,NYI
      IMAGE(K,I)=FIELD(I)
   81 CONTINUE
   79 CONTINUE
   70 CONTINUE
C
C   GET MINIMUM AND MAXIMUM (FIELD) PIXEL STRENGTHS--USING POWER PIXEL
C  STRENGTHS GREATLY LIMITS THE DYNAMIC RANGE UNLESS A LOGARITHMIC SCALE
C  IS USED.  (DON'T COUNT ZERO PIXEL STRENGTHS.)
C
      PMIN=1.D200
      PMAX=-1.D200
      DO 61 I=1,NYI
      DO 62 K=1,NXI
      PIXEL=CDABS(IMAGE(K,I))
      IF(PIXEL.LT.PMIN.AND.PIXEL.GT.0.D0)PMIN=PIXEL
      IF(PIXEL.GT.PMAX)PMAX=PIXEL
   62 CONTINUE
   61 CONTINUE
      WRITE(6,*)'OUTPUTTING IMAGE.'
      WRITE(6,*)' '
C
C   FOR BASIC IMAGE-DISPLAYER, SET INTENSITIES AND OUTPUT THEM TO A
C  FILE.
C
      BIN=PMAX-PMIN
C
C   ONLY ONE OF THE TERMS ON THE RIGHT IN BIN WILL BE NONZERO.  (THAT
C  IS, UNLESS IRES = 2, IN WHICH CASE THE FIRST EXPRESSION FOR BIN IS
C  IRRELEVANT.)
C
      IF(IRES.NE.2)BIN=DFLOAT(1-IRES)*BIN/8.D0+DFLOAT(IRES)*BIN/62.D0
      IF(IRES.EQ.2)BIN=BIN/254.D0
      OPEN(2,STATUS='UNKNOWN',FORM='BINARY',FILE=IFILE(L))
      WRITE(2)NXI,NYI,SNGL(DX),SNGL(DY)
C
C   DYNAMIC AND LOWER RESOLUTION IMAGES DON'T HAVE ALL THE HEADER
C  INFORMATION.
C
      IF(NDYN.GT.1.OR.IRES.NE.2)GO TO 69
C
C   IF SVA WAS USED, CHANGE SIGN OF IWIN SO WHATEVER PROGRAM READING
C  OUTPUT FILE CAN DISTINGUISH SVA PROCESSING FROM RECTANGULAR WINDOW-
C  ING.
C
      IF(ISVA.EQ.15)IWIN=-IWIN
C
C   CONVERT STARTING AND ENDING AZIMUTH TANGENTS BACK TO ANGLES IN
C  DEGREES.
C
      IF(ISAR.EQ.'L')PHI(1)=DATAN(PHI(1))
      IF(ISAR.EQ.'L')PHI(NAZA)=DATAN(PHI(NAZA))
      BAZ=PHI(1)*180.D0/PI
      EAZ=PHI(NAZA)*180.D0/PI
      WRITE(2)PADFAC,PADFAC,ISAR,SNGL(2.D0*KXMIN),SNGL(2.D0*KXMAX),
     .SNGL(2.D0*KYMIN),SNGL(2.D0*KYMAX),ISP,INTPOL,SNGL(BFR),SNGL(EFR),N
     *,SNGL(BAZ),SNGL(EAZ),NAZA,TANPSI,TANETA,IWIN,SNGL(SLL)
   69 CONTINUE
      DO 63 I=1,NYI
      DO 64 K=1,NXI
      PIXEL=CDABS(IMAGE(K,I))
      INTEN(K)=0
      IF(PIXEL.GE.PMIN)INTEN(K)=IDINT((PIXEL-PMIN)/BIN+1.D-6)+1
C
C   IF DYNAMIC IMAGING ISN'T BEING PERFORMED, ABOVE PIXELIZATION IS
C  IRRELEVANT UNLESS THE IMAGE IS BEING GENERATED IN EITHER OF THE TWO
C  LOWER RESOLUTIONS.  IMAGE IS OUTPUT IN COMPLEX FORM FOR STATIC IMAGES
C  WHEN IRES = 2.  (THE FACTOR OF .25 ARISES BECAUSE OF HOW THE WAVE
C  VECTOR PARAMETERS ARE SCALED--THE SAME REASON THAT KXMIN, KXMAX,
C  KYMIN, AND KYMAX WERE MULTIPLIED BY 2 UPON OUTPUT.)
C
      IF(IRES.EQ.2.AND.NDYN.EQ.1)WRITE(2)SNGL(.25D0*DREAL(IMAGE(K,I))),
     .SNGL(.25D0*DREAL(-J*IMAGE(K,I)))
   64 CONTINUE
      IF(IRES.NE.2.OR.NDYN.GT.1)WRITE(2)(INTEN(K),K=1,NXI)
   63 CONTINUE
      CLOSE(2)
      IF(NDYN.EQ.1)GO TO 100
      WRITE(6,*)'CALCULATING CENTROID AND SECOND MOMENT.'
      WRITE(6,*)' '
C
C   GET RANGE AND CROSS RANGE CENTROIDS (MEASURED FROM CENTER OF IMAGE)
C  AND (NORMALIZED) SECOND MOMENT.
C
      CNTSUM=0.D0
      CENTX=0.D0
      CENTY=0.D0
      MOM2=0.D0
      DO 104 I=1,NYI
      Y=DY*DFLOAT(I-NYI/2-1)
      DO 105 K=1,NXI
      X=DX*DFLOAT(K-NXI/2-1)
      IMAGEM=CDABS(IMAGE(K,I))
      IF(IMAGEM.LT.PMIN+(PMAX-PMIN)/TFACTN)GO TO 105
      IF(IMAGEM.GT.PMAX-(PMAX-PMIN)/TFACTX)GO TO 105
      CNTSUM=CNTSUM+IMAGEM
      CENTX=CENTX+X*IMAGEM
      CENTY=CENTY+Y*IMAGEM
      MOM2=MOM2+IMAGEM*(X**2+Y**2)
  105 CONTINUE
  104 CONTINUE
C
C   DON'T BOTHER WITH FINAL CALCULATION/OUTPUT OF CENTROID IF ALL PIXEL
C  DATA IS ZERO.
C
      IF(CNTSUM.EQ.0.D0)GO TO 100
      CENTX=CENTX/CNTSUM
      CENTY=CENTY/CNTSUM
      MOM2=MOM2/CNTSUM
      WRITE(3,*)TP,CENTX
      WRITE(1,*)TP,CENTY
      WRITE(4,*)TP,MOM2
C
C   UPDATE SLOW TIME.
C
      TP=TP+DT*DFLOAT(LSTEP)
  100 CONTINUE
      IF(NDYN.GT.1)CLOSE(1)
      IF(NDYN.GT.1)CLOSE(3)
      IF(NDYN.GT.1)CLOSE(4)
      STOP
    1 FORMAT(3X,A1)
   46 FORMAT(A2,A78)
   98 FORMAT('   YOU HAVE ',I3,' TOTAL AZIMUTH ANGLES.  HOW MANY DO YOU
     .WANT TO USE IN EACH'/' DYNAMIC IMAGE?')
  107 FORMAT(I1,A2)
  108 FORMAT(I2,A1)
  111 FORMAT(I3)
  118 FORMAT(' (THE CURRENT VALUES ARE ',E16.7,' AND ',E16.7,' METERS.)'
     .)
  156 FORMAT(' NUMBER OF OVERLAPPING AZIMUTH ANGLES (0 - ',I3,')?')
      END
C
C   THIS FUNCTION CALCULATES ONE OF 14 DIFFERENT WINDOW FUNCTIONS:
C  BARTLETT, RECTANGULAR, HANNING, HAMMING, BLACKMAN, AND VARIOUS
C  OTHERS--AS SPECIFIED BY THE INPUT INTEGER IWIN = 1 - 14 (INTEGER*1).
C  SEE "THE MEASUREMENT OF POWER SPECTRA," BY BLACKMAN AND TUKEY, AND
C  THE PAPER BY HARRIS IN THE JANUARY 1978 ISSUE OF "THE PROCEEDINGS OF
C  THE IEEE."  (THE TAYLOR WINDOW IS DESCRIBED IN THE "SPOTLIGHT MODE
C  SAR BOOK," BY JAKOWATZ, ET AL.)  THE MODIFIED TAYLOR WINDOW IS FROM
C  D.R. RHODES' ARTICLE IN "IEEE TRANSACTIONS ON ANTENNAS AND PROPAGAT-
C  ION," VOL. 20, MARCH 1972 (PP. 143 - 145).  THE OTHER INPUT VARIABLES
C  ARE:
C
C   X = POSITIVE OR NEGATIVE WINDOWED VALUE FROM CENTER OF WINDOW
C
C  AND
C
C   WL = WINDOW HALF-LENGTH.
C
C  ALL WINDOWS ARE ZERO FOR ABS(X) > WL.
C
C   THE SIDELOBE LEVEL FOR THE TAYLOR AND MODIFIED TAYLOR WINDOWS IS
C  INPUT VIA COMMON /TYLOR/.
C
      FUNCTION WINDOW(X,WL,IWIN)
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 I0,MTAYLR
      INTEGER*1 IWIN
      COMMON /TYLOR/SLL
      PI=4.D0*DATAN(1.D0)
      WINDOW=0.D0
      IF(DABS(X).GT.WL)RETURN
      GO TO (1,2,3,4,5,6,7,8,9,10,11,12,13,14) IWIN
    1 CONTINUE
C
C   BARTLETT
C
      WINDOW=1.D0-DABS(X)/WL
      RETURN
    2 CONTINUE
C
C   RECTANGULAR
C
      WINDOW=1.D0
      RETURN
    3 CONTINUE
C
C   HANNING
C
      WINDOW=.5D0*(1.D0+DCOS(PI*X/WL))
      RETURN
    4 CONTINUE
C
C   HAMMING
C
      WINDOW=.54D0+.46D0*DCOS(PI*X/WL)
      RETURN
    5 CONTINUE
C
C   BLACKMAN
C
      WINDOW=.42D0+.5D0*DCOS(PI*X/WL)+.08D0*DCOS(2.D0*PI*X/WL)
      RETURN
    6 CONTINUE
C
C   COSINE
C
      WINDOW=DCOS(PI*X/2.D0/WL)
      RETURN
    7 CONTINUE
C
C   RIESZ
C
      WINDOW=1.D0-(X/WL)**2
      RETURN
    8 CONTINUE
C
C   RIEMANN
C
      ARG=PI*X/WL
      WINDOW=SINC(ARG)
      RETURN
    9 CONTINUE
C
C   DE LA VALLE-POUSSIN
C
      IF(DABS(X).GT.WL/2.D0)GO TO 100
      WINDOW=1.D0-6.D0*(X/WL)**2*(1.D0-DABS(X)/WL)
      RETURN
  100 CONTINUE
      WINDOW=2.D0*(1.D0-DABS(X)/WL)**3
      RETURN
   10 CONTINUE
C
C   BOHMAN
C
      WINDOW=(1.D0-DABS(X)/WL)*DCOS(PI*X/WL)+DSIN(PI*DABS(X)/WL)/PI
      RETURN
   11 CONTINUE
C
C   EXACT BLACKMAN
C
      WINDOW=.42659071D0+.49656062D0*DCOS(PI*X/WL)+.07684867D0*
     .DCOS(2.D0*PI*X/WL)
      RETURN
   12 CONTINUE
C
C   KAISER-BESSEL
C
      ARG=6.9D0*DSQRT(1.D0-(X/WL)**2)
      WINDOW=I0(ARG)/I0(6.9D0)
      RETURN
   13 CONTINUE
C
C   TAYLOR
C
      WINDOW=TAYLOR(X,WL,0,SLL,ANORM)
      RETURN
   14 CONTINUE
C
C   MODIFIED TAYLOR
C
      WINDOW=MTAYLR(X,WL,0,SLL,ANORM)
      RETURN
      END
C
C   THIS SUBPROGRAM CALCULATES THE SINC FUNCTION OF AN INPUT REAL*8
C  VARIABLE X.
C
      FUNCTION SINC(X)
      REAL*8 SINC,X,DSIN
      SINC=1.D0
      IF(X.EQ.0.D0)RETURN
      SINC=DSIN(X)/X
      RETURN
      END
C
C   THIS FUNCTION CALCULATES THE (REAL*8) HYPERBOLIC BESSEL FUNCTION OF
C  ORDER ZERO OF (REAL*8) ARGUMENT XI.  THE ROUTINE IS FROM PAGES 484
C  AND 485 OF "AN ATLAS OF FUNCTIONS," BY SPANIER AND OLDHAM.
C
      FUNCTION I0(XI)
      REAL*8 I0,XI,X,R,S,DFLOAT,DEXP
      X=XI
      S=1.D0
      IF(X.GE.0.D0)GO TO 1
      S=-1.D0
      X=-X
    1 CONTINUE
      R=0.D0
      I0=0.D0
      J=10+IDINT(X)
    2 CONTINUE
      I0=1.D0+I0*R
      R=X/(X*R+2.D0*DFLOAT(J))
      J=J-1
      IF(J.NE.0)GO TO 2
      I0=DEXP(X)/(1.D0+2.D0*R*I0)
      RETURN
      END
C
C   THIS FUNCTION RETURNS DIRECTLY THE TAYLOR WEIGHTING COEFFICIENT FOR
C  A WINDOW OF LENGTH 2 * WL AT POSITION X (FROM WINDOW CENTER).  SLL IS
C  THE INPUT SIDELOBE LEVEL (DB) AND NBAR IS THE TAYLOR PARAMETER SPECI-
C  FYING HOW MANY TERMS TO USE IN THE SUMMATION AND PRODUCT FUNCTIONS.
C  IF NBAR IS INPUT AS NON-POSITIVE, IT WILL BE CALCULATED BASED ON THE
C  VALUE OF SLL.  TAYLOR COEFFICIENTS ARE NOT INTRINSICALLY UNITY WHEN
C  X = 0.  THIS ROUTINE OUTPUTS THEM THAT WAY, HOWEVER.  THE
C  NORMALIZATION CONSTANT USED TO DO THIS IS FMSUM AND IS ALSO OUTPUT.
C
      FUNCTION TAYLOR(X,WL,NBAR,SLL,FMSUM)
      IMPLICIT REAL*8 (A-H,O-Z)
      PI=4.D0*DATAN(1.D0)
C
C   WORK WITH NORMALIZED WINDOW POSITION.
C
      XI=X/WL/2.D0
C
C   GET SIDELOBE ATTENUATION FACTOR.
C
      B=10.D0**(DABS(SLL)/20.D0)
      A=DLOG(B+DSQRT(B**2-1.D0))/PI
C
C   IF NBAR WASN'T INPUT, CALCULATE IT (AS N).  THEN GET MAIN LOBE
C  BROADENING FACTOR.
C
      N=NBAR
      IF(N.LE.0)N=3*IDINT(2.D0*A**2+1.000001D0)
      SIGMAP=DFLOAT(N)/DSQRT(A**2+(DFLOAT(N)-.5D0)**2)
C
C   INITIALIZE NORMALIZATION AND TAYLOR COEFFICIENT SUMMATIONS.
C
      FMSUM=1.D0
      TAYLOR=1.D0
C
C   BEGIN COEFFICIENT SUMMATION.
C
      DO 1 M=1,N-1
      RM=DFLOAT(M)
C
C   CALCULATE PRODUCT FUNCTIONS AND PERFORM DIVISIONS IN COMPACT BUT
C  NOT NECESSARILY OBVIOUS FORMAT.
C
      FM=1.D0
      DO 2 J=1,N-1
      RJ=DFLOAT(J)
      FM=FM*(1.D0-(RM/SIGMAP)**2/(A**2+(RJ-.5D0)**2))
      IF(J.NE.M)FM=FM/(1.D0-(RM/RJ)**2)
    2 CONTINUE
C
C   GET MTH COEFFICIENT IN TAYLOR COEFFICIENT AND SUM.
C
      FM=FM*(-1.D0)**(M+1)
      TAYLOR=TAYLOR+FM*DCOS(2.D0*PI*RM*XI)
C
C   SUM NORMALIZATION CONSTANT.
C
      FMSUM=FMSUM+FM
    1 CONTINUE
C
C   NORMALIZE TAYLOR COEFFICIENT NOW THAT IT'S CALCULATED.
C
      TAYLOR=TAYLOR/FMSUM
      RETURN
      END
C
C   THIS FUNCTION RETURNS DIRECTLY THE MODIFIED TAYLOR WEIGHTING
C  COEFFICIENT FOR A WINDOW OF LENGTH 2 * WL AT POSITION X (FROM WINDOW
C  CENTER).  SLL IS THE INPUT SIDELOBE LEVEL (DB) AND NBAR IS THE TAYLOR
C  PARAMETER SPECIFYING HOW MANY TERMS TO USE IN THE SUMMATION AND
C  PRODUCT FUNCTIONS.  IF NBAR IS INPUT AS NON-POSITIVE, IT WILL BE
C  CALCULATED BASED ON THE VALUE OF SLL.  TAYLOR COEFFICIENTS ARE NOT
C  INTRINSICALLY UNITY WHEN X = 0.  THIS ROUTINE OUTPUTS THEM THAT WAY,
C  HOWEVER.  THE NORMALIZATION CONSTANT USED TO DO THIS IS FMSUM AND IS
C  ALSO OUTPUT.  (MTAYLR MUST BE DECLARED TO BE REAL*8 IN THE CALLING
C  ROUTINE.)
C
      FUNCTION MTAYLR(X,WL,NBAR,SLL,FMSUM)
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 MTAYLR
      PI=4.D0*DATAN(1.D0)
C
C   WORK WITH NORMALIZED WINDOW POSITION.
C
      XI=X/WL/2.D0
C
C   GET SIDELOBE ATTENUATION FACTOR.
C
      B=10.D0**(DABS(SLL)/20.D0)
      A=DLOG(B+DSQRT(B**2-1.D0))/PI
C
C   IF NBAR WASN'T INPUT, CALCULATE IT (AS N).
C
      N=NBAR
      IF(N.LE.0)N=3*IDINT(2.D0*A**2+1.000001D0)
C
C   SIGMAP = MAIN LOBE BROADENING FACTOR.
C
      SIGMAP=(DFLOAT(N)+.5D0)/DSQRT(A**2+(DFLOAT(N)-.5D0)**2)
C
C   INITIALIZE NORMALIZATION AND TAYLOR COEFFICIENT SUMMATIONS.
C
      FMSUM=1.D0
      DO 3 I=1,N-1
      RI=DFLOAT(I)
      FMSUM=FMSUM*(1.D0-.25D0/(A**2+(RI-.5D0)**2)/SIGMAP**2)
      FMSUM=FMSUM/(1.D0-1.D0/(2.D0*RI+1.D0)**2)
    3 CONTINUE
      MTAYLR=FMSUM*DCOS(PI*XI)
C
C   BEGIN COEFFICIENT SUMMATION.
C
      DO 1 M=1,N-1
      RM=DFLOAT(M)+.5D0
C
C   CALCULATE PRODUCT FUNCTIONS AND PERFORM DIVISIONS IN COMPACT BUT
C  NOT NECESSARILY OBVIOUS FORMAT.
C
      FM=1.D0
      DO 2 J=1,N-1
      RJ=DFLOAT(J)
      FM=FM*(1.D0-(RM/SIGMAP)**2/(A**2+(RJ-.5D0)**2))
      IF(J.NE.M)FM=FM/(1.D0-(RM/(RJ+.5D0))**2)
    2 CONTINUE
C
C   GET MTH COEFFICIENT IN TAYLOR COEFFICIENT AND SUM.
C
      FM=(-1.D0)**M*FM*2.D0*RM/(1.D0-4.D0*RM**2)
      MTAYLR=MTAYLR+FM*DCOS(2.D0*PI*RM*XI)
C
C   SUM NORMALIZATION CONSTANT.
C
      FMSUM=FMSUM+FM
    1 CONTINUE
C
C   NORMALIZE TAYLOR COEFFICIENT NOW THAT IT'S CALCULATED.
C
      MTAYLR=MTAYLR/FMSUM
      RETURN
      END
C
C   THIS SUBROUTINE USES A 1D FFT ROUTINE REPEATEDLY TO PERFORM A 2D
C  FFT.
C
C   Y = COMPLEX*16 INPUT/OUTPUT ARRAY TO BE TRANSFORMED AND OUTPUT.
C
C   NX AND NY = INTEGER*2 SIZES IN "X" AND "Y," RESPECTIVELY, OF ARRAY
C               Y.
C
C   DX AND DY = STEPSIZES IN TWO RESPECTIVE ORTHOGONAL DIMENSIONS.
C
      SUBROUTINE FFT2(Y,NX,NY,DX,DY)
      REAL*8 DX,DY
      COMPLEX*16 Y(512,512),X(512)
      INTEGER*2 NX,NY
C
C   ALIAS NX AND NY WITH NXX AND NYY FOR CONFORMITY WITH 1D FFT ROUTINE.
C
      NXX=INT4(NX)
      NYY=INT4(NY)
C
C   PROCESS ROWS FIRST.
C
      DO 1 I=1,NY
      DO 2 J=1,NX
      X(J)=Y(J,I)
    2 CONTINUE
      CALL FFT(X,NXX,0,DX)
C
C   PUT 1D FFT IN SEQUENTIAL ORDER AND RE-STORE IN Y.
C
      DO 3 J=1,NX/2
      Y(J,I)=X(J+NX/2)
      Y(J+NX/2,I)=X(J)
    3 CONTINUE
    1 CONTINUE
C
C   REPEAT ABOVE PROCESS FOR ORTHOGONAL DIRECTION.
C
      DO 4 I=1,NX
      DO 5 J=1,NY
      X(J)=Y(I,J)
    5 CONTINUE
      CALL FFT(X,NYY,0,DY)
      DO 6 J=1,NY/2
      Y(I,J)=X(J+NY/2)
      Y(I,J+NY/2)=X(J)
    6 CONTINUE
    4 CONTINUE
      RETURN
      END
************************************************************************
* SUBROUTINE:  FFT                                                     *
* Jim Cooley's simple FFT program--uses decimation in time algorithm.  *
*                                                                      *
*  X   = Complex array of size N.  On input, X contains                *
*        the sequence to be transformed.                               *
*        On output, X contains the DFT of the input.                   *
*  N   = Size of FFT to be computed--N=2**M.                           *
*  INV = Parameter to determine whether to do a direct transform       *
*        (INV = 0) or an inverse transform (INV = 1).                  *
*  AINC = Delta time for forward transform, delta frequency for        *
*         inverse transform.                                           *
*                                                                      *
************************************************************************
      SUBROUTINE FFT(X,N,INV,AINC)
      IMPLICIT REAL*8 (A-H,O-Z)
         COMPLEX*16 X(N),U,W,T,DCMPLX,DCONJG
         PI=4.D0*DATAN(1.D0)
         AM=ALOG(DFLOAT(N))/DLOG(2.D0)+.001D0
         M=IDINT(AM)
         NV2=N/2
         NM1=N-1
         J=1
         DO 40 I=1,NM1
            IF(I.GE.J)GO TO 10
            T=X(J)
            X(J)=X(I)
            X(I)=T
  10        CONTINUE
            K=NV2
  20        CONTINUE
            IF(K.GE.J)GO TO 30
            J=J-K
            K=K/2
            GO TO 20
  30        CONTINUE
            J=J+K
  40        CONTINUE
         DO 70 L=1,M
            LE=2**L
            LE1=LE/2
            U=(1.D0,0.D0)
            W=DCMPLX(DCOS(PI/DFLOAT(LE1)),-DSIN(PI/DFLOAT(LE1)))
            IF(INV.NE.0)W=DCONJG(W)
            DO 60 J=1,LE1
               DO 50 I=J,N,LE
                  IP=I+LE1
                  T=X(IP)*U
                  X(IP)=X(I)-T
                  X(I)=X(I)+T
  50           CONTINUE
               U=U*W
  60        CONTINUE
  70     CONTINUE
         DO 80 I=1,N
            X(I)=X(I)*AINC
  80     CONTINUE
      RETURN
      END
C
C   THIS SUBROUTINE INPUTS A COMPLEX*16 ARRAY X REPRESENTING N POINTS IN
C  A TEMPORAL WAVEFORM AND PERFORMS SPATIALLY VARIANT APODIZATION ON IT,
C  REPLACING THE INPUT VECTOR WITH THE SVA RESULTS.  (N MUST NOT BE
C  LARGER THAN 512.)
C
      SUBROUTINE SVA(X,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMPLEX*16 X(N),J,DCMPLX
      DIMENSION XR(512),XI(512)
      DATA J/(0.D0,1.D0)/
      DO 1 I=1,N
      NLOW=I-1
      IF(NLOW.EQ.0)NLOW=N
      NHIGH=I+1
      IF(NHIGH.GT.N)NHIGH=1
      CMP=DREAL(X(I))
      ANN=DREAL(X(NLOW))+DREAL(X(NHIGH))
      WU=-1.D0
      IF(ANN.NE.0.D0)WU=-CMP/ANN
      XR(I)=CMP
      IF(0.D0.LE.WU.AND.WU.LE..5D0)XR(I)=0.D0
      IF(WU.GT..5D0)XR(I)=CMP+ANN/2.D0
      CMP=DREAL(-J*X(I))
      ANN=DREAL(-J*X(NLOW))+DREAL(-J*X(NHIGH))
      WU=-1.D0
      IF(ANN.NE.0.D0)WU=-CMP/ANN
      XI(I)=CMP
      IF(0.D0.LE.WU.AND.WU.LE..5D0)XI(I)=0.D0
      IF(WU.GT..5D0)XI(I)=CMP+ANN/2.D0
    1 CONTINUE
      DO 2 I=1,N
      X(I)=DCMPLX(XR(I),XI(I))
    2 CONTINUE
      RETURN
      END
      SUBROUTINE CLEAR
      DO 1 I=1,25
      WRITE(6,*)' '
    1 CONTINUE
      RETURN
      END
