'
'  This program controls the operation of the program NEC to calculate
' monostatically-scattered electric fields for use by NCSARGEN (which is
' automatically run by *this* program) to simulate a SAR image
' calculation.  It allows for the simulated target to move rectilinearly
' at constant speed, rotate at constant speed about a rectilinearly
' moving axis of rotation (or *instead*, rock back and forth torsionally),
' or vibrate linearly about a point moving rectilinearly or rotating.
' (The axis of vibration is specifiable and the center of vibration
' rotates with the rotating point (if any).)  The SAR is presumed to be
' moving at constant speed parallel to NEC's y-axis (linear SAR) or in a
' circle about the vertical axis through scene center (circular SAR).  In
' the former option, the "stabilized down range" prompted for below is the
' x coordinate (in km) of the SAR position and the "stabilized zenith
' angle" is the complement of the SAR elevation angle when the SAR's y
' coordinate is 0--whether or not the SAR ever actually gets to that z
' position.
'
'  Before running this program, create a NEC input file with a geometry
' section that describes your structure in its static state.  Rather than
' assume all wire segments (whether explicit or implied, via GA cards, for
' example) are to be involved in the SAR target motion, this program uses
' NEC's GM card capability of only moving part of the overall structure.
' For this to work, there needs to be a slight alteration to the NEC input
' file from what would work if you were just running NEC directly on the
' static NEC input file.  First, the geometry specification cards corres-
' ponding to the wire segments that are to move in some fashion must all
' be grouped together.  (All such segments will move in exactly the same
' way.  No allowance is made for different segments to move in different
' fashions.)  When you create this input file, note the tag number of the
' first segment in this group.  At the end of this group of segments,
' there needs to be a "GM line" containing just the leading "GM" string,
' nothing else.  If the last line in that group is already a GM line that
' you're using as part of your basic structure definition, the blank GM
' line just mentioned goes AFTER your GM line.  If you don't include this
' blank GM line, all wire segments specified in the geometry section will
' participate in the SAR target motion.  This NEC input file need not
' actually contain any lines after the GE card, and it doesn't really need
' the GE card either.  (But if the GE card isn't there, make sure that
' there are in fact no NEC lines after where it would otherwise be--for
' whatever reason you would have a NEC input file created that way.)
' Perhaps obviously, the blank GM card above can't be the first card in
' the geometry section.  That just wouldn't make any more sense than a
' regular GM card there.)  The program gets the name of this input file
' (the "master NEC input file") from the command-line.  If the command-
' line is blank, it prompts you for the name of the file.
'
DECLARE FUNCTION EXIST%(FILE$)
DECLARE FUNCTION TRUNC#(X AS DOUBLE,N AS INTEGER)
DECLARE FUNCTION DMOD#(X AS DOUBLE,Y AS DOUBLE)
'$INCLUDE: 'FINDVESA.INC'
DIM NF AS INTEGER,NA AS INTEGER,I AS INTEGER,OMEGA AS DOUBLE,TP AS DOUBLE
DIM PI AS DOUBLE,J AS INTEGER,NN AS INTEGER,NS AS INTEGER,K AS INTEGER
DIM ANGLE AS DOUBLE,ZENITH AS DOUBLE,Z0 AS DOUBLE,FERR AS INTEGER,YC0 AS DOUBLE
DIM HSIZE AS INTEGER,VSIZE AS INTEGER,X AS DOUBLE,BF AS DOUBLE,DF AS DOUBLE
DIM Y AS DOUBLE,XC AS DOUBLE,YC AS DOUBLE,VX AS DOUBLE,VY AS DOUBLE
DIM DELTA AS DOUBLE,PHI AS DOUBLE,BA AS DOUBLE,EA AS DOUBLE,EF AS DOUBLE
DIM DA AS DOUBLE,VS AS DOUBLE,DSAR AS DOUBLE,NX AS INTEGER,NY AS INTEGER
DIM OMEGAV AS DOUBLE,AMPV AS DOUBLE,VANGLE AS DOUBLE,CF AS INTEGER,DCX AS DOUBLE
DIM NECDIR(1 TO 16) AS LONG,IROT AS INTEGER,ZC AS DOUBLE,GMP1 AS INTEGER
DIM DCY AS DOUBLE,DCZ AS DOUBLE,DCM AS DOUBLE,ELROT AS DOUBLE,AZROT AS DOUBLE
DIM Z AS DOUBLE,GMLINE AS INTEGER,FOUT AS INTEGER,NECLINE AS INTEGER
DIM GSTART AS INTEGER,GELINE AS INTEGER,CELINE AS INTEGER,GMM1 AS INTEGER
DIM XC0 AS DOUBLE
FILE$=COMMAND$
IF EXIST(FILE$)<>1 THEN FILE$=""
WHILE FILE$=""
LINE INPUT "NAME OF MASTER NEC INPUT FILE?";FILE$
FILE$=LTRIM$(RTRIM$(FILE$))
IF EXIST(FILE$)<>1 THEN FILE$=""
WEND
'
'  Make sure FILE$ isn't SARRUN.NEC, SARRUN.BAT, SARRUN.INP, or
' NCSARSIM.INI.
'
FERR=0
IF FILE$="SARRUN.NEC" OR FILE$="SARRUN.BAT" OR FILE$="SARRUN.INP" THEN FERR=1
IF FILE$="NCSARSIM.INI" THEN FERR=1
IF FERR=1 THEN
PRINT
PRINT "  Excuse me, but you really can't use ";FILE$;" as the name of"
PRINT "your master NEC file."  I'm going to be writing to a file of that name,"
PRINT "destroying the contents of what was already there.  That will not only"
PRINT "cause me a problem, but you might not be happy about it either."
PRINT
STOP
END IF
'
'  Get necessary data from human.
'
NF=0
WHILE NF<2
INPUT "BEGINNING AND ENDING FREQUENCIES (Mhz), AND #";BF,EF,NF
WEND
IF NF>512 THEN NF=512
NA=0 : BA=0# : EA=0#
WHILE NA<2 OR EA<=BA
INPUT "BEGINNING AND ENDING SAR AZIMUTHS (degrees), AND #";BA,EA,NA
WEND
DA=(EA-BA)/CDBL(NA-1) : IF NA>256 THEN NA=256
PRINT "CIRCULAR (C) OR LINEAR (L) SAR?";
SAR$=""
WHILE SAR$=""
SAR$=UCASE$(INKEY$)
IF SAR$<>"" THEN IF ASC(SAR$)=13 THEN SAR$="L"
WEND
GOSUB CLEARKEY
IF SAR$<>"C" THEN SAR$="L"
PRINT SAR$
IF SAR$="L" THEN
INPUT "SAR CENTRAL/STABILIZED ZENITH ANGLE (degrees)";Z0
INPUT "SAR SPEED (m/s) AND STABILIZED DOWN RANGE (km)";VS,DSAR
ELSE
INPUT "SAR ZENITH ANGLE (degrees)";Z0
INPUT "SAR SPEED (m/s) AND 'ORBITAL' RADIUS (km)";VS,DSAR
END IF
DSAR=ABS(DSAR)*1D3
INPUT "INCIDENT POLARIZATION ANGLE (degrees, WRT THETA UNIT VECTOR)";POLANGLE
FOUT=0
WHILE FOUT<>1 AND FOUT<>2
INPUT "THETA/VERTICAL (1) OR PHI/HORIZONTAL (2) FIELD COMPONENTS OUTPUT";FOUT
WEND
INPUT "TARGET ROTATIONAL RATE (rpm)";OMEGA
'
'  Convert rotation rate to radians/second.  If it's zero, ask about
' torsional vibration.  (IROT is used in later calculations to distinguish
' between the two types of rotations.)
'
PI=4#*ATN(1#)
OMEGA=PI*OMEGA/30# : IROT=0
IF OMEGA=0# THEN
INPUT "TORSIONAL VIBRATION FREQUENCY (hz) AND AMPLITUDE (degrees)";OMEGA,TAMP
IF TAMP=0# THEN OMEGA=0#
OMEGA=2#*PI*OMEGA : TAMP=PI*TAMP/180# : IROT=1
END IF
IF ABS(OMEGA)>=1D-10 THEN
INPUT "XYZ COORDINATES OF ROTATION AXIS IN TARGET COORDINATE SYSTEM (m)";XC0,YC0,ZC
'
'  Restrict accuracy of ZC so it can (hopefully) be written to NEC input
' file correctly.
'
ZC=TRUNC(ZC,5)
INPUT "XYZ DIRECTION COSINES OF ROTATION AXIS";DCX,DCY,DCZ
'
'  Make sure direction cosines are properly normalized and get *axis*
'  rotation angles.
'
IF ABS(DCX)<1D-10 AND ABS(DCY)<1D-10 AND ABS(DCZ)<1D-10 THEN DCZ=1#
DCM=SQR(DCX^2+DCY^2+DCZ^2)
DCX=DCX/DCM
DCY=DCY/DCM
DCZ=DCZ/DCM
AZROT=0#
IF ABS(DCY)>=1D-10 THEN AZROT=SGN(DCY)*PI/2#
IF ABS(DCX)>=1D-10 THEN AZROT=ATN(DCY/DCX)
IF DCX<0# THEN AZROT=AZROT+PI
'
'  Watch out for AZROT getting set to PI instead of 0.
'
IF ABS(PI-AZROT)<1D-10 AND ABS(DCX)<1D-10 THEN AZROT=0#
'
'  ELROT and AZROT are negated to make initial coordinate system rotations
' of GM card clockwise.
'
AZROT=-AZROT
ELROT=90
IF ABS(DCZ)>1D-10 THEN
ELROT=ATN(SQR(1#/DCZ^2-1#))*180#/PI
IF DCZ<0# THEN ELROT=180#-ELROT
END IF
ELROT=-ELROT
'
'  Restrict accuracy of ELROT and AZROT so they (hopefully) fit in a 9-
' character space.
'
ELROT=TRUNC(ELROT,5)
AZROT=TRUNC(AZROT,5)
END IF
INPUT "X AND Y COMPONENTS OF TARGET VELOCITY (m/s)";VX,VY
INPUT "TARGET VIBRATION FREQUENCY (Hz)";OMEGAV
AMPV=0#
IF ABS(OMEGAV)>=1D-10 THEN
INPUT "TARGET VIBRATION AMPLITUDE (mm) AND ANGLE (degrees) OF VIBRATION";AMPV,VANGLE
AMPV=AMPV/1000#
OMEGAV=2#*PI*OMEGAV
VANGLE=PI*VANGLE/180#
END IF
INPUT "TAG NUMBER INDICATING FIRST WIRE SEGMENT INVOLVED IN MOTION";ITS
'
'  Make sure ITS has integral value and don't let it be less than 1 or
' greater than 999.
'
ITS=FIX(ITS+.001)
IF ITS<1 THEN ITS=1
IF ITS>999 THEN ITS=999
'
'  Find blank GM, CE, and GE lines in FILE$.
'
NECLINE=0 : GMLINE=0 : GELINE=0 : CELINE=0
OPEN FILE$ FOR INPUT AS #1
FINDGM:
IF EOF(1) THEN GOTO HAVEORNOGM
LINE INPUT#1,NEC$
NEC$=LTRIM$(UCASE$(NEC$))
NECLINE=NECLINE+1
IF LEFT$(NEC$,2)="GE" THEN GELINE=NECLINE : GOTO HAVEORNOGM
IF LEFT$(NEC$,2)="CE" THEN CELINE=NECLINE : GOTO FINDGM
IF LEFT$(NEC$,2)<>"GM" THEN GOTO FINDGM
IF LEN(NEC$)<>2 THEN GOTO FINDGM
'
'  Don't set GMLINE if it's already been set to a nonzero value.  In that
' situation, the rest of this loop is just for counting the number of
' lines in the master NEC file up to where the GE card is.  (The only way
' that execution could be here if GMLINE <> 0 is if there's more than one
' blank GM card in the master NEC file--and that shouldn't be.)
'
IF GMLINE=0 THEN GMLINE=NECLINE
GOTO FINDGM
HAVEORNOGM:
CLOSE #1
'
'  If GMLINE = 0, set it equal to GELINE - 1.  If GELINE = 0 in that
' situation, however, terminate with error message.
'
IF GMLINE=0 AND GELINE=0 THEN
PRINT
PRINT "You don't have a blank GM line or a GE card.  That's a no-no."
PRINT
STOP
END IF
'
'  If GELINE = 0, set it equal to number of lines in FILE$.  (This assumes
' that there are no program control cards in the master NEC file.)
'
IF GELINE=0 THEN GELINE=NECLINE
IF GMLINE=0 THEN GMLINE=GELINE-1
GMM1=GMLINE-1 : GMP1=GMLINE+1
'
'  GMM1 and GMP1 are for transferring data from FILE$ to the file to be
' used for actually running NEC (SARRUN.NEC).
'
IF GMP1>GELINE THEN GMP1=GELINE
'
'  Now watch out for something really dumb.
'
IF GMM1=CELINE THEN
PRINT
PRINT "  Your blank GM card is the first card in the geometry section.  That's"
PRINT "a no-no."
PRINT
STOP
END IF
'
'  Set default values for unpadded spectral image size.
'
NX=128 : NY=64
DISPLAY$=UCASE$(LTRIM$(RTRIM$(ENVIRON$("SCREEN"))))
IF DISPLAY$<>"13" THEN
'
'  Find useful VESA video mode.
'
'  First, look for 800 x 600 or larger mode.
'
HSIZE=800 : VSIZE=600
GETVESA:
SINFO.STYPE=0
'
'  *Forcing* a graphics mode search is really silly, but the option's
' there, so I'll use it.
'
SINFO.MTYPE="G"
CALL FINDVESA(MODE$,HSIZE,VSIZE,8)
'
'  Update HSIZE and VSIZE parameters in case higher video mode needs to be
' searched for.
'
IF HSIZE=800 THEN HSIZE=1024
IF HSIZE=1024 THEN HSIZE=1280
IF HSIZE=1280 THEN HSIZE=1600
'
'  There is no known video mode with a horizontal resolution of 3200
' pixels.  This is just to allow the loop to terminate.
'
IF HSIZE=1600 THEN HSIZE=3200
IF VSIZE=480 THEN VSIZE=600
IF VSIZE=600 THEN VSIZE=768
IF VSIZE=768 THEN VSIZE=1024
IF VSIZE=1024 THEN VSIZE=1200
IF MODE$="-1" AND HSIZE<=1600 AND VSIZE<=1200 THEN GOTO GETVESA
IF MODE$="-1" THEN
'
'  Okay, really useful VESA mode couldn't be found.  Look for 640 x 480
' mode.
'
SINFO.STYPE=0 : SINFO.MTYPE="G"
CALL FINDVESA(MODE$,640,480,8)
IF MODE$="-1" THEN
'
'  The following PRINT statements should make it clear what this section
' of code is for.
'
PRINT
PRINT "  THIS COMPUTER DOESN'T SUPPORT THE VIDEO MODE YOU MAY NEED TO USE TO"
PRINT "DISPLAY THE IMAGE(S).  SO I'LL JUST ASK.  CHOOSE THE VIDEO MODE YOU WANT"
PRINT "TO MAKE AN IMAGE TO FIT IN."
PRINT
PRINT
PRINT "1 - 800 x 600"
PRINT
PRINT "2 - 640 x 480"
PRINT
PRINT "3 - 320 x 200"
PRINT
PRINT
ANS$=""
WHILE ANS$=""
ANS$=UCASE$(INKEY$)
IF ANS$<>"" THEN IF ASC(ANS$)=13 THEN ANS$="3"
IF VAL(ANS$)<1 OR VAL(ANS$)>3 THEN ANS$=""
WEND
GOSUB CLEARKEY
PRINT ANS$
IF VAL(ANS$)=1 THEN NY=256
IF VAL(ANS$)=2 THEN NY=128
ELSE
NY=128
END IF
ELSE
NY=256
END IF
END IF
'
'  The range size wasn't specified above because it naturally follows from
' the cross range size.
'
IF NY>64 THEN NX=256
'
'  Generate strings for writing program control cards.
'
FR$="FR  0"
NFSTR$=LTRIM$(STR$(NF))
WHILE LEN(NFSTR$)<5
NFSTR$=" "+NFSTR$
WEND
FR$=FR$+NFSTR$+"    0    0"
IF BF>EF THEN SWAP BF,EF
'
'  CSNG is used here (and elsewhere) to minimize effects of computer
' digitization accuracy from defeating the purpose of function TRUNC.
'
BFSTR$=LTRIM$(STR$(CSNG(BF)))
IF LEN(BFSTR$)>9 THEN
PRINT
PRINT "Beginning frequency (";BFSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(BFSTR$)<10
BFSTR$=" "+BFSTR$
WEND
FR$=FR$+BFSTR$
DF=(EF-BF)/CDBL(NF-1)
DF=TRUNC(DF,5)
DFSTR$=LTRIM$(STR$(CSNG(DF)))
IF LEN(DFSTR$)>9 THEN
PRINT
PRINT "Frequency increment (";DFSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(DFSTR$)<10
DFSTR$=" "+DFSTR$
WEND
FR$=FR$+DFSTR$
EX0$="EX  1    1    1   0 "
ETA$=LTRIM$(STR$(POLANGLE))
IF LEN(ETA$)>9 THEN
PRINT
PRINT "Polarization angle (";ETA$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(ETA$)<10
ETA$=" "+ETA$
WEND
'
'  The rest of the excitation card can't be completed until inside the
' azimuth looping.
'
PL$="PL  3    2   "+LTRIM$(STR$(FOUT))+"    0"
RP0$="RP  0    1    1 1010"
'
'  The rest of the radiation pattern card can't be completed either until
' inside the azimuth looping.  Define some more strings to be used to
' generated other data cards below.
'
ITSSTR$=LTRIM$(STR$(ITS))
IF RIGHT$(ITSSTR$,1)<>"." THEN ITSSTR$=ITSSTR$+"."
WHILE LEN(ITSSTR$)<10
ITSSTR$=" "+ITSSTR$
WEND
ELSTR$=LTRIM$(STR$(CSNG(ELROT)))
IF LEN(ELSTR$)>9 THEN
PRINT
PRINT "Zenith rotation angle (";ELSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(ELSTR$)<10
ELSTR$=" "+ELSTR$
WEND
AZSTR$=LTRIM$(STR$(CSNG(AZROT)))
IF LEN(AZSTR$)>9 THEN
PRINT
PRINT "Azimuth rotation angle (";AZSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(AZSTR$)<10
AZSTR$=" "+AZSTR$
WEND
MELSTR$=LTRIM$(STR$(CSNG(-ELROT)))
IF LEN(MELSTR$)>9 THEN
PRINT
PRINT "Zenith rotation angle (";MELSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(MELSTR$)<10
MELSTR$=" "+MELSTR$
WEND
MAZSTR$=LTRIM$(STR$(CSNG(-AZROT)))
IF LEN(MAZSTR$)>9 THEN
PRINT
PRINT "Azimuth rotation angle (";MAZSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(MAZSTR$)<10
MAZSTR$=" "+MAZSTR$
WEND
ZCSTR$=LTRIM$(STR$(CSNG(ZC)))
IF LEN(ZCSTR$)>9 THEN
PRINT
PRINT "Rotation axis Z (";ZCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(ZCSTR$)<10
ZCSTR$=" "+ZCSTR$
WEND
MZCSTR$=LTRIM$(STR$(CSNG(-ZC)))
IF LEN(MZCSTR$)>9 THEN
PRINT
PRINT "Rotation axis negative Z (";MZCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(MZCSTR$)<10
MZCSTR$=" "+MZCSTR$
WEND
'
'  Generate GM card strings for later output (for performing various
' rotations related to that axis' orientation).
'
GMROTEL$="GM  0    0        0."+ELSTR$
GMROTEL$=GMROTEL$+"        0.        0.        0.        0."+ITSSTR$
GMROTAZ$="GM  0    0        0.        0."+AZSTR$
GMROTAZ$=GMROTAZ$+"        0.        0.        0."+ITSSTR$
GMRESETEL$="GM  0    0        0."+MELSTR$
GMRESETEL$=GMRESETEL$+"        0.        0.        0.        0."+ITSSTR$
GMRESETAZ$="GM  0    0        0.        0."+MAZSTR$
GMRESETAZ$=GMRESETAZ$+"        0.        0.        0."+ITSSTR$
'
'  Initialize NEC input file.
'
OPEN "SARRUN.NEC" FOR OUTPUT AS #2
PRINT#2,"CM ";SAR$
PRINT#2,"CM ";NX,NY
PRINT#2,"CM ";Z0
PRINT#2,"CM ";NA
PRINT#2,"CM ";BF*1.D6,EF*1.D6,NF
PRINT#2,"CM ";VS,DSAR
IF CELINE=0 THEN PRINT#2,"CE"
'
'  Loop through azimuth angles.
'
'  DELTA = "tangent scale factor"--used to get instantaneous azimuth angle
'           for linear SAR.
'
DELTA=(TAN(EA*PI/180#)-TAN(BA*PI/180#))/CDBL(NA-1)
PRINT
FOR I=1 TO NA
PRINT "PROCESSING NEC INPUTS FOR ANGLE ";I;"."
'
'  Transfer part of master NEC file to SARRUN.NEC up to where target
' motion begins.
'
OPEN FILE$ FOR INPUT AS #1
FOR J=1 TO GMM1
LINE INPUT#1,NEC$
NEC$=LTRIM$(NEC$)
PRINT#2,NEC$
NEXT J
'
'  Read in blank GM line (just as a way of skipping it).
'
LINE INPUT#1,NEC$
'
'  For circular SAR, azimuth angle varies uniformly.  However, for a
' linear SAR, it's the tangent of that angle that varies uniformly.  Get
' zenith angle in process too.
'
ZENITH=Z0
IF SAR$="C" THEN
PHI=BA+DA*CDBL(I-1)
ELSE
PHI=ATN(DELTA*CDBL(I-1)+TAN(BA*PI/180#))*180#/PI
IF ABS(Z0-90#)>1D-10 AND ABS(ABS(PHI)-90#)>1D-10 THEN
ZENITH=180#*ATN(TAN(Z0*PI/180#)/COS(PI*PHI/180#))/PI
END IF
END IF
'
'  Target doesn't need to be rotated or moved for first azimuth (or if it
' isn't rotating or moving).
'
IF I>1 AND (OMEGA<>0# OR VX<>0# OR VY<>0# OR (OMEGAV<>0# AND AMPV<>0#)) THEN
'
'  Calculate time from start of SAR collect and get angle by which target
' geometry must be rotated from initial configuration.
'
IF SAR$="L" THEN TP=DSAR*(TAN(PHI*PI/180#)-TAN(BA*PI/180#))/VS
IF SAR$="C" THEN TP=DSAR*(PHI-BA)*PI/VS/180#
ANGLE=OMEGA*TP : IF IROT=1 THEN ANGLE=TAMP*SIN(ANGLE)
'
'  Since I'm enforcing the "standard NEC" field-length of 10 characters,
' don't let ANGLE be larger than it needs to be.
'
ANGLE=DMOD(ANGLE,2#*PI)
IF ABS(OMEGA)>=1D-10 THEN
'
'  There are potentially two types of rotations involved.  One is the
' physical rotation of the SAR target.  The other type consists of the
' rotations that NEC must make to simulate the SAR target rotation.  The
' latter type is what's happening first here.  However, before those
' rotations occur, the axis of rotation must be translated to NEC's
' coordinate origin.
'
IF ABS(XC)>=1D-10 OR ABS(YC)>=1D-10 OR ABS(ZC)>=1D-10 THEN
XC=TRUNC(XC,5)
YC=TRUNC(YC,5)
XCSTR$=LTRIM$(STR$(CSNG(XC)))
IF LEN(XCSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Rotation axis X (";XCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(XCSTR$)<10
XCSTR$=" "+XCSTR$
WEND
YCSTR$=LTRIM$(STR$(CSNG(YC)))
IF LEN(YCSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Rotation axis Y (";YCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(YCSTR$)<10
YCSTR$=" "+YCSTR$
WEND
MXCSTR$=LTRIM$(STR$(CSNG(-XC)))
IF LEN(MXCSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Rotation axis negative X (";MXCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(MXCSTR$)<10
MXCSTR$=" "+MXCSTR$
WEND
MYCSTR$=LTRIM$(STR$(CSNG(-YC)))
IF LEN(MYCSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Rotation axis negative Y (";MYCSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(MYCSTR$)<10
MYCSTR$=" "+MYCSTR$
WEND
GM$="GM  0    0        0.        0.        0."+MXCSTR$+MYCSTR$+MZCSTR$+ITSSTR$
PRINT#2,GM$
END IF
'
'  Okay, now perform rotations so that rotation axis effectively matches
' coordinate system Z-axis.
'
IF ABS(AZROT)>1D-10 THEN PRINT#2,GMROTAZ$
IF ABS(ELROT)>1D-10 THEN PRINT#2,GMROTEL$
'
'  NEC needs the rotation angle in degrees.  Make that change when
' restricting its accuracy.
'
ANGLE=TRUNC(ANGLE*180#/PI,5)
ANGSTR$=LTRIM$(STR$(CSNG(ANGLE)))
IF LEN(ANGSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Physical rotation angle (";ANGSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(ANGSTR$)<10
ANGSTR$=" "+ANGSTR$
WEND
'
'  Perform physical rotation about NEC's z-axis.
'
GM$="GM  0    0        0.        0."+ANGSTR$+"        0.        0.        0."
GM$=GM$+ITSSTR$
PRINT#2,GM$
'
'  Rotate rotated and shifted target back to its original non-rotated
' state (except for the physical rotation by ANGLE).
'
IF ABS(ELROT)>=1D-10 THEN PRINT#2,GMRESETEL$
IF ABS(AZROT)>=1D-10 THEN PRINT#2,GMRESETAZ$
'
'  Target may still be shifted.  Fix that too.  (This could have been
' done simultaneously with the last azimuth rotation, but that would have
' involved defining GMRESETAZ$ within the loop--not that that would have
' mattered all that much.)
'
IF ABS(XC)>=1D-10 OR ABS(YC)>=1D-10 OR ABS(ZC)>=1D-10 THEN
GM$="GM  0    0        0.        0.        0."+XCSTR$+YCSTR$+ZCSTR$+ITSSTR$
PRINT#2,GM$
END IF
'
'  XC and YC must also move.  (But this doesn't affect NEC itself.)
'
XC=XC0+VX*TP : YC=YC0+VY*TP
END IF
'
'  If target is moving rectilinearly, create GM card to cause translation.
'
X=VX*TP : Y=VY*TP
IF ABS(OMEGAV)>1D-10 AND ABS(AMPV)>1D-10 THEN
X=X+AMPV*SIN(OMEGAV*TP)*COS(VANGLE)
Y=Y+AMPV*SIN(OMEGAV*TP)*SIN(VANGLE)
END IF
IF ABS(X)>=1D-10 OR ABS(Y)>=1D-10 THEN
X=TRUNC(X,5)
Y=TRUNC(Y,5)
XSTR$=LTRIM$(STR$(CSNG(X)))
IF LEN(XSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "X motion shift (";XSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(XSTR$)<10
XSTR$=" "+XSTR$
WEND
YSTR$=LTRIM$(STR$(CSNG(Y)))
IF LEN(YSTR$)>9 THEN
CLOSE #2
PRINT
PRINT "Y motion shift (";YSTR$;") can't be written."
PRINT
STOP
END IF
WHILE LEN(YSTR$)<10
YSTR$=" "+YSTR$
WEND
GM$="GM  0    0        0.        0.        0."+XSTR$+YSTR$+"        0."+ITSSTR$
PRINT#2,GM$
END IF
END IF
'
'  Transfer rest of master NEC file.  (The IF/THEN construct is for the
' case in which the file doesn't contain a GE card and the blank GM card
' is the last line in the file.)
'
IF GMP1<GELINE THEN
FOR J=GMP1 TO GELINE
LINE INPUT#1,NEC$
NEC$=LTRIM$(NEC$)
PRINT#2,NEC$
NEXT J
ELSE
NEC$="GE"
PRINT#2,NEC$
END IF
'
' If last line just transferred isn't really a GE card, write a GE card.
'
IF LEFT$(NEC$,2)<>"GE" THEN PRINT#2,"GE"
CLOSE #1
'
'  Write program control data to SARRUN.NEC.
'
PRINT#2,FR$
'
'  Restrict accuracy of ZENITH and PHI so they (hopefully) fit in a 9-
' character space.
'
ZENITH=TRUNC(ZENITH,5)
PHI=TRUNC(PHI,5)
ZSTR$=LTRIM$(STR$(CSNG(ZENITH)))
IF LEN(ZSTR$)>9 THEN
PRINT
PRINT "SAR zenith angle (";ZSTR$;") can't be written."
PRINT
CLOSE #2
STOP
END IF
WHILE LEN(ZSTR$)<10
ZSTR$=" "+ZSTR$
WEND
PHISTR$=LTRIM$(STR$(CSNG(PHI)))
IF LEN(PHISTR$)>9 THEN
PRINT
PRINT "SAR azimuth angle (";PHISTR$;") can't be written."
PRINT
CLOSE #2
STOP
END IF
WHILE LEN(PHISTR$)<10
PHISTR$=" "+PHISTR$
WEND
EX$=EX0$+ZSTR$+PHISTR$+ETA$+"        1.        1.        1."
PRINT#2,EX$
PRINT#2,PL$
RP$=RP0$+ZSTR$+PHISTR$+"        1.        1."
PRINT#2,RP$
'
'  Termination line depends on whether entire NEC file is generated or
' just the part for particular SAR azimuth angle.
'
IF I<NA THEN
PRINT#2,"NX"
IF CELINE=0 THEN PRINT#2,"CE"
ELSE
PRINT#2,"EN"
END IF
NEXT I
CLOSE #2
'
'  NEC file exists.  Run NEC and then image formation processor via .BAT
' file.  (If NCSARSIM.INI file doesn't exist in current directory, first
' ask user for information so it can be created.)
'
IF EXIST("NCSARSIM.INI")=1 THEN GOTO HAVEINI
MAKEINI:
PRINT
NECEXE$=""
WHILE NECEXE$=""
LINE INPUT "NAME OF NEC EXECUTABLE?";NECEXE$
NECEXE$=LTRIM$(RTRIM$(NECEXE$))
WEND
PLOUT$=""
WHILE PLOUT$=""
LINE INPUT "WHAT IS THE NAME OF THE FILE GENERATED BY YOUR PL CARD?";PLOUT$
PLOUT$=LTRIM$(RTRIM$(PLOUT$))
WEND
OPEN "NCSARSIM.INI" FOR OUTPUT AS #1
PRINT#1,NECEXE$
PRINT#1,PLOUT$
CLOSE #1
HAVEINI:
OPEN "NCSARSIM.INI" FOR INPUT AS #1
IF EOF(1) THEN GOTO DONTHAVEFILES
LINE INPUT#1,NECEXE$
IF EOF(1) THEN GOTO DONTHAVEFILES
LINE INPUT#1,PLOUT$
GOTO HAVEFILES
DONTHAVEFILES:
CLOSE #1
GOTO MAKEINI
HAVEFILES:
CLOSE #1
NECEXE$=LTRIM$(RTRIM$(NECEXE$))
PLOUT$=LTRIM$(RTRIM$(PLOUT$))
PRINT
PRINT "Running NEC."
PRINT
OPEN "SARRUN.BAT" FOR OUTPUT AS #1
PRINT#1,"@ECHO OFF"
PRINT#1,"IF EXIST ";PLOUT$;" DEL ";PLOUT$
PRINT#1,NECEXE$;" <SARRUN.INP >NUL"
PRINT#1,"ECHO "
PRINT#1,"ECHO Running image formation processor."
PRINT#1,"NCSARGEN SARRUN.NEC ";PLOUT$
CLOSE #1
OPEN "SARRUN.INP" FOR OUTPUT AS #1
PRINT#1,"SARRUN.NEC"
PRINT#1,"NUL"
CLOSE #1
GOSUB CLEARKEY
CALL STACK("SARRUN")
END
CLEARKEY:
WHILE INKEY$<>"" : WEND
RETURN
'$INCLUDE: 'EXIST.FUN'
'$INCLUDE: 'FINDVESA.SUB'
'
'  This subroutine puts the character string STRNG$ into the keyboard
' buffer.  If the last character in STRNG$ is a semicolon, a carriage
' return is not added to the end of the stacked data.  Otherwise, a
' carriage return is stacked after STRNG$ is stacked.  (Put two semicolons
' at the end of STRNG$ if you physically want to put a semicolon at the
' end of the buffer.)
'
SUB STACK(STRNG$)
DIM CH(94) AS INTEGER,CL AS INTEGER,C AS INTEGER,I AS INTEGER,L AS INTEGER
DIM CR AS INTEGER,OS AS INTEGER,STCODE(1 TO 5) AS INTEGER
'
'  Store scan codes.
'
CH(0)=&H39
CH(1)=&H02
CH(2)=&H28
CH(3)=&H04
CH(4)=&H05
CH(5)=&H06
CH(6)=&H08
CH(7)=&H28
CH(8)=&H0A
CH(9)=&H0B
CH(10)=&H09
CH(11)=&H0D
CH(12)=&H33
CH(13)=&H0C
CH(14)=&H34
CH(15)=&H35
CH(16)=&H0B
CH(17)=&H02
CH(18)=&H03
CH(19)=&H04
CH(20)=&H05
CH(21)=&H06
CH(22)=&H07
CH(23)=&H08
CH(24)=&H09
CH(25)=&H0A
CH(26)=&H27
CH(27)=&H27
CH(28)=&H33
CH(29)=&H0D
CH(30)=&H34
CH(31)=&H35
CH(32)=&H03
CH(33)=&H1E
CH(34)=&H30
CH(35)=&H2E
CH(36)=&H20
CH(37)=&H12
CH(38)=&H21
CH(39)=&H22
CH(40)=&H23
CH(41)=&H17
CH(42)=&H24
CH(43)=&H25
CH(44)=&H26
CH(45)=&H32
CH(46)=&H31
CH(47)=&H18
CH(48)=&H19
CH(49)=&H10
CH(50)=&H13
CH(51)=&H1F
CH(52)=&H14
CH(53)=&H16
CH(54)=&H2F
CH(55)=&H11
CH(56)=&H2D
CH(57)=&H15
CH(58)=&H2C
CH(59)=&H1A
CH(60)=&H2B
CH(61)=&H1B
CH(62)=&H07
CH(63)=&H0C
CH(64)=&H29
CH(65)=&H1E
CH(66)=&H30
CH(67)=&H2E
CH(68)=&H20
CH(69)=&H12
CH(70)=&H21
CH(71)=&H22
CH(72)=&H23
CH(73)=&H17
CH(74)=&H24
CH(75)=&H25
CH(76)=&H26
CH(77)=&H32
CH(78)=&H31
CH(79)=&H18
CH(80)=&H19
CH(81)=&H10
CH(82)=&H13
CH(83)=&H1F
CH(84)=&H14
CH(85)=&H16
CH(86)=&H2F
CH(87)=&H11
CH(88)=&H2D
CH(89)=&H15
CH(90)=&H2C
CH(91)=&H1A
CH(92)=&H2B
CH(93)=&H1B
CH(94)=&H29
'
'  Define machine code to call interrupt.
'
DEF SEG=VARSEG(STCODE(1))
OS=VARPTR(STCODE(1))
POKE OS,&HB4 : POKE OS+1,5             'MOV AH, 5
POKE OS+2,&HB5                         'MOV CH, [scan code]
'
'  Rest of above opcode will be POKEd in later.
'
POKE OS+4,&HB1                         'MOV CL, [ascii code]
'
'  Rest of above opcode will be POKEd in later.
'
POKE OS+6,&HCD : POKE OS+7,&H16        'INT 16
POKE OS+8,&HCB                         'RETF
L=LEN(STRNG$)                          'Get length of string to be stacked.
CR=1                                   'If last character in STRNG$ is ";",
IF RIGHT$(STRNG$,1)=";" THEN           'don't stack carriage return (and don't
L=L-1                                  'include semicolon in text to be stacked)
STRNG$=LEFT$(STRNG$,L)                 'unless there are two semicolons in a row
IF RIGHT$(STRNG$,1)<>";" THEN CR=0     'at the end.
END IF
IF L>0 THEN
IF CR=0 AND L>15 THEN L=15             'Don't let L be larger than buffer.
IF CR=1 AND L>14 THEN L=14
FOR I=1 TO L                           'Stack STRNG$ one character at a time.
CL=ASC(MID$(STRNG$,I,1))
IF CL=1 THEN CL=60                     'Allow redirection and pipe symbols
IF CL=2 THEN CL=62                     'to be stacked via "gimmick."
IF CL=4 THEN CL=124
IF CL>=32 AND CL<=126 THEN             'Watch out for non-ascii stuff.
C=CL-32
POKE OS+3,CH(C)                        'Finish CH definition.
POKE OS+5,CL                           'Finish CL definition.
CALL ABSOLUTE(OS)                      'Call interrupt.
END IF
NEXT I
END IF
IF CR<>0 THEN
POKE OS+3,&H1C                         'Send carriage return if
POKE OS+5,13                           'appropriate to do so.
CALL ABSOLUTE(OS)
END IF
DEF SEG
END SUB
'
'  This function truncates the accuracy of the double precision value X
' to N decimal places.
'
FUNCTION TRUNC#(X AS DOUBLE,N AS INTEGER)
TRUNC=FIX(X*10#^N+10#^(-N)*SGN(X))*10#^(-N)
END FUNCTION
'
'  This function returns Y modulo X.  (Y MUST NOT BE ZERO.)
'
FUNCTION DMOD#(X AS DOUBLE,Y AS DOUBLE)
DMOD=X-Y*FIX(X/Y+.00001#*SGN(X/Y))
END FUNCTION
