// Machine dependent
// NOTE: Not implemented for non Win32 platforms

#include "machdep.h"
#include "stand.h"

// Non-windows platforms here
#if PLATFORM != PLATFORM_WIN
	// Implement missing functions for 16/32 bit Windows or DOS or Unix here

bool CopyFile(const char *fromPath, const char *toPath, bool failIfExists) {
    if (failIfExists && Exists(toPath)) {
       return false;
    }
    // for Unix use mv
#   if PLATFORM == PLATFORM_UNIX
	move( fromPath, toPath );
#   else
	// put your own implementation here
	throw Exception("CopyFile not implemented on this platform.");
#   endif
}

bool DeleteFile(const char *path) {
#  if PATFORM==PLATFORM_UNIX
	// for Unix use remove
	remove(path);
#  else
	// put your own implementation here
	throw Exception("DeleteFile not implemented on this platform");
#  endif
	return true; // fake it
}

#endif // != PLATFORM_WIN


// All Platforms here

// Mimic Borland C++ functionality
// Make all directories in pathname exist
void MakeDir(const char *path) {
	string pathName(path);
	string::size_type pos = 0;
	// handle Unix delimiters
	for ( pos=pathName.find("/",pos); pos!=string::npos;pos=pathName.find("/",pos+1) ) {
		string dir = pathName.substr(0,pos);
		if (!Exists(dir.c_str())) {
			mkdir(dir.c_str());
		}
	}
	pos = 0;
	// handle DOS delimiters (what a mess that Bill and his mates made!)
	for ( pos=pathName.find("\\",pos); pos!=string::npos;pos=pathName.find("\\",pos+1) ) {
		string dir = pathName.substr(0,pos);
		if (!Exists(dir.c_str())) {
			mkdir(dir.c_str());
		}
	}
	mkdir(pathName.c_str());
}

