
/******************************************************
 *                                                    *
 * KCT-T project.                                     *
 *                                                    *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org         *
 *                                                    *
 * Version 0.1 14/03/99 : Initial release             *
 *                                                    *
 ******************************************************/

/******************************************************
 *                                                    *
 * tracker.c                                          *
 *                                                    *
 * Interface with the kct driver                      *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <kctlib.h>

kctdev KctOpen(int board)
{
	char device[10];
	
	sprintf(device, "/dev/kct%d", board);
	return open("/dev/kct0", O_RDWR);
}

void KctClose(kctdev dev)
{
	if (dev != -1)
		close(dev);
}

int KctSetBrake(kctdev dev, int port, int tempo_rel, int tempo_set)
{
	int nb;
	unsigned char buf[4];

	buf[0] = port;
	buf[1] = KCT_RELBRAKE;
	buf[2] = 1;
	buf[3] = tempo_rel;	
	nb = write(dev, buf, 4);
	if (nb != 4)
		return nb;
		
	buf[0] = port;
	buf[1] = KCT_SETBRAKE;
	buf[2] = 1;
	buf[3] = tempo_set;	
	return write(dev, buf, 4);
}

int KctSetWindow(kctdev dev, int port, int val)
{
	unsigned char buf[4];

	if (val < 0 || val > 25)
		return -1;
		
	buf[0] = port;
	buf[1] = KCT_SETSLEW;
	buf[2] = 1;
	buf[3] = val;	
	return write(dev, buf, 4);
}

int KctSetPosition(kctdev dev, int rotor, int pos)
{
	unsigned char buf[4];

	if (pos < 0 || pos > 255)
		return -1;
		
	buf[0] = rotor;
	buf[1] = 0;
	buf[2] = 1;
	buf[3] = (unsigned char)pos;

	return write(dev, buf, 4);
}

int KctGetStatus(kctdev dev, kctstat *stat)
{
	int ret;
	unsigned char buf[12];

	memset(stat, 0, sizeof(kctstat));
	
	ret = read(dev, buf, 12);
	if (ret != 12)
	{
		printf("read=%d control=%02x\n", ret, buf[3]);
		return -1;
	}
	
	stat->control     = (int)buf[3] & 0xff;
	stat->site_pos    = (int)buf[4] & 0xff;
	stat->site_win    = (int)buf[5] & 0xff;
	stat->azim_pos    = (int)buf[8] & 0xff;
	stat->azim_win    = (int)buf[9] & 0xff;
	stat->site_brksel = ((int)buf[6] & 0xff) * 100;
	stat->site_brkrel = ((int)buf[7] & 0xff) * 100;
	stat->azim_brksel = ((int)buf[10] & 0xff) * 100;
	stat->azim_brkrel = ((int)buf[11] & 0xff) * 100;
	
	return 0xff & (int)buf[3];
}
