
/******************************************************
 *                                                    *
 * KCT-T project.                                     *
 *                                                    *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org         *
 *                                                    *
 * Version 0.1 14/03/99 : Initial release             *
 *                                                    *
 ******************************************************/

/******************************************************
 *                                                    *
 * tuner.c                                            *
 *                                                    *
 * Interface with the kct driver                      *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <kctlib.h>

int KctSetLine(kctdev dev, int port, int param)
{
	unsigned char buf[4];
	buf[0] = port;
	buf[1] = KCT_SETBAUD;
	buf[2] = 1;
	buf[3] = param;	
	return write(dev, buf, 4);
}

int KctSetFrequency(kctdev dev, int port, int rig, int addr, double freq)
{
	int len = -1;
	char buf[80];
	
	switch (rig)
	{
	case KCT_ICOM :
		len = KctSetFrequencyIcom(buf+3, sizeof(buf) - 3, addr, freq);
		break;
	}
	
	if (len > 0)
	{
		buf[0] = port;
		buf[1] = KCT_SENDTRX;
		buf[2] = len;

#if 0
		{
			int i;

			for (i = 0 ; i < len+3 ; i++)
				printf("%02x ", buf[i] & 0xff);
			printf("\n");
		}
#endif
		return write(dev, buf, len+3);
	}
	return -1;
}

