
/******************************************************
 *
 * KCT-T project.
 *
 * Jean-Paul ROUBELAT - F6FBB - jpr@f6fbb.org
 *
 * Version 0.1 14/03/99 : Initial release
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************/

/******************************************************
 *                                                    *
 * kctcal.c                                           *
 *                                                    *
 * Set the position of the rotor                 *
 *                                                    *
 ******************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <kctlib.h>


int main(int ac, char **av)
{
	kctdev dev;
	kctstat kstat;
	double azimuth;
	double site;
	int verbose = 0;
	
	if (ac < 3)
	{
		fprintf(stderr, "usage : rotor azimuth elevation\n");
		return 1;
	}
	
	if (strcmp(av[1], "-v") == 0)
	{
		verbose = 1;
		--ac;
		++av;
	}
	
	azimuth = atol(av[1]);
	site = atol(av[2]);
	
	dev = KctOpen(0);
	if (dev == -1)
	{
		fprintf(stderr, "Cannot open kct device\n");
		return 1;
	}

	KctSetAzimuth(dev, azimuth);
	KctSetSite(dev, site);
	
	while (1)
	{
		int res = KctGetStatus(dev, &kstat);
		if (verbose && res != -1)
		{
			printf("\rPos : Azimuth=%-3d Elevation=%-3d", (int)(KctGetAzimuth(dev) + .5), (int)(KctGetSite(dev) + .5));
			fflush(stdout);
		}
		if (res == 0)
			break;
		sleep(1);
	}

	KctClose(dev);
	printf("\n");
	
	return 0;
}
