/******************************************************************************
* G1NNA BBS server.                                                           *
*                                                                             *
* This is an example of a server which can be called using the OS command.    *
* This one looks up locators in the database built up by the example          *
* post-connection server. It's not very useful, and is mainly provided to     *
* show what could be done. 																   *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <ctype.h>

#define FALSE	0
#define TRUE	1


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = user callsign.
argv[5] = user name.
argv[6] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	char		found;
	char		callsign[7];
	char		locator[7];
	FILE *	fp;

	if (strcmp(argv[6], "") == 0)
	{
		/* If no callsign supplied, ask for it. */
		fp = fopen(argv[2], "w");
		fprintf(fp,
				"Please enter the callsign of the person who's locator you want\n");
		fprintf(fp, "or ? for help.\n");
		fclose(fp);
		/* Ask for the server to be run again, without incrementing the level. */
		exit(3);
	}

	if (strcmp(argv[6], "?") == 0)
	{
		/* It's always a good idea to offer help! */
		fp = fopen(argv[2], "w");
		fprintf(fp, "This server looks up the locator of a user of this BBS from"
						" a database of\nlocators. The information is only as good as"
						" that supplied by the users.\n");
		fprintf(fp, "To look up a locator, run this server using the command\n");
		fprintf(fp, "OS LOCATOR CALLSIGN\n");
		fprintf(fp, "where CALLSIGN is the callsign of the user, e.g.\n");
		fprintf(fp, "OS LOCATOR G1NNA\n");
		fprintf(fp, "will look up the locator of G1NNA.\n");
		fclose(fp);
		/* Don't ask for the server to be run again - the user might not want */
      /* to now that they know what it does! */
		exit(0);
	}

	/* Convert the callsign to upper case. */
	strupr(argv[6]);

	found = FALSE;
	fp = fopen("locators.dat", "r");
	if (fp != NULL)
	{
		/* Look for the callsign */
		while (!feof(fp) && !found)
		{
			fscanf(fp, "%6s %6s", callsign, locator);
			if (strcmp(callsign, argv[6]) == 0)
			{
				found = TRUE;
			}
		}
		fclose(fp);
	}

	fp = fopen(argv[2], "w");
	if (found)
	{
		/* Found it */
		fprintf(fp, "%s's locator is %s\n", argv[6], locator);
	}
	else
	{
		/* Not found */
		fprintf(fp, "Unable to find the locator for %s\n", argv[6]);
	}
	fclose(fp);

	/* All done */
	exit(0);
}
