/******************************************************************************
* G1NNA BBS pre-connection filter.                                            *
*                                                                             *
* This program is called by the G1NNA BBS program before a user is fully      *
* connected to the BBS, but after the BBS has done its own checks (e.g. that  *
* the callsign is valid, that the user isn't excluded or already connected).  *
*                                                                             *
* This example prevents connections by anyone other than remote SysOps and    *
* BBSs during the hours specified in the file contime.bbs.                    *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#define FALSE	0
#define TRUE	1

#define REMOTE		4
#define BBS			8


/**************
* skipcomment *
**************/

/* Skip over a comment. */

void skipcomment(FILE * fp)
{
	char	c;

	c = fgetc(fp);
	while (c == ';')
	{
		while (c != '\012')
		{
			c = fgetc(fp);
		}
		c = fgetc(fp);
	}
	ungetc(c, fp);
}


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = user callsign.
argv[5] = user name.
argv[6] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	char			times[6];
	char			start[3];
	char			end[3];
	char			ok;
	unsigned		usertype;
	FILE *		fp;
	struct time	now;

	/* If user is a remote SysOp or BBS, then allow them to connect. */
	usertype = atoi(argv[3]);
	if ((usertype & REMOTE) || (usertype & BBS))
	{
		exit(0);
	}

	/* Open configuration file. */
	fp = fopen("CONTIME.BBS", "r");
	if (fp == NULL)
	{
		/* Can't find configuration file. Allow transfer. */
		exit(0);
	}

	/* Get the time. */
	gettime(&now);

	/* Skip over any comments. */
	skipcomment(fp);

	ok = TRUE;
	/* Check the times. */
	while (!feof(fp))
	{
		fscanf(fp, "%5[^,]", times);
		strcpy(start, "");
		strcpy(end, "");
		sscanf(times, "%2[^-]-%2s", start, end);
		if ((now.ti_hour >= atoi(start)) && (now.ti_hour <= atoi(end) - 1))
		{
			ok = FALSE;
		}
		fscanf(fp, "%*c");
	}
	fclose(fp);

	if (ok)
	{
		/* Connection is allowed. */
		exit(0);
	}

	/* Connection isn't allowed. */
	fp = fopen(argv[2], "w");
	fprintf(fp, "Sorry - you cannot connect to the BBS at the moment."
				   " Please try again later.\n");
	fclose(fp);
	exit(1);
}
