/******************************************************************************
* G1NNA BBS pre-file transfer filter.                                         *
*                                                                             *
* This program is called by the G1NNA BBS program before a file transfer      *
* operation takes place (i.e. D, DI, DB, YD, U, UI, UB, YU).                  *
* It is not called when a file transfer is carried out from a terminal        *
* window.                                                                     *
*                                                                             *
* This example prevents file transfers during the hours specified in the file *
* xfertime.bbs, and also prevents downloads by users with restricted access,  *
* if required.                                                                *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#define FALSE	0
#define TRUE	1

#define SYSOP		128
#define RESTRICT	256

/**************
* skipcomment *
**************/

/* Skip over a comment. */

void skipcomment(FILE * fp)
{
	char	c;

	c = fgetc(fp);
	while (c == ';')
	{
		while (c != '\012')
		{
			c = fgetc(fp);
		}
		c = fgetc(fp);
	}
	ungetc(c, fp);
}


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = callsign.
argv[5] = name.
argv[6] = name of file to be transferred.
argv[7] = type of file transfer (1 = text, 2 = NPF binary, 3 = NPF image,
			 4 = YAPPC).
argv[8] = direction of transfer ("U" for upload, "D" for download).
argv[9] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	char			times[6];
	char			start[3];
	char			end[3];
	char			string[80];
	char			ok;
	FILE *		fp;
	struct time	now;

	/* If user is a SysOp, then allow the transfer. */
	if (atoi(argv[3]) & SYSOP)
	{
		exit(0);
	}

	/* Open configuration file. */
	fp = fopen("XFERTIME.BBS", "r");
	if (fp == NULL)
	{
		/* Can't find configuration file. Allow transfer. */
		exit(0);
	}

	/* Get the time. */
	gettime(&now);

	/* Skip over any comments. */
	skipcomment(fp);

	/* Find out whether restricted access users can download. */
	fscanf(fp, "%s%*c", string);
	if ((strcmp(string, "YES") == 0) && (strcmp(argv[8], "D") == 0) &&
			(atoi(argv[3]) & RESTRICT))
	{
		/* Restricted users cannot download. */
		fclose(fp);
		fp = fopen(argv[2], "w");
		fprintf(fp, "You have restricted access and may not download files.\n");
		fclose(fp);
		exit(1);
	}

	/* Skip over any comments. */
	skipcomment(fp);

	ok = TRUE;
	/* Check the times. */
	while (!feof(fp) && ok)
	{
		fscanf(fp, "%5[^,]", times);
		strcpy(start, "");
		strcpy(end, "");
		sscanf(times, "%2[^-]-%2s", start, end);
		if ((now.ti_hour >= atoi(start)) && (now.ti_hour <= atoi(end) - 1))
		{
			ok = FALSE;
		}
		fscanf(fp, "%*c");
	}
	fclose(fp);

	if (ok)
	{
		/* File transfer is allowed. */
		exit(0);
	}

	/* File transfer isn't allowed. */
	fp = fopen(argv[2], "w");
	fprintf(fp, "File transfers are not allowed between %s:00 and %s:00.\n",
					start, end);
	fprintf(fp, "Please try later.\n");
	fclose(fp);
	exit(1);
}
