
/*
 * Sample Code. This routines demonstrates how the satellite parameters
 * received from VersaTrack can be used to update a control in a dialog
 * box. The code is neither elegant nor efficient nor useful. It is just
 * meant as a sample...
 */

#include "resource.h"
#include "radextrn.h"
#include "vsttype.h"
#include <math.h>
#include <time.h>

extern radparam_t rigInfo;
static char buf[256];

struct dupdate {
    int id;
    char *str;
} utab[] = {
    IDC_RDISPLAY_RXFREQ, buf,
    IDC_RDISPLAY_TXFREQ, buf+16,
    IDC_RDISPLAY_RXCENTER, buf+32,
    -1, NULL,
};

static void
DChildPos(HWND hwnd, int *xsize, int *ysize)
{
    RECT r;
    int extra_x, extra_y;

    extra_x = GetSystemMetrics(SM_CXFRAME) * 2;
    extra_y = GetSystemMetrics(SM_CYFRAME) * 2 +
              GetSystemMetrics(SM_CYCAPTION) +
              GetSystemMetrics(SM_CYMENU); /* Optional */
    
    GetClientRect(hwnd, &r);
    *xsize = r.right  + extra_x;
    *ysize = r.bottom + extra_y;
}


fdummy(radparam_t *rp) /* needed because of compiler optimization
    assumes the value does not ever change and loads it into a register... */
{
    return rp->radio.ra_doppler;
}

void
rdisp_update()
{
    radioinfo_t *rp;
    int f, ghz, mhz, khz, d;
    extern HWND rdhwnd;

    if (!rdhwnd)
        return;
        
    rp = &rigInfo.radio;
    fdummy(&rigInfo);
    if (buf[32] == 0) {
        ghz = rp->ra_rxcenter / 1000000;
        mhz = rp->ra_rxcenter / 1000;
        khz = (rp->ra_rxcenter - (mhz * 1000)) * 1000;
        sprintf(buf+32, "%02d.%03d.%06d", ghz, mhz, khz); /* rx center */
    }
    d = rp->ra_doppler / 1000;
    f = rp->ra_rxcenter + d;
    d = rp->ra_doppler - (d * 1000);
    fdummy(&rigInfo);
    ghz = f / 1000000;
    mhz = f / 1000;
    khz = (f - (mhz * 1000)) * 1000 + d;
    sprintf(buf+ 0, "%02d.%03d.%06d", ghz, mhz, khz);
    fdummy(&rigInfo);
    ghz = rp->ra_txcenter / 1000000;
    mhz = rp->ra_txcenter / 1000;
    khz = (rp->ra_txcenter - (mhz * 1000) ) * 1000;
    sprintf(buf+ 16, "%02d.%03d.%06d", ghz, mhz, khz);

    PostMessage(rdhwnd, WM_USER+1, (WPARAM) 0, (LPARAM) buf);
}

BOOL CALLBACK
RadioDisplay(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    int cmd, xs, ys;
    extern HWND rdhwnd;
    struct dupdate *dp;

    if (message == WM_MOUSEMOVE)
        return TRUE;
            
    switch(message) {
        case WM_INITDIALOG:
            DChildPos(hwnd, &xs, &ys);
            /* Adjust the size of parent so we'll fill its main window area */
            SetWindowPos(hwnd, 0, 0, 0, 0, 0,
                SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW);
            SetWindowPos(Gwnd, 0, 0, 0, xs, ys,
                SWP_NOMOVE | SWP_NOZORDER | SWP_SHOWWINDOW);
            rdisp_update();                
            return TRUE;

        case WM_COMMAND:
            cmd = LOWORD(wParam);
            break;

        case WM_CLOSE:
            DestroyWindow(hwnd);
            rdhwnd = NULL;
            return TRUE;

        case WM_USER+1:            
            for (dp = utab; dp->str; dp++)
                SendDlgItemMessage(hwnd, dp->id, WM_SETTEXT, (WPARAM)0,
                    (LPARAM) dp->str);
            break;
        default:
            break;
    }
    return FALSE;
}

       
