/* CWMSTXRX.c */
/****************************************************************************
 * Compilation avec aucune optimisation ; sinon a revoir pour lecture BF
 * JPM 31/01/96
 *   Mesure temps commutation signal BF par signal DSR port srie PC+interface.
 *   Utilise le timer 0 du 8254 comme base de temps.
 *
 * PRINCIPE:
 *   ALIMENTATION DE L'INTERFACE : INT1C
 *   - Le programme dtourne les interruptions horloge 8254 (OUT0), si
 *     alimentation de l'interface en alternatif.
 *   - Cette horloge (55ms) permet d'inverse les signaux
 *     DTR et RTS pour alimenter l'interface hard en alternatif.
 *   - Toutefois, le montage fonctionne aussi avec alimentation
 *     en continu : donc plus simple, montage hard simplifi.
 *
 *   LECTURE DU SIGNAL BF :
 *   - Chaque alternance du signal BF change l'tat du signal DSR.
 *   - Ce changement d'tat provoque une demande d'interruption.
 *   - Le gestionnaire d'interruption port vient lire le compteur 0 du
 *     timer 8254 pour calculer le temps coul depuis le dernier
 *     changement d'tat. Il le stocke dans le buffer lecture.
 *
 *   NB:   COMPILER SANS VERIFIFICATION DU STACK
 *      modifier RS_PORT et RS_IRQ suivant port utilis
 *      ALIM18HZ selection alimentation interface
 *      DELTA_MAX ventuellement modifiable
 *
 ************************************************************************** */

/* *************** DEBUT INSTRUCTIONS PRE-PROCESSEUR ************** */
#include"io.h"
#include"stdio.h"
#include"conio.h"
#include"dos.h"
#include"math.h"
#include"stdlib.h"
#include"string.h"
#include"process.h"
#include"signal.h"
/* *************** FIN INSTRUCTIONS PRE-PROCESSEUR **************** */

/* *************** DEBUT PROTOTYPES ******************************* */
void fichier();
void razdelta(void);
void traite (void);
void slep(int l);
void affcadre(void);
void affact (void);
void affbuf(unsigned int l);
void afmsg(void);
void ms(char *st);
void aftime(void);
void afm(int l);
void PR(int colonne,int ligne, char *string);
void lecture (void);
void ligne(int lig);
void cadre(int ligne1, int colonne1, int ligne2, int colonne2);
void fenetre(int ligne1, int colonne1, int ligne2, int colonne2, char *string, int l);
void lissage (void);
void decode(void);
void enableRS(void);
void disableRS(void);
void interrupt itRS(void);
void interrupt int1c(void);
void txx(void);
void kbb(void);
void aft(void);
void zz(void);
void hdb(void);
void aff(int key);
void point(void);
void trait(void);
void blanc(void);
void conversion(void);
void calcul(void);
void menu(void);
void emission(void);
void periode(void);
void testfin(void);
char maj(char s);
/* ************** FIN PROTOTYPES ********************************** */

/* ***************DEBUT DECLARATION VARIABLES********************** */
/* port srie utilise */
/* -------------------*/
#define RS_PORT     0x3f8 /* com: port */
#define RS_IRQ      0x04  /* nb: int = irq + 8 */
/* alim interface par rts/dtr: ALIM18HZ = 0 -> continu, = 1 ->  en 18Hz */
/* -------------------------------------------------------------------- */
#define ALIM18HZ  0
/* definition des registres liaison srie */
/* -------------------------------------- */
#define RS_VAL_INT   RS_PORT + 1 /* valid interuptions */
#define EMSI         0x0A
#define RS_ID_INT    RS_PORT + 2   /* identification int */
#define RS_CMDE_L    RS_PORT + 3   /* registre de commande   */
#define RS_CMDE_MDM  RS_PORT + 4   /* commande modem   */
#define DTR          0x01
#define RTS          0x02
#define OUT2         0x08
#define LOOP         0x10
#define RS_ETAT_MDM  RS_PORT + 6
#define DDSR         0x02
#define DSR          0x20
/* controleur d'interruptions */
/* -------------------------- */
#define A8259        0x20 /* porte a ctrl interup   */
#define B8259        0x21 /* porte B   */
#define EOI          0x20 /* aqt 8259   */
/* timer PC  8254 */
/* ------------- */
#define T8254CPT0    0x40
#define T8254CMD     0x43
/* sauvegarde vecteurs int */
/* ----------------------- */
static void interrupt (*sVec1C)(int);   /* horloge 54,9 ms   */
static void interrupt (*sVecRS)();   /* liaison srie   */
/* buffer circulaire des delta t mesurs */
/* ------------------------------------- */
#define DELTA_MAX 10000                            // taille de chaque buffer
//#define NBBUF 10                                 // nombre de buffers
unsigned long int delta_t[DELTA_MAX], enregistre;  // buffer BF
unsigned int delta_lec;                            // index de lecture
unsigned int delta_ecr;                            // index ecriture
unsigned long int pause,fact,pt,repet;             //
unsigned int perio,hdebu,mx,lisse,ee,dee;          //
char e;                                            //
int key,dpdt;                                      //Touche, Flag de dpart,
struct date auj,dpt;                               // Date relle, Date de dpart
struct time maint,dep;                             // Heure relle, Heure dpart TX
struct time start,stop,fff;                        // Heure dpart, arrt lecture BF
struct time fff;                                   // Heure fin periode TX
unsigned int max,min;                              // Max et min valeurs buffer RX
unsigned long int moy,somme;                       // Moy et somme valeurs buffer RX
char message2[100];                                // Message contenu dans MESSAGE2.DAT
char message1[100];                                // Message contenu dans MESSAGE1.DAT
char indicatif[15];                                // Indicatif contenu dans INDICAT.DAT
char locator[10];                                  // Locator contenu dans LOCATOR.DAT
char string[100];                                  // Message  emettre
char strang[1200];                                 // Traduction de string en points et traits
/* ***************FIN DECLARATION VARIABLES********************** */

#if ALIM18HZ
/*************************************************************************
 * gestion int horloge
 *   - inverse DTR et RTS sur liaison srie pour alim interface
 *   - appel gestionnaire d'origine
 * N'EST PAS UTILISE : ALIMENTATION EN CONTINU : ALIM18HZ = 0
 *************************************************************************/
void interrupt int1c(void)
   {
   disable();
outportb(RS_CMDE_MDM,OUT2 | (((inportb(RS_CMDE_MDM) & DTR) ? RTS : DTR)));
outportb(A8259, EOI);                           // aqt controleur it ?????????????????
// normalement on devrait redonner la main a sVec1C qui lance EOI
// mais marche pas ??
//   (*sVec1C)(0);                              // appel int origine ???????????????
   enable();                                    // En tout cas, ca marche comme a !!!!
}
#endif

/************************************************************************
 * gestion int liaison srie
 *    - si l'int provient d'un changement d'etat du DSR:
 *       -calcul la dure de la transition
 *      nb: calcul du delta: le compteur est un dcompteur 16 bits
 *          -si newcpt < oldcpt: delta = oldcpt - newcpt
 *          -si newcpt > oldcpt: delta = (oldcpt - 0) + (0 - newcpt)
 *                     = oldcpt - newcpt
 *      -memorise cette valeur dans le buffer delta_t
 *   NB: la saturation du buffer n'est pas traite car perte invitable
 *       du message.
 ***********************************************************************/
void interrupt itRS(void)
   {
   static unsigned int oldcpt = 0;
   unsigned int newcpt;
   disable();
   if (inportb(RS_ETAT_MDM) & DDSR)                // normalement : pas d'autre int
    {
      outportb(0x061,inportb(0x061)^0x02);          // Sortie sur le HP
      outportb(T8254CMD, 0);                       // latch pour lect lsb puis msb compteur No 0
      newcpt = inportb(T8254CPT0) | (inportb(T8254CPT0) << 8);
      delta_t[++delta_ecr] = oldcpt - newcpt;
      if (delta_ecr >= DELTA_MAX) {delta_ecr = 0;mx++;}
      oldcpt = newcpt;
      }
   outportb(A8259, EOI);                            // aqt controleur it
// pokeb(0x00400,0x1E,delta_ecr);                    // Ca marche mais trouver adresse ecran pour + vite
   enable();
}

void main ()
{
clrscr();
cprintf("PATIENCE : CALCUL DE LA VITESSE DE VOTRE ORDINATEUR");
calcul();
cprintf("\r\nLECTURE DES FICHIERS DE CONFIGURATION");
fichier();
clrscr();
textcolor(YELLOW);
textbackground(BLUE);
affcadre();
aff(1);
outportb(RS_CMDE_MDM, 0x08);                        // arret keyer
outportb(0x061,inportb(0x061)&0x0FE);               // Inhibe sortie timer vers HP
   // init variables
   // --------------
#if ALIM18HZ
sVec1C = getvect(0x1C);
#endif

sVecRS = getvect(RS_IRQ + 8);
razdelta();
while(1)
 {
 blanc();
 menu();
 do
  {
  emission();
  //if (key>0) break;
  if (pause*pt!=0)
    {
    if (key<1) { slep(pause); }
    }
  }
 while(!key*repet*pt!=0);
 }
}



void fichier()                                       // LECTURE DES FICHIERS DATA
{
FILE *in;
int l;
 if ((in=fopen("C:\\CWMSTXRX\\INDICAT.DAT","rt"))==NULL)
 {
 cprintf("\r\nIMPOSSIBLE D'OUVRIR LE FICHIER INDICAT.DAT");
 exit (0);
 }
 cprintf("\r\n LECTURE DE L'INDICATIF INDICAT.DAT");
 fgets(indicatif,12,in);
 fclose (in);
 strcat(indicatif,'\0');
 for(l=0;l<strlen(indicatif);l++)
   {
   if(indicatif[l]==0x0A)indicatif[l]='\0';
   if(indicatif[l]==0x0D)indicatif[l]='\0';
   if(indicatif[l]==0x1A)indicatif[l]='\0';
   }
 cprintf("\r\n VOTRE INDICATIF EST = %s.",indicatif);

 if ((in=fopen("C:\\CWMSTXRX\\LOCATOR.DAT","rt"))==NULL)
 {
 cprintf("\r\nIMPOSSIBLE D'OUVRIR LE FICHIER LOCATOR.DAT");
 exit (0);
 }
// cprintf("\r\n LECTURE DU LOCATOR LOCATOR.DAT");
 fgets(locator,8,in);
 fclose (in);
 strcat(locator,'\0');
 for(l=0;l<strlen(locator);l++)
   {
   if(locator[l]==0x0A)locator[l]='\0';
   if(locator[l]==0x0D)locator[l]='\0';
   if(locator[l]==0x1A)locator[l]='\0';
   }
 cprintf("\r\n VOTRE LOCATOR EST = %s",locator);

 if ((in=fopen("C:\\CWMSTXRX\\MESSAGE1.DAT","rt"))==NULL)
 {
 cprintf("\r\nIMPOSSIBLE D'OUVRIR LE FICHIER MESSAGE1.DAT");
 exit (0);
 }
// cprintf("\r\n LECTURE DU MESSAGE1 MESSAGE1.DAT");
 fgets(message1,39,in);
 fclose (in);
 strcat(message1,'\0');
 for(l=0;l<strlen(message1);l++)
   {
   if(message1[l]==0x0A)message1[l]='\0';
   if(message1[l]==0x0D)message1[l]='\0';
   if(message1[l]==0x1A)message1[l]='\0';
   }

 if ((in=fopen("C:\\CWMSTXRX\\MESSAGE2.DAT","rt"))==NULL)
 {
 cprintf("\r\nIMPOSSIBLE D'OUVRIR LE FICHIER MESSAGE2.DAT");
 exit (0);
 }
// cprintf("\r\n LECTURE DU MESSAGE2 MESSAGE2.DAT");
 fgets(message2,39,in);
 fclose (in);
 strcat(message2,'\0');
 for(l=0;l<strlen(message2);l++)
   {
   if(message2[l]==0x0A)message2[l]='\0';
   if(message2[l]==0x0D)message2[l]='\0';
   if(message2[l]==0x1A)message2[l]='\0';
   }
//sleep(3);
}



void slep(int l)
 {
     int i;
     for (i=1;i<=l;i++)
     {
     if(kbhit()!=0){key=1;kbb();return;} else sleep(1);
     }
 }

void periode (void)
{
window(2,16,79,23);
clrscr();
PR(1,1,"  0) = Pas de periode");
PR(25,1,"1) = 1 minute");
PR(50,1,"2) = 2 minutes");
PR(1,2,"  3) = 2,5 minutes");
PR(25,2,"4) = 5 minutes");
PR(50,2,"5) = 30 secondes");
PR(1,3,"  6) = 10 secondes");
window(1,1,80,25);
kbb();
e=0;

while(e<3*16)
{
 while(!kbhit()){aft();}
 e=getch();
if(e>16*3+6)e=0;
}
aftime();
window(2,16,79,23);
clrscr();
window(1,1,80,25);
dpdt=0;
perio=1;if (e=='0'){perio=0;}
}

void zz (void)
{
switch(e)
   {
   case '0' :
      break;
   case '1' :
      fff.ti_min=dep.ti_min+1;break;
   case '2' :
      fff.ti_min=dep.ti_min+2;break;
   case '3' :
      fff.ti_min=dep.ti_min+2;
      fff.ti_sec=dep.ti_sec+30;break;
   case '4' :
      fff.ti_min=dep.ti_min+5;break;
   case '5' :
      fff.ti_sec=dep.ti_sec+30;break;
   case '6' :
      fff.ti_sec=dep.ti_sec+10;break;
   defaut   : e='0';break;
   }
aftime();
}

void hdb (void)
{
unsigned int m;
 window(2,16,79,23);
 clrscr();
 PR(1,1,"  Heure de dpart : ");
 m=0x0FF;
 while((m<0)||(m>=24))
  {
  m=0x0FF;/////
  window(2,16,79,23);
  clrscr();
  PR(1,1,"  Heure de dpart : ");
  kbb();
  while(!kbhit()){aft();}
  window(2,16,79,23);
  PR(1,1,"  Heure de dpart : ");
  window(30,16,79,23);
  cscanf("%d",&m);
  }
 dep.ti_hour=m;
 aftime();
 m=0x0FF;
 while((m<0)||(m>=60))
  {
 m=0x0FF;/////
  window(2,16,79,23);
  clrscr();
  PR(1,1,"  Minute de dpart : ");
  kbb();
  while(!kbhit()){aft();}
  window(2,16,79,23);
  PR(1,1,"  Minute de dpart : ");
  window(30,16,79,23);
  cscanf("%d",&m);
  }
 dep.ti_min=m;
 aftime();
 //kbb();
 m=0x0FF;
 while((m<0)||(m>=60))
  {
 m=0x0FF;/////
  window(2,16,79,23);
  clrscr();
  PR(1,1,"  Seconde de dpart : ");
  kbb();
  while(!kbhit()){aft();}
  window(2,16,79,23);
  PR(1,1,"  Seconde de dpart : ");
  window(30,16,79,23);
  cscanf("%d",&m);
  }
 dep.ti_sec=m;
 aftime();

 window(1,1,80,25);

 fff.ti_hour=dep.ti_hour;
 fff.ti_min=dep.ti_min;
 fff.ti_sec=dep.ti_sec;
 fff.ti_hund=dep.ti_hund;
 hdebu=1;
 dpdt=0;
 aftime();
 //affcadre();
 aff(1);
}


void testfin (void)
{
long unsigned int  ff,mm,dd;
unsigned int x;
unsigned int y;
 gettime(&maint);
 while (fff.ti_sec>=60){fff.ti_sec=fff.ti_sec-60;fff.ti_min++;}
 while (fff.ti_min>=60){fff.ti_min=fff.ti_min-60;fff.ti_hour++;}
 while (fff.ti_hour>24){fff.ti_hour=fff.ti_hour-24;}
 while (dep.ti_hour>24){dep.ti_hour=dep.ti_hour-24;}
 if(maint.ti_hour==23&&dep.ti_hour==0){dep.ti_hour=24;}
 if(maint.ti_hour==0&&dep.ti_hour>=24){dep.ti_hour=0;}
 if(maint.ti_hour==23&&fff.ti_hour==0){fff.ti_hour=24;}
 if(maint.ti_hour==0&&fff.ti_hour>=24){fff.ti_hour=0;}
 ff=fff.ti_min*60+fff.ti_sec;
 mm=maint.ti_min*60+maint.ti_sec;
 dd=dep.ti_min*60+dep.ti_sec;
 if(((dd<=mm)&&(mm<ff))&&(dep.ti_hour==maint.ti_hour))
  {
       if(dpdt==0)
       {
       aftime();
       }
  dpdt=1;
  if(enregistre==0){enregistre=1;disableRS();}
  }else{
  if(enregistre==1){razdelta();}
    dpdt=0;
    if((mm>ff)||(fff.ti_hour<maint.ti_hour))
       {
        dep.ti_hour=fff.ti_hour;
        dep.ti_min=fff.ti_min;
        dep.ti_sec=fff.ti_sec;
        zz();
        dep.ti_hour=fff.ti_hour;
        dep.ti_min=fff.ti_min;
        dep.ti_sec=fff.ti_sec;
        zz();
       aft();
       }
    }
}


void point (void)
{
unsigned long int k;
for (k=0;k<pt*1;++k){outportb(RS_CMDE_MDM, 0x09);outportb(RS_CMDE_MDM, 0x09);}
outportb(RS_CMDE_MDM, 0x08);outportb(RS_CMDE_MDM, 0x08);   /* arret keyer   */
}

void trait (void)
{
unsigned long int k;
for (k=0;k<pt*3;++k){outportb(RS_CMDE_MDM,0x09);}
outportb(RS_CMDE_MDM,0x08);outportb(RS_CMDE_MDM,0x08); /* arret keyer   */
}

void blanc(void)
{
unsigned long int k;
 for (k=0;k<pt;++k)
   {
   outportb(RS_CMDE_MDM, 0x08);outportb(RS_CMDE_MDM, 0x08); /* arret keyer   */
//   if((0x08&inportb(0x379))==0){repet=0;}/*test du bit ACK* = broche 10 */
   }
}



void ms(char *st)
{
 kbb();
 window(2,16,79,23);
 clrscr();
 cprintf("%s",st);
 strcpy(string,"");
 while(strlen(string)==0)
 {
 strcpy(string,"");
 kbb();
 window(2,16,79,23);
 clrscr();
 cprintf("%s",st);
 while(!kbhit())aft();
 window(2,16,79,23);
 cprintf("%s",st);
 window(4,17,79,23);
 gets(string);
 }
strcat(string,'\0');
window(1,1,80,25);
afmsg();
}

void menu (void)
{
char question[30],question1[10];
 if(dpdt*key!=0)fenetre(10,2,14,79,"REPRISE EN APPUYANT SUR RETURN",1);
 key=1;
 aff(key);
 kbb();
 if(enregistre==0){razdelta();}
 while(!kbhit()){aft();}
    switch(maj(getch()))
   {
      case 'W' :                                    // HELP
	 disableRS();clrscr();
	 cprintf("\r\n   PATIENTEZ !     ");
	 system("type c:\\CWMSTXRX\\CWMSTXRX.HLP|more");
	 cprintf("\r\nFIN : APPUYER SUR UNE TOUCHE POUR CONTINUER");
	 getch();kbb();key=2;affcadre();
	 break;
      case 'S' :                                   // DATABASE VHF
	 disableRS();clrscr();
	 cprintf("\r\nINDICATIF ou LOCATOR (complet ou fraction) =");
	 kbb();
	 strcpy(question,"grep -r ");
	 gets(question1);
	 strcat(question,question1);
	 strcat(question," c:\\CWMSTXRX\\CWMSTXRX.DTB");
	 cprintf("\r\n\r\n");
	 system(question);
	 cprintf("\r\n\r\nFIN : APPUYER SUR UNE TOUCHE POUR CONTINUER");
	 getch();
	 kbb();
	 key=2;
	 affcadre();
	 break;
      case 'Y' :                                   // COMMANDE DOS
	 disableRS();clrscr();
	 cprintf("COMMANDE DOS =");kbb();
	 gets(question);
	 cprintf("");
	 system(question);
	 cprintf("\r\nFIN : APPUYER SUR UNE TOUCHE POUR CONTINUER");
	 getch();
	 kbb();
	 key=2;
	 affcadre();
	 break;
      case 'O' :                                   // Freq RX down
	 dee--;
	 if(dee>1000){dee=1;};
	 kbb();
	 break;
      case 'U' :                                  // Freq RX up
	 dee++;
	 kbb();
	 break;
      case 'L' :                                  // Lissage
	 lissage();lecture();kbb();break;
      case '1' :                                  // enregistre
	 key=1;
	 razdelta();
	 break;
      case '&' :                                  // ecoute, arret enregistrement
	 key=1;
	 if(enregistre==0)
	 {
	    enregistre=1;
	    disableRS();
	    gettime(&stop);
	 }
	 fenetre(11,22,13,59,"Patientez : Filtrage en cours",1);
	 decode();
	 kbb();
	 break;
      case 'I' :                                       // MESSAGE AVEC PERIODE ET DEBUT
	 disableRS();
	 if(perio==0)
	 {
	    periode();
	 };
	 hdb();
	 zz();
	 ms("MESSAGE MS AVEC PERIODE =");
	 key=0;
	 dpdt=1;
	 repet=1;
	 pause=0;
	 pt=fact/8;
	 break;
      case 'C' :                                      // ARRET LECTURE BF
	 enregistre=1;
	 disableRS();
	 key=0;
         break;
      case 'T' :                                      // APPEL CONTEST
         disableRS();
         strcpy(string,"TEST ");
         strcat(string,indicatif);
         strcat(string," ");
         strcat(string,indicatif);
         strcat(string," TEST K");
         strcat(string,'\0');
         key=0;
         perio=0;
         dpdt=1;
         repet=1;
         pt=fact;
         pause=3;
         break;
      case 'A' :                                         // APPEL AURORE
	 disableRS();
	 strcpy(string,"CQA CQA ");
	 strcat(string,indicatif);
	 strcat(string," ");
	 strcat(string,indicatif);
	 strcat(string," CQA CQA ");
	 strcat(string,indicatif);
	 strcat(string," ");
	 strcat(string,indicatif);
	 strcat(string," +A K");
	 strcat(string,'\0');
	 key=0;
	 perio=0;
	 dpdt=1;
	 repet=1;
	 pt=fact;
	 pause=5;
	 break;
      case 'E' :                                     // APPEL Es
         disableRS();
         strcpy(string,"CQES ");
         strcat(string,indicatif);
         strcat(string," ");
         strcat(string,indicatif);
         strcat(string," ES K");
         strcat(string,'\0');
         key=0;
         perio=0;
         dpdt=1;
         repet=1;
         pause=5;
         pt=fact;
         break;
      case 'D' :                                        // APPEL DX
         disableRS();
         strcpy(string,"CQ DX ");
         strcat(string,indicatif);
         strcat(string," ");
         strcat(string,indicatif);
         strcat(string," CQ DX ");
         strcat(string,indicatif);
         strcat(string," ");
         strcat(string,indicatif);
         strcat(string," +DX K");
         strcat(string,'\0');
         key=0;
         perio=0;
         dpdt=1;
         repet=1;
         pause=10;
         pt=fact;
         break;
      case 'X' :                                         // MESSAGE N1 AVEC REPETITION
	 disableRS();
	 strcpy(string,message1);
	 key=0;
	 perio=0;
	 dpdt=1;
	 repet=1;
	 pause=10;
	 pt=fact;
	 break;
      case 'F' :                                              // MESSAGE SANS REPETITION
	 disableRS();
	 ms("MESSAGE NORMAL SANS REPETITION =");
	 key=0;
	 perio=0;
	 dpdt=1;
	 repet=0;
	 pause=0;
	 pt=fact;
	 break;
      case 'G' :                                             // MESSAGE EN BOUCLE
	 disableRS();
	 ms("MESSAGE NORMAL AVEC REPETITION SANS PAUSE =");
	 key=0;
	 perio=0;
	 dpdt=1;
	 repet=1;
	 pause=0;
	 pt=fact;
	 break;
      case 'H' :                                         // MESSAGE MS 1200 lpm
	 disableRS();
	 ms("MESSAGE MS=");
	 key=0;
	 dpdt=1;
	 repet=1;
	 pause=0;
	 pt=fact/8;
	 break;
      case 'B' :                                        // BALISE
         disableRS();
         strcpy(string,indicatif);
         strcat(string," BEACON ");
         strcat(string,indicatif);
         strcat(string," BEACON IN ");
         strcat(string,locator);
         strcat(string," EEEEEEEEE");
         strcat(string,'\0');
         key=0;
         perio=0;
         dpdt=1;
         repet=1;
         pt=fact;
         pause=0;
         break;
      case 'M' :                                       // CQMS
         disableRS();
         strcpy(string,"CQ");
         strcat(string,indicatif);
         strcat(string,"CQ");
         strcat(string,indicatif);
         strcat(string,'\0');
         key=0;
         hdebu=perio=0;
         dpdt=1;
         repet=1;
         pause=0;
         pt=fact/8;
         break;
      case 'Z' :                                      // RAZ PARAMETRES ET AFFICHAGE
	 disableRS();
	 key=2;
	 strcpy(string,"");
	 hdebu=perio=0;
	 dpdt=0;
	 repet=0;
	 pause=0;
	 pt=0;
	 affcadre();
	 break;
      case 'Q' :                                      // QUITTER
         debutQ:
         question[1]=0;
	 fenetre(11,22,13,59," Quitter CWMSTXRX  O/N ?",1);
	 question[1]=maj(getch());
	 if(question[1]=='N') break;
	 if(question[1]!='O') goto debutQ;
	 disableRS();
//         outportb(RS_CMDE_MDM, 0x08);           // arret keyer
         outportb(0x061,inportb(0x061)&0x0FE);   // Inhibe sortie timer vers HP
         window(1,1,80,25);
         clrscr();
         exit(0);
      case '+' :                                     // AUGMENTE VITESSE TX
	 pt=pt-pt/10;
	 break;
      case '-' :				     // DIMINUE VITESSE TX
	 pt=pt+pt/10;
	 break;
      case 'R' :                                     // START/STOP REPETITION
	 if(repet==1)
	 {
	    repet=0;
	 }
	 else
	 {
	    repet=1;
	 };
	 break;
      case 'P' :                                       // MESSAGE MS AVEC PERIODE
	 periode();
	 if(hdebu==0)
	 {
	    hdb();
	    zz();
	 }
	 ms("MESSAGE MS AVEC PERIODE =");
	 key=0;
	 dpdt=1;
	 repet=1;
	 pause=0;
	 pt=fact/8;
	 break;
      default :
         key=0;
         break;
      }
conversion();
fenetre(10,2,14,79,"",0);
aff(key);
}

void disableRS (void)
{
            disable();
#if ALIM18HZ
	    setvect(0x1C, sVec1C);                 // vecteur it horloge
#endif
	    outportb(RS_VAL_INT, 0);                // invalid int uart
	    outportb(B8259, inportb(B8259) | (1 << RS_IRQ));
	    setvect(RS_IRQ + 8, sVecRS);           // vecteur it uart
	    enable();
	    outportb(RS_CMDE_MDM, 0x08);           // arret alim interface
enregistre=1;  ///
}


char maj (char s)
{
if(s>96&&s<123){s=s-32;}
return(s);
}


void conversion (void)
{
unsigned long int i,l,j;
const char AA[50][10]=
{{'A','1','2',0,0,0,0,0,0,0},
 {'B','2','1','1','1',0,0,0,0,0},
 {'C','2','1','2','1',0,0,0,0,0},
 {'D','2','1','1',0,0,0,0,0,0},
 {'E','1',0,0,0,0,0,0,0,0},
 {'F','1','1','2','1',0,0,0,0,0},
 {'G','2','2','1',0,0,0,0,0,0},
 {'H','1','1','1','1',0,0,0,0,0},
 {'I','1','1',0,0,0,0,0,0,0},
 {'J','1','2','2','2',0,0,0,0,0},
 {'K','2','1','2',0,0,0,0,0,0},
 {'L','1','2','1','1',0,0,0,0,0},
 {'M','2','2',0,0,0,0,0,0,0},
 {'N','2','1',0,0,0,0,0,0,0},
 {'O','2','2','2',0,0,0,0,0,0},
 {'P','1','2','2','1',0,0,0,0,0},
 {'Q','2','2','1','2',0,0,0,0,0},
 {'R','1','2','1',0,0,0,0,0,0},
 {'S','1','1','1',0,0,0,0,0,0},
 {'T','2',0,0,0,0,0,0,0,0},
 {'U','1','1','2',0,0,0,0,0,0},
 {'V','1','1','1','2',0,0,0,0,0},
 {'W','1','2','2',0,0,0,0,0,0},
 {'X','2','1','1','2',0,0,0,0,0},
 {'Y','2','1','2','2',0,0,0,0,0},
 {'Z','2','2','1','1',0,0,0,0,0},
 {'1','1','2','2','2','2',0,0,0,0},
 {'2','1','1','2','2','2',0,0,0,0},
 {'3','1','1','1','2','2',0,0,0,0},
 {'4','1','1','1','1','2',0,0,0,0},
 {'5','1','1','1','1','1',0,0,0,0},
 {'6','2','1','1','1','1',0,0,0,0},
 {'7','2','2','1','1','1',0,0,0,0},
 {'8','2','2','2','1','1',0,0,0,0},
 {'9','2','2','2','2','1',0,0,0,0},
 {'0','2','2','2','2','2',0,0,0,0},
 {'.','1','2','1','2','1','2',0,0,0},   //  point
 {',','2','2','1','1','2','2',0,0,0},   //  virgule
 {'?','1','1','2','2','1','1',0,0,0},   //  point d"interrogation
 {'-','2','1','1','1','1','2',0,0,0},   //  tiret
 {'=','2','1','1','1','2',0,0,0,0},     //  gal
 {':','2','2','2','1','1','1',0,0,0},   //  deux points
 {'+','1','2','1','2','1',0,0,0,0},     //  plus
 {';','2','1','2','1','2','1',0,0,0},   //  point virgule
 {')','2','1','2','2','1',0,0,0,0},     //  ouvrer parenthse
 {'/','2','1','1','2','1',0,0,0,0},     //  fraction
 {'"','1','2','1','1','2','1',0,0,0},   //  guillemet
 {'$','1','1','1','2','1','1','2',0,0}, //  signe dollar
 {'_','1','1','2','2','1','2',0,0,0},   //  soulign
 {'','1','1','2','1','1',0,0,0,0},     //  
};
 for(l=0;string[l]!=0;l++)
   {
   string[l]=maj(string[l]);
   }

for(l=0,i=0;string[i]!=0;i++)
   {
   strang[l]=' ';l++;
   switch(string[i])
      {
      case 'A' : for (j=1;AA[0][j]!=0;j++,l++)strang[l]=AA[0][j];break;
      case 'B' : for (j=1;AA[1][j]!=0;j++,l++)strang[l]=AA[1][j];break;
      case 'C' : for (j=1;AA[2][j]!=0;j++,l++)strang[l]=AA[2][j];break;
      case 'D' : for (j=1;AA[3][j]!=0;j++,l++)strang[l]=AA[3][j];break;
      case 'E' : for (j=1;AA[4][j]!=0;j++,l++)strang[l]=AA[4][j];break;
      case 'F' : for (j=1;AA[5][j]!=0;j++,l++)strang[l]=AA[5][j];break;
      case 'G' : for (j=1;AA[6][j]!=0;j++,l++)strang[l]=AA[6][j];break;
      case 'H' : for (j=1;AA[7][j]!=0;j++,l++)strang[l]=AA[7][j];break;
      case 'I' : for (j=1;AA[8][j]!=0;j++,l++)strang[l]=AA[8][j];break;
      case 'J' : for (j=1;AA[9][j]!=0;j++,l++)strang[l]=AA[9][j];break;
      case 'K' : for (j=1;AA[10][j]!=0;j++,l++)strang[l]=AA[10][j];break;
      case 'L' : for (j=1;AA[11][j]!=0;j++,l++)strang[l]=AA[11][j];break;
      case 'M' : for (j=1;AA[12][j]!=0;j++,l++)strang[l]=AA[12][j];break;
      case 'N' : for (j=1;AA[13][j]!=0;j++,l++)strang[l]=AA[13][j];break;
      case 'O' : for (j=1;AA[14][j]!=0;j++,l++)strang[l]=AA[14][j];break;
      case 'P' : for (j=1;AA[15][j]!=0;j++,l++)strang[l]=AA[15][j];break;
      case 'Q' : for (j=1;AA[16][j]!=0;j++,l++)strang[l]=AA[16][j];break;
      case 'R' : for (j=1;AA[17][j]!=0;j++,l++)strang[l]=AA[17][j];break;
      case 'S' : for (j=1;AA[18][j]!=0;j++,l++)strang[l]=AA[18][j];break;
      case 'T' : for (j=1;AA[19][j]!=0;j++,l++)strang[l]=AA[19][j];break;
      case 'U' : for (j=1;AA[20][j]!=0;j++,l++)strang[l]=AA[20][j];break;
      case 'V' : for (j=1;AA[21][j]!=0;j++,l++)strang[l]=AA[21][j];break;
      case 'W' : for (j=1;AA[22][j]!=0;j++,l++)strang[l]=AA[22][j];break;
      case 'X' : for (j=1;AA[23][j]!=0;j++,l++)strang[l]=AA[23][j];break;
      case 'Y' : for (j=1;AA[24][j]!=0;j++,l++)strang[l]=AA[24][j];break;
      case 'Z' : for (j=1;AA[25][j]!=0;j++,l++)strang[l]=AA[25][j];break;
      case '1' : for (j=1;AA[26][j]!=0;j++,l++)strang[l]=AA[26][j];break;
      case '2' : for (j=1;AA[27][j]!=0;j++,l++)strang[l]=AA[27][j];break;
      case '3' : for (j=1;AA[28][j]!=0;j++,l++)strang[l]=AA[28][j];break;
      case '4' : for (j=1;AA[29][j]!=0;j++,l++)strang[l]=AA[29][j];break;
      case '5' : for (j=1;AA[30][j]!=0;j++,l++)strang[l]=AA[30][j];break;
      case '6' : for (j=1;AA[31][j]!=0;j++,l++)strang[l]=AA[31][j];break;
      case '7' : for (j=1;AA[32][j]!=0;j++,l++)strang[l]=AA[32][j];break;
      case '8' : for (j=1;AA[33][j]!=0;j++,l++)strang[l]=AA[33][j];break;
      case '9' : for (j=1;AA[34][j]!=0;j++,l++)strang[l]=AA[34][j];break;
      case '0' : for (j=1;AA[35][j]!=0;j++,l++)strang[l]=AA[35][j];break;
      case ' ' : strang[l]=' ';l++;break;
      case '.' : for (j=1;AA[36][j]!=0;j++,l++)strang[l]=AA[36][j];break;
      case ',' : for (j=1;AA[37][j]!=0;j++,l++)strang[l]=AA[37][j];break;
      case '?' : for (j=1;AA[38][j]!=0;j++,l++)strang[l]=AA[38][j];break;
      case '-' : for (j=1;AA[39][j]!=0;j++,l++)strang[l]=AA[39][j];break;
      case '=' : for (j=1;AA[40][j]!=0;j++,l++)strang[l]=AA[40][j];break;
      case ':' : for (j=1;AA[41][j]!=0;j++,l++)strang[l]=AA[41][j];break;
      case '+' : for (j=1;AA[42][j]!=0;j++,l++)strang[l]=AA[42][j];break;
      case ';' : for (j=1;AA[43][j]!=0;j++,l++)strang[l]=AA[43][j];break;
      case ')' : for (j=1;AA[44][j]!=0;j++,l++)strang[l]=AA[44][j];break;
      case '/' : for (j=1;AA[45][j]!=0;j++,l++)strang[l]=AA[45][j];break;
      case '"' : for (j=1;AA[46][j]!=0;j++,l++)strang[l]=AA[46][j];break;
      case '$' : for (j=1;AA[47][j]!=0;j++,l++)strang[l]=AA[47][j];break;
      case '_' : for (j=1;AA[48][j]!=0;j++,l++)strang[l]=AA[48][j];break;
      case '' : for (j=1;AA[49][j]!=0;j++,l++)strang[l]=AA[49][j];break;
      default : strang[l]=' ';l++;cprintf("\r\nanomalie dans la donne a emettre = %c     ",string[i]);break;
      }
   }
 strang[l]=' ';l++;
 strang[l]=0;l++;
}

void emission (void)
{
if(key==0)
{
if(perio*hdebu!=0)
{
testfin();
   if(dpdt==1)
      {
      aft();
      txx();
      }else
       {
         while(dpdt==0)
         {
          testfin();
          aft();
          if(kbhit()!=0){
               key=1;kbb();
               break;
               }
         }
       }
}else
   {
   if (dpdt==1)
    {
    aft();
    txx();
    }else{aft();if(kbhit()!=0){key=1;kbb();}
}
   }
}
}
void kbb(void)
{
while(kbhit()!=0)
   {
   getch();
   }
}

void txx(void)
{
unsigned long int m;
for(m=0;strang[m]!=0;m++)
   {
if(peek(0x0040,0x0001C)!=peek(0x0040,0x001A)) {
                  while(strang[m]!=0)m++;
                  m--;
                  key=1;
                  kbb();
                  }
   blanc();
      switch (strang[m])
         {
         case '1' : point();break;
         case '2' : trait();break;
         case ' ' : blanc();blanc();break;
         default : blanc();break;
         }
   }
}

void calcul(void)
{
unsigned long int j;
union REGS Register;
Register.h.ah=0x2;
int86(0x1A,&Register,&Register);
j=Register.h.dh;
while(j==Register.h.dh)
   {
   Register.h.ah=0x2;
   int86(0x1A,&Register,&Register);
   }
for(j=Register.h.dh,fact=0;j==Register.h.dh;fact++)
   {
   Register.h.ah=0x2;
   int86(0x1A,&Register,&Register);
      }
fact=fact*1.5;

}

void PR(int colonne,int ligne, char *string)
{
gotoxy(colonne,ligne);
cprintf("%s",string);
}

void ligne(int lig)
{
unsigned int i;
PR(1,lig,"");
for(i=2;i<80;i++){PR(i,lig,"");}
PR(80,lig,"");
}

void fenetre(int ligne1, int colonne1, int ligne2, int colonne2, char *string, int l)
{
if(l!=0)
{
cadre(ligne1,colonne1,ligne2,colonne2);
window(colonne1+1,ligne1+1,colonne2-1,ligne2-1);
   textcolor(WHITE);
   textbackground(BLACK);
clrscr();
cprintf("%s",string);
   textcolor(YELLOW);
   textbackground(BLUE);
}else{
   window(colonne1,ligne1,colonne2,ligne2);
   clrscr();
   }
window(1,1,80,25);
}

void cadre(int ligne1, int colonne1, int ligne2, int colonne2)
{
unsigned int i;
PR(colonne1,ligne1,"");
for(i=colonne1+1;i<colonne2;i++){PR(i,ligne1,"");}
PR(colonne2,ligne1,"");
for(i=ligne1+1;i<ligne2;i++){PR(colonne1,i,"");}
PR(colonne2,ligne2,"");
for(i=colonne1+1;i<colonne2;i++){PR(i,ligne2,"");}
PR(colonne1,ligne2,"");
for(i=ligne1+1;i<ligne2;i++){PR(colonne2,i,"");}
}


void aftime(void)
{
window(1,1,80,25);
gotoxy(2,4);
getdate(&auj);
cprintf(" Date=%02d/%02d/%02d",auj.da_day,auj.da_mon,auj.da_year);
gettime(&maint);
cprintf(" *** Heure=%02d:%02d:%02d",maint.ti_hour,maint.ti_min,maint.ti_sec);
cprintf("     H Dpart=%02d:%02d:%02d",dep.ti_hour,dep.ti_min,dep.ti_sec);
cprintf(" *** H Stop=%02d:%02d:%02d ",fff.ti_hour,fff.ti_min,fff.ti_sec);
window(1,1,80,25);
}

void affcadre(void)
{
 window(1,1,80,25);
 clrscr();
 cadre(1,1,24,80);
 PR(2,2," CW MS TX & RX  V3.1, 31-1-96, CWMSTXRX Copyright 1980-96 F6FLV");
 ligne(3);
 ligne(5);
 ligne(9);
 cadre(15,1,24,80);
}

void aff (int key)
{
 aftime();
 afmsg();
 affact();
 lecture();
 afm(key);
}


void affact (void)
{
 window(2,6,79,6);
 clrscr();
 cprintf(" fact=%06d ",fact);
 cprintf("per=%01d ",perio);
 cprintf("db=%01d ",hdebu);
 cprintf("repet=%01d ",repet);
 cprintf("pause=%01d ",pause);
 cprintf("pt=%06d ",pt);
 cprintf("dpt=%01d ",dpdt);
 cprintf("e=%1c ",e);
 cprintf("erg=%01u ",enregistre);
 cprintf("LgMsg=%03d",strlen(string));
 window(1,1,80,25);
}

void aft(void)
{
 window(29,4,40,4);
 gettime(&maint);
 cprintf("%02d:%02d:%02d:%02d",maint.ti_hour,maint.ti_min,maint.ti_sec,maint.ti_hund);
 window(58,8,65,8);
 cprintf("%05u",delta_ecr);///zzz
 window(68,8,75,8);
 cprintf("%04u",delta_t[delta_ecr]);
 window(34,8,39,8);
 cprintf("%03u",mx);
 window(1,1,80,25);
}

void afmsg(void)
{
 window(2,7,79,7);
 clrscr();
 cprintf(" MSG=%-s",string);
 window(1,1,80,25);
}

void afm(int l)
{
 window(2,16,79,23);
 if(l==1)
 {
 clrscr();
 PR(1,1,"  &) Lect Mm BF");
 PR(25,1,"1) Enreg Mm BF");
 PR(50,1,"C) Arret BF");
 PR(1,2,"  Z) RAZ paramtres");
 PR(25,2,"I) Heure Dbut TX");
 PR(50,2,"P) Priode TX");
 PR(1,3,"  M) MS CQ  1200lpm");
 PR(25,3,"H) Msg MS  1200lpm");
 PR(50,3,"R) Rptition");
 PR(1,4,"  U/O) Fq RX Up/dOwn");
 PR(25,4,"W) AIDE");
 PR(50,4,"S) DATABASE VHF");
 PR(1,5,"  Q) Quitter");
 PR(25,5,"L) Lissage RX");
 PR(50,5,"B) Beacon  vt norm");
 PR(1,6,"  Y) COMMANDE DOS");
 PR(25,6,"A) CQ A    vt norm");
 PR(50,6,"E) CQ ES   vt norm");
 PR(1,7,"  D) CQ DX  vt norm");
 PR(25,7,"X) MSG N1 vt norm");
 PR(50,7,"T) CQ TEST vt norm");
 PR(1,8,"  F) Msg vt norm * 1");
 PR(25,8,"G) Msg vt norm + rep.");
 PR(50,8,"+/-) Vitesse TX      ");
 }else {
    textcolor(BLACK);
    textbackground(WHITE);
    clrscr();
    PR(1,1,"  ARRETER EN APPUYANT SUR UNE TOUCHE");
    textcolor(YELLOW);
    textbackground(BLUE);
    }
 window(1,1,80,25);
}


void lissage (void)
{
unsigned int l;
 for (l=0;l<ee;l++)
 {
 delta_t[l]=(delta_t[l]+delta_t[l+1])/2;
 }
 for (min=delta_t[0],moy=max=l=0;l<ee;l++)
 {
 if(delta_t[l]>max){max=delta_t[l];}
 if(delta_t[l]<min){min=delta_t[l];}
 moy=moy+delta_t[l];
 }
 if(ee==0)ee=1;
 moy=moy/ee;
 lisse++;
}

void lecture (void)
{
 window(2,8,79,8);
 cprintf(" min=%04u",min);
 cprintf(" moy=%04u",moy);
 cprintf(" max=%05u",max);
 cprintf(" mx=%03u",mx);
 cprintf(" lisse=%02u",lisse);
 cprintf(" dee=%03u",dee);
 //cprintf(" dec=%03u",dec);
 cprintf(" nb=%05u ct=%04u",delta_ecr,delta_t[delta_ecr]);
 window(1,1,80,25);
}

void decode(void)
{
unsigned long int l,m,dcc;
 if (dee==0)dee=5;// Frequence coute.5=grave
 if(mx>0){ee=DELTA_MAX;delta_t[DELTA_MAX]=1;}else{ee=delta_ecr;}
 if(ee>10)
 {
 if(lisse==0)
   {
    // TRONQUAGE DES VALEURS TROP GRANDES
    for (l=0;l<=ee;l++)
    {
    if(delta_t[l]>2000) {delta_t[l]=1999;}
    }

    lissage();
///    lissage();
//    lissage();
    traite();

/* CALCUL DES MIN MOY & MAX
    for (min=delta_t[0],moy=max=l=0;l<ee;l++)
    {
    if(delta_t[l]>max){max=delta_t[l];}
    if(delta_t[l]<min){min=delta_t[l];}
    somme=somme+delta_t[l];
    }
    moy=somme/ee;
*/
   }
 lecture();
 fenetre(10,2,14,79,"Dplacement dans le buffer par SHIFT_DROIT (avancer) SHIFT_GAUCHE (reculer)        TERMINER LECTURE EN APPUYANT SUR UNE TOUCHE",1);
 affbuf(1);
 window(1,25,80,25);

 for (l=0;l<ee;l++)
  {
    gotoxy(20+60*l/ee,1);
    putch('');
    if(peek(0x0040,0x001C)!=peek(0x0040,0x001A)) // SAISIE D'UNE TOUCHE
       {
       kbb();
       delta_t[ee]=1; ///
       l=ee;
       }
    if(peekb(0x0040,0x0017)&0x02) // SHIFT GAUCHE
       {
    pokeb(0x0040,0x0017,peekb(0x0040,0x0017)^0x02); // RAZ SHIFT GAUCHE
       if(l>ee/20)l=l-ee/20; else if(l>ee/40)l=l-ee/40;else{l=0;}
       affbuf(l);
       }
    if(peekb(0x0040,0x0017)&0x01) // SHIFT DROIT
       {
    pokeb(0x0040,0x0017,peekb(0x0040,0x0017)^0x01); // RAZ SHIFT DROIT
       l=l+ee/20;
       affbuf(l);
       }//MARCHE
    for (dcc=0;dcc<dee;dcc++)
     {
       for  (m=delta_t[l];m!=0;m--)
        {
       outportb(0x061,inportb(0x061));
	}
       outportb(0x061,inportb(0x061)^0x02);
     }
 }
}
 fenetre(10,2,14,79,"",0);
 affbuf(0);
 window(1,1,80,25);
}

void traite (void)
{
unsigned long int l, memo=0;
float zz;
 zz=pow((float)fact/1635,1.4)/15;

// RECHERCHE D'UN SIGNAL SINUSOIDAL
   for (l=1;l<ee;l++)
   {
   if((float)delta_t[l]/((float)delta_t[l+1]+1)>1.1){memo=memo+delta_t[l];delta_t[l]=0;}
   if((float)delta_t[l]/((float)delta_t[l+1]+1)<0.9){memo=memo+delta_t[l];delta_t[l]=0;}
   else
       { if(memo!=0){
		    delta_t[l-1]=memo;
		    memo=0;
		    }
       }
   }

   for (l=0;l<ee;l++)
   {
//   printf("%05u   ",delta_t[l]);
     delta_t[l]=(float)delta_t[l]*zz;
//   printf("%05u   ",delta_t[l]);
   }

/// TEMPS ECOULE =
 l=(stop.ti_sec-start.ti_sec)+(stop.ti_min-start.ti_min)*60+(stop.ti_hour-start.ti_hour)*60*60;
 if (l==0) {cprintf("\n00000000000000000000000");l=1;}// prcaution
 window(3,11,78,13);
 cprintf("\nTaille buffer =%06u secondes",l);
 if(mx==0) cprintf("  Frequence moyenne =%06f Fronts/s",(float)ee/(float)l);
 else  cprintf("  Frequence moyenne =%06f Fronts/s",(float)ee/(float)l*mx);
 window(1,1,80,25);
}



void affbuf(unsigned int l)
{
 window(1,25,80,25);
 clrscr();
 if(l!=0)
 {
 cprintf("nbt=%u cour=%u",ee,l);
 PR(20+(unsigned int)((float)60*(float)l/(float)ee),1,"");
 }
 }


void razdelta(void)
{
 for (delta_ecr = 0; delta_ecr < DELTA_MAX; delta_ecr++)
 {
 delta_t[delta_ecr] = 0;
 }
 lisse=0;
 delta_ecr=0;
 mx=0;
// enregistre=0;///
 enableRS();
 gettime(&start);
}

void enableRS(void)
{
   /* position vecteurs it + valid it uart */
   /* ------------------------------------ */
   disable();
   signal(SIGINT, SIG_IGN);
#if ALIM18HZ
   setvect(0x1C, int1c);
#endif
   setvect(RS_IRQ + 8, itRS);
   outportb(RS_CMDE_L,0x83);                       // DLAB=1
   inportb(RS_ETAT_MDM);                           // raz flags uart
   outportb(RS_CMDE_L, 0);                         // position dlab
   outportb(RS_VAL_INT, 0x08);                     // valid int uart ...
   outportb(RS_CMDE_MDM, 0x0A);                    // 0x0A en principe ...
   outportb(B8259, inportb(B8259) & (~(1 << RS_IRQ)));
   outportb(RS_PORT, 0);
   enable();
 enregistre=0; ///
}
