#!/bin/sh
#
# Install file to XFBB software
#
# F6FBB 1996
#

XINST=$0
export XINST

change()
{
  echo "$1 : updating '$2' with '$3'"
  grep $2 $1 2>&1 > /dev/null
  ret=$?
  if [ $ret != 0 ]
  then
    echo "keyword $2 not found in $1 !"
  else
    cat $1 | sed "s;$2;$3;" > tmp.$$
    cp tmp.$$ $1
  fi
}

#
# Base directory of XFBB software
echo -n "Enter base directory to install the software : "
read base

if [ -d $base ]
then
  echo "The base directory $base already exists."
  echo "The previous files will be destroyed."
  while [ 1 ]
  do
    echo -n "Are you sure (Y/N) "
    read rep
    if [ "_$rep" = "_Y" -o "_$rep" = "_y" -o "_$rep" = "_N" -o "_$rep" = "_n" ]
    then
      break
    fi    
  done
  if [ "_$rep" = "_N" -o "_$rep" = "_n" ]
  then
    exit 0
  fi
fi

XFBBDIR=$base

if [ ! -d $XFBBDIR ]
then
  mkdir $XFBBDIR
  if [ $? != 0 ]
  then
    exit 1
  fi
fi

echo "Installing XFBB software in $XFBBDIR"
echo
echo "Please use capital letters when needed (see examples)."
echo

while [ 1 ]
do
  
  echo -n "Enter callsign of the BBS WITHOUT SSID (Ex : F6FBB)    :"
  read callsign
  
  echo -n "Enter SSID of the BBS (Ex : 1)                         :"
  read ssid
  
  echo -n "Enter hierarchical route of the BBS (Ex : FMLR.FRA.EU) :"
  read hierarchy
  
  echo -n "Enter QTH-LOCATOR of the BBS (Ex : JN03QL)             :"
  read qthloc
  
  echo -n "Enter the CITY of the BBS (Ex : Toulouse)              :"
  read city
  
  echo -n "Enter ZIP-CODE of the area of the BBS (Ex : 31120)     :"
  read zipcode
  
  echo -n "Enter your first name (Ex : Jean-Paul)                 :"
  read sysname
  
  echo -n "Enter your own Callsign (Ex : F6FBB)                   :"
  read syscall
  
  echo -n "Enter your offset in hours from GMT (Ex : France = -2) :"
  read gmtoffset

  echo
  echo
  echo "Callsign of the BBS    : $callsign.$hierarchy"
  echo "SSID of the BBS        : $ssid"
  echo "QTH-LOCATOR of the BBS : $qthloc"
  echo "CITY of the BBS        : $city"
  echo "ZIP-CODE of the area   : $zipcode"
  echo "Your first name        : $sysname"
  echo "Your own Callsign      : $syscall"
  echo "Offset from GMT        : $gmtoffset"
  echo
  
  while [ 1 ]
  do
    echo -n "Is it OK (Y/N) "
    read rep
    if [ "_$rep" = "_Y" -o "_$rep" = "_y" -o "_$rep" = "_N" -o "_$rep" = "_n" ]
    then
      break
    fi    
  done
  if [ "_$rep" = "_Y" -o "_$rep" = "_y" ]
  then
    break
  fi

done

change $base/xfbb.sh __BASEDIR__   "$XFBBDIR"

echo "Updating the file $base/init.srv"
change $base/init.srv __BASEDIR__   "$XFBBDIR"
change $base/init.srv __CALLSIGN__  "$callsign.$hierarchy"
change $base/init.srv __SSID__      "$ssid"
change $base/init.srv __QTHLOC__    "$qthloc"
change $base/init.srv __CITY__      "$city"
change $base/init.srv __SYSNAME__   "$sysname"
change $base/init.srv __SYSCALL__   "$syscall"
change $base/init.srv __GMTOFFSET__ "$gmtoffset"
change $base/init.srv __ZIPCODE__   "$zipcode"

echo "Updating the file $base/epurmess.ini"
change $base/epurmess.ini __BASEDIR__   "$XFBBDIR"

rm tmp.$$

echo
echo "Installation of XFBB was successfull"
echo
exit 0

end

