
/*  A Bison parser, made from /home/ezk/proj/amd/am-utils-exp/A.i386-pc-solaris2.8/amd/../../amd/sun_map_parse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NEWLINE	257
#define	COMMENT	258
#define	WSPACE	259
#define	WORD	260

#line 1 "sun_map_parse.y"

/*
 * Copyright (c) 1997-2005 Erez Zadok
 * Copyright (c) 2005 Daniel P. Ottavio
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/sun_map_parse.y
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>
#include <sun_map.h>


#define SUN_FSTYPE_STR  "fstype="


extern int sun_map_lex(void);
extern int sun_map_error(const char *);
extern void sun_map_tok_setbuff(const char *);
extern int sun_map_parse(void);

struct sun_entry *sun_map_parse_read(const char *);

static struct sun_list *sun_entry_list = NULL;
static struct sun_list *sun_opt_list = NULL;
static struct sun_list *sun_host_list = NULL;
static struct sun_list *sun_location_list = NULL;
static struct sun_list *mountpt_list = NULL;
static char *tmpFsType = NULL;


/*
 * Each get* function returns a pointer to the corresponding global
 * list structure.  If the structure is NULL than a new instance is
 * returned.
 */
static struct sun_list *get_sun_opt_list();
static struct sun_list *get_sun_host_list();
static struct sun_list *get_sun_location_list();
static struct sun_list *get_mountpt_list();
static struct sun_list *get_sun_entry_list();


#line 85 "sun_map_parse.y"
typedef union {
  char strval[2048];
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		50
#define	YYFLAG		-32768
#define	YYNTBASE	12

#define YYTRANSLATE(x) ((unsigned)(x) <= 260 ? sun_map_translate[x] : 26)

static const char sun_map_translate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    10,
    11,     2,     2,     9,     7,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     8,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6
};

#if YYDEBUG != 0
static const short sun_map_prhs[] = {     0,
     0,     2,     5,     7,     9,    12,    16,    18,    21,    23,
    28,    30,    35,    37,    41,    45,    52,    54,    58,    62,
    65,    67,    71,    73,    76,    80,    82,    86
};

static const short sun_map_rhs[] = {    13,
     0,    15,    14,     0,    14,     0,    16,     0,    16,    15,
     0,    16,    15,    14,     0,     3,     0,     3,    15,     0,
    19,     0,     7,    24,     5,    19,     0,    17,     0,     7,
    24,     5,    17,     0,    18,     0,    18,     5,    17,     0,
     6,     5,    20,     0,     6,     5,     7,    24,     5,    20,
     0,    20,     0,    20,     5,    19,     0,    21,     8,     6,
     0,     8,     6,     0,    22,     0,    22,     9,    21,     0,
     6,     0,     6,    23,     0,    10,     6,    11,     0,    25,
     0,    25,     9,    24,     0,     6,     0
};

#endif

#if YYDEBUG != 0
static const short sun_map_rline[] = { 0,
    94,    97,    98,   101,   102,   103,   106,   107,   110,   131,
   166,   187,   224,   225,   228,   251,   290,   291,   294,   317,
   331,   332,   335,   346,   359,   374,   375,   378
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const sun_map_tname[] = {   "$","error","$undefined.","NEWLINE",
"COMMENT","WSPACE","WORD","'-'","':'","','","'('","')'","amap","file","entries",
"new_lines","entry","mountpoints","mountpoint","locations","location","hosts",
"host","weight","options","option", NULL
};
#endif

static const short sun_map_r1[] = {     0,
    12,    13,    13,    14,    14,    14,    15,    15,    16,    16,
    16,    16,    17,    17,    18,    18,    19,    19,    20,    20,
    21,    21,    22,    22,    23,    24,    24,    25
};

static const short sun_map_r2[] = {     0,
     1,     2,     1,     1,     2,     3,     1,     2,     1,     4,
     1,     4,     1,     3,     3,     6,     1,     3,     3,     2,
     1,     3,     1,     2,     3,     1,     3,     1
};

static const short sun_map_defact[] = {     0,
     7,    23,     0,     0,     1,     3,     0,     4,    11,    13,
     9,    17,     0,    21,     8,     0,     0,    24,    28,     0,
    26,    20,     2,     5,     0,     0,     0,     0,    23,     0,
    15,     0,     0,     0,     6,     0,    14,    18,    19,    22,
     0,    25,    12,    10,    27,     0,    16,     0,     0,     0
};

static const short sun_map_defgoto[] = {    48,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    18,    20,    21
};

static const short sun_map_pact[] = {     0,
    12,     4,    10,    23,-32768,-32768,    13,    12,-32768,    26,
-32768,    27,    25,    28,-32768,    16,    29,-32768,-32768,    31,
    30,-32768,-32768,    13,    32,    19,    34,    35,    24,    10,
-32768,    33,    20,    10,-32768,    37,-32768,-32768,-32768,-32768,
    38,-32768,-32768,-32768,-32768,    19,-32768,    45,    46,-32768
};

static const short sun_map_pgoto[] = {-32768,
-32768,    -6,     3,-32768,   -23,-32768,   -21,   -16,    21,-32768,
-32768,   -17,-32768
};


#define	YYLAST		49


static const short sun_map_table[] = {    31,
    23,    37,     1,    15,    38,     2,     3,     4,    16,    43,
    24,    44,    41,    17,     1,    19,    45,    35,     2,     3,
     4,    29,    30,     4,    29,     2,     4,     4,    22,    47,
    25,    26,    27,    17,    32,    33,    28,    36,    34,    39,
    29,    16,    46,    42,    49,    50,     0,     0,    40
};

static const short sun_map_check[] = {    16,
     7,    25,     3,     1,    26,     6,     7,     8,     5,    33,
     8,    33,    30,    10,     3,     6,    34,    24,     6,     7,
     8,     6,     7,     8,     6,     6,     8,     8,     6,    46,
     5,     5,     8,    10,     6,     5,     9,     6,     9,     6,
     6,     5,     5,    11,     0,     0,    -1,    -1,    28
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define sun_map_errok		(sun_map_errstatus = 0)
#define sun_map_clearin	(sun_map_char = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto sun_map_acceptlab
#define YYABORT 	goto sun_map_abortlab
#define YYERROR		goto sun_map_errlab1
/* Like YYERROR except do call sun_map_error.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto sun_map_errlab
#define YYRECOVERING()  (!!sun_map_errstatus)
#define YYBACKUP(token, value) \
do								\
  if (sun_map_char == YYEMPTY && sun_map_len == 1)				\
    { sun_map_char = (token), sun_map_lval = (value);			\
      sun_map_char1 = YYTRANSLATE (sun_map_char);				\
      YYPOPSTACK;						\
      goto sun_map_backup;						\
    }								\
  else								\
    { sun_map_error ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		sun_map_lex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		sun_map_lex(&sun_map_lval, &sun_map_lloc, YYLEX_PARAM)
#else
#define YYLEX		sun_map_lex(&sun_map_lval, &sun_map_lloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		sun_map_lex(&sun_map_lval, YYLEX_PARAM)
#else
#define YYLEX		sun_map_lex(&sun_map_lval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	sun_map_char;			/*  the lookahead symbol		*/
YYSTYPE	sun_map_lval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE sun_map_lloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int sun_map_nerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int sun_map_debug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __sun_map__memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __sun_map__memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__sun_map__memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__sun_map__memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into sun_map_parse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int sun_map_parse (void *);
#else
int sun_map_parse (void);
#endif
#endif

int
sun_map_parse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int sun_map_state;
  register int sun_map_n;
  register short *sun_map_ssp;
  register YYSTYPE *sun_map_vsp;
  int sun_map_errstatus;	/*  number of tokens to shift before error messages enabled */
  int sun_map_char1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	sun_map_ssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE sun_map_vsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *sun_map_ss = sun_map_ssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *sun_map_vs = sun_map_vsa;	/*  to allow sun_map_overflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE sun_map_lsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *sun_map_ls = sun_map_lsa;
  YYLTYPE *sun_map_lsp;

#define YYPOPSTACK   (sun_map_vsp--, sun_map_ssp--, sun_map_lsp--)
#else
#define YYPOPSTACK   (sun_map_vsp--, sun_map_ssp--)
#endif

  int sun_map_stacksize = YYINITDEPTH;
  int sun_map_free_stacks = 0;

#ifdef YYPURE
  int sun_map_char;
  YYSTYPE sun_map_lval;
  int sun_map_nerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE sun_map_lloc;
#endif
#endif

  YYSTYPE sun_map_val;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int sun_map_len;

#if YYDEBUG != 0
  if (sun_map_debug)
    fprintf(stderr, "Starting parse\n");
#endif

  sun_map_state = 0;
  sun_map_errstatus = 0;
  sun_map_nerrs = 0;
  sun_map_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  sun_map_ssp = sun_map_ss - 1;
  sun_map_vsp = sun_map_vs;
#ifdef YYLSP_NEEDED
  sun_map_lsp = sun_map_ls;
#endif

/* Push a new state, which is found in  sun_map_state  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
sun_map_newstate:

  *++sun_map_ssp = sun_map_state;

  if (sun_map_ssp >= sun_map_ss + sun_map_stacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *sun_map_vs1 = sun_map_vs;
      short *sun_map_ss1 = sun_map_ss;
#ifdef YYLSP_NEEDED
      YYLTYPE *sun_map_ls1 = sun_map_ls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = sun_map_ssp - sun_map_ss + 1;

#ifdef sun_map_overflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if sun_map_overflow is a macro.  */
      sun_map_overflow("parser stack overflow",
		 &sun_map_ss1, size * sizeof (*sun_map_ssp),
		 &sun_map_vs1, size * sizeof (*sun_map_vsp),
		 &sun_map_ls1, size * sizeof (*sun_map_lsp),
		 &sun_map_stacksize);
#else
      sun_map_overflow("parser stack overflow",
		 &sun_map_ss1, size * sizeof (*sun_map_ssp),
		 &sun_map_vs1, size * sizeof (*sun_map_vsp),
		 &sun_map_stacksize);
#endif

      sun_map_ss = sun_map_ss1; sun_map_vs = sun_map_vs1;
#ifdef YYLSP_NEEDED
      sun_map_ls = sun_map_ls1;
#endif
#else /* no sun_map_overflow */
      /* Extend the stack our own way.  */
      if (sun_map_stacksize >= YYMAXDEPTH)
	{
	  sun_map_error("parser stack overflow");
	  if (sun_map_free_stacks)
	    {
	      free (sun_map_ss);
	      free (sun_map_vs);
#ifdef YYLSP_NEEDED
	      free (sun_map_ls);
#endif
	    }
	  return 2;
	}
      sun_map_stacksize *= 2;
      if (sun_map_stacksize > YYMAXDEPTH)
	sun_map_stacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      sun_map_free_stacks = 1;
#endif
      sun_map_ss = (short *) YYSTACK_ALLOC (sun_map_stacksize * sizeof (*sun_map_ssp));
      __sun_map__memcpy ((char *)sun_map_ss, (char *)sun_map_ss1,
		   size * (unsigned int) sizeof (*sun_map_ssp));
      sun_map_vs = (YYSTYPE *) YYSTACK_ALLOC (sun_map_stacksize * sizeof (*sun_map_vsp));
      __sun_map__memcpy ((char *)sun_map_vs, (char *)sun_map_vs1,
		   size * (unsigned int) sizeof (*sun_map_vsp));
#ifdef YYLSP_NEEDED
      sun_map_ls = (YYLTYPE *) YYSTACK_ALLOC (sun_map_stacksize * sizeof (*sun_map_lsp));
      __sun_map__memcpy ((char *)sun_map_ls, (char *)sun_map_ls1,
		   size * (unsigned int) sizeof (*sun_map_lsp));
#endif
#endif /* no sun_map_overflow */

      sun_map_ssp = sun_map_ss + size - 1;
      sun_map_vsp = sun_map_vs + size - 1;
#ifdef YYLSP_NEEDED
      sun_map_lsp = sun_map_ls + size - 1;
#endif

#if YYDEBUG != 0
      if (sun_map_debug)
	fprintf(stderr, "Stack size increased to %d\n", sun_map_stacksize);
#endif

      if (sun_map_ssp >= sun_map_ss + sun_map_stacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (sun_map_debug)
    fprintf(stderr, "Entering state %d\n", sun_map_state);
#endif

  goto sun_map_backup;
 sun_map_backup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* sun_map_resume: */

  /* First try to decide what to do without reference to lookahead token.  */

  sun_map_n = sun_map_pact[sun_map_state];
  if (sun_map_n == YYFLAG)
    goto sun_map_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* sun_map_char is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (sun_map_char == YYEMPTY)
    {
#if YYDEBUG != 0
      if (sun_map_debug)
	fprintf(stderr, "Reading a token: ");
#endif
      sun_map_char = YYLEX;
    }

  /* Convert token to internal form (in sun_map_char1) for indexing tables with */

  if (sun_map_char <= 0)		/* This means end of input. */
    {
      sun_map_char1 = 0;
      sun_map_char = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (sun_map_debug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      sun_map_char1 = YYTRANSLATE(sun_map_char);

#if YYDEBUG != 0
      if (sun_map_debug)
	{
	  fprintf (stderr, "Next token is %d (%s", sun_map_char, sun_map_tname[sun_map_char1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, sun_map_char, sun_map_lval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  sun_map_n += sun_map_char1;
  if (sun_map_n < 0 || sun_map_n > YYLAST || sun_map_check[sun_map_n] != sun_map_char1)
    goto sun_map_default;

  sun_map_n = sun_map_table[sun_map_n];

  /* sun_map_n is what to do for this token type in this state.
     Negative => reduce, -sun_map_n is rule number.
     Positive => shift, sun_map_n is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (sun_map_n < 0)
    {
      if (sun_map_n == YYFLAG)
	goto sun_map_errlab;
      sun_map_n = -sun_map_n;
      goto sun_map_reduce;
    }
  else if (sun_map_n == 0)
    goto sun_map_errlab;

  if (sun_map_n == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (sun_map_debug)
    fprintf(stderr, "Shifting token %d (%s), ", sun_map_char, sun_map_tname[sun_map_char1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (sun_map_char != YYEOF)
    sun_map_char = YYEMPTY;

  *++sun_map_vsp = sun_map_lval;
#ifdef YYLSP_NEEDED
  *++sun_map_lsp = sun_map_lloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (sun_map_errstatus) sun_map_errstatus--;

  sun_map_state = sun_map_n;
  goto sun_map_newstate;

/* Do the default action for the current state.  */
sun_map_default:

  sun_map_n = sun_map_defact[sun_map_state];
  if (sun_map_n == 0)
    goto sun_map_errlab;

/* Do a reduction.  sun_map_n is the number of a rule to reduce with.  */
sun_map_reduce:
  sun_map_len = sun_map_r2[sun_map_n];
  if (sun_map_len > 0)
    sun_map_val = sun_map_vsp[1-sun_map_len]; /* implement default value of the action */

#if YYDEBUG != 0
  if (sun_map_debug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       sun_map_n, sun_map_rline[sun_map_n]);

      /* Print the symbols being reduced, and their result.  */
      for (i = sun_map_prhs[sun_map_n]; sun_map_rhs[i] > 0; i++)
	fprintf (stderr, "%s ", sun_map_tname[sun_map_rhs[i]]);
      fprintf (stderr, " -> %s\n", sun_map_tname[sun_map_r1[sun_map_n]]);
    }
#endif


  switch (sun_map_n) {

case 9:
#line 110 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

   /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
;
    break;}
case 10:
#line 131 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
;
    break;}
case 11:
#line 166 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
;
    break;}
case 12:
#line 187 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
;
    break;}
case 15:
#line 228 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /*
   * Assign the global loaction list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-2].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
;
    break;}
case 16:
#line 251 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    mountpt->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  mountpt->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-5].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
;
    break;}
case 19:
#line 294 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_host_list();
  location->host_list = (struct sun_host *)list->first;
  sun_host_list = NULL;

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
;
    break;}
case 20:
#line 317 "sun_map_parse.y"
{

  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
;
    break;}
case 23:
#line 335 "sun_map_parse.y"
{

  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  host->name = strdup(sun_map_vsp[0].strval);

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(),(qelem *)host);
;
    break;}
case 24:
#line 346 "sun_map_parse.y"
{

  /*
   * It is assumed that the host for this rule was allocated by the
   * 'weight' rule and assigned to be the last host item on the host
   * list.
   */
  struct sun_host *host = (struct sun_host *)sun_host_list->last;

  host->name = strdup(sun_map_vsp[-1].strval);
;
    break;}
case 25:
#line 359 "sun_map_parse.y"
{

  int val;
  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  val = atoi(sun_map_vsp[-1].strval);

  host->weight = val;

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(), (qelem *)host);
;
    break;}
case 28:
#line 378 "sun_map_parse.y"
{

  char *type;

  /* check if this is an fstype option */
  if ((type = strstr(sun_map_vsp[0].strval,SUN_FSTYPE_STR)) != NULL) {
    /* parse out the fs type from the Sun fstype keyword  */
    if ((type = type + strlen(SUN_FSTYPE_STR)) != NULL) {
      /*
       * This global fstype str will be assigned to the current being
       * parsed later in the parsing.
       */
      tmpFsType = strdup(type);
    }
  }
  else {
    /*
     * If it is not an fstype option allocate an opt struct and assign
     * the value.
     */
    struct sun_opt *opt = CALLOC(struct sun_opt);
    opt->str = strdup(sun_map_vsp[0].strval);
    /* Add this opt to the opt list. */
    sun_list_add(get_sun_opt_list(), (qelem *)opt);
  }
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/bison.simple"

  sun_map_vsp -= sun_map_len;
  sun_map_ssp -= sun_map_len;
#ifdef YYLSP_NEEDED
  sun_map_lsp -= sun_map_len;
#endif

#if YYDEBUG != 0
  if (sun_map_debug)
    {
      short *ssp1 = sun_map_ss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != sun_map_ssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++sun_map_vsp = sun_map_val;

#ifdef YYLSP_NEEDED
  sun_map_lsp++;
  if (sun_map_len == 0)
    {
      sun_map_lsp->first_line = sun_map_lloc.first_line;
      sun_map_lsp->first_column = sun_map_lloc.first_column;
      sun_map_lsp->last_line = (sun_map_lsp-1)->last_line;
      sun_map_lsp->last_column = (sun_map_lsp-1)->last_column;
      sun_map_lsp->text = 0;
    }
  else
    {
      sun_map_lsp->last_line = (sun_map_lsp+sun_map_len-1)->last_line;
      sun_map_lsp->last_column = (sun_map_lsp+sun_map_len-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  sun_map_n = sun_map_r1[sun_map_n];

  sun_map_state = sun_map_pgoto[sun_map_n - YYNTBASE] + *sun_map_ssp;
  if (sun_map_state >= 0 && sun_map_state <= YYLAST && sun_map_check[sun_map_state] == *sun_map_ssp)
    sun_map_state = sun_map_table[sun_map_state];
  else
    sun_map_state = sun_map_defgoto[sun_map_n - YYNTBASE];

  goto sun_map_newstate;

sun_map_errlab:   /* here on detecting error */

  if (! sun_map_errstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++sun_map_nerrs;

#ifdef YYERROR_VERBOSE
      sun_map_n = sun_map_pact[sun_map_state];

      if (sun_map_n > YYFLAG && sun_map_n < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -sun_map_n if nec to avoid negative indexes in sun_map_check.  */
	  for (x = (sun_map_n < 0 ? -sun_map_n : 0);
	       x < (sizeof(sun_map_tname) / sizeof(char *)); x++)
	    if (sun_map_check[x + sun_map_n] == x)
	      size += strlen(sun_map_tname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (sun_map_n < 0 ? -sun_map_n : 0);
		       x < (sizeof(sun_map_tname) / sizeof(char *)); x++)
		    if (sun_map_check[x + sun_map_n] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, sun_map_tname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      sun_map_error(msg);
	      free(msg);
	    }
	  else
	    sun_map_error ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	sun_map_error("parse error");
    }

  goto sun_map_errlab1;
sun_map_errlab1:   /* here on error raised explicitly by an action */

  if (sun_map_errstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (sun_map_char == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (sun_map_debug)
	fprintf(stderr, "Discarding token %d (%s).\n", sun_map_char, sun_map_tname[sun_map_char1]);
#endif

      sun_map_char = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  sun_map_errstatus = 3;		/* Each real token shifted decrements this */

  goto sun_map_errhandle;

sun_map_errdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  sun_map_n = sun_map_defact[sun_map_state];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (sun_map_n) goto sun_map_default;
#endif

sun_map_errpop:   /* pop the current state because it cannot handle the error token */

  if (sun_map_ssp == sun_map_ss) YYABORT;
  sun_map_vsp--;
  sun_map_state = *--sun_map_ssp;
#ifdef YYLSP_NEEDED
  sun_map_lsp--;
#endif

#if YYDEBUG != 0
  if (sun_map_debug)
    {
      short *ssp1 = sun_map_ss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != sun_map_ssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

sun_map_errhandle:

  sun_map_n = sun_map_pact[sun_map_state];
  if (sun_map_n == YYFLAG)
    goto sun_map_errdefault;

  sun_map_n += YYTERROR;
  if (sun_map_n < 0 || sun_map_n > YYLAST || sun_map_check[sun_map_n] != YYTERROR)
    goto sun_map_errdefault;

  sun_map_n = sun_map_table[sun_map_n];
  if (sun_map_n < 0)
    {
      if (sun_map_n == YYFLAG)
	goto sun_map_errpop;
      sun_map_n = -sun_map_n;
      goto sun_map_reduce;
    }
  else if (sun_map_n == 0)
    goto sun_map_errpop;

  if (sun_map_n == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (sun_map_debug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++sun_map_vsp = sun_map_lval;
#ifdef YYLSP_NEEDED
  *++sun_map_lsp = sun_map_lloc;
#endif

  sun_map_state = sun_map_n;
  goto sun_map_newstate;

 sun_map_acceptlab:
  /* YYACCEPT comes here.  */
  if (sun_map_free_stacks)
    {
      free (sun_map_ss);
      free (sun_map_vs);
#ifdef YYLSP_NEEDED
      free (sun_map_ls);
#endif
    }
  return 0;

 sun_map_abortlab:
  /* YYABORT comes here.  */
  if (sun_map_free_stacks)
    {
      free (sun_map_ss);
      free (sun_map_vs);
#ifdef YYLSP_NEEDED
      free (sun_map_ls);
#endif
    }
  return 1;
}
#line 407 "sun_map_parse.y"


/*
 * Parse 'map_data' which is assumed to be a Sun-syle map.  If
 * successful a sun_entry is returned.
 *
 * The parser is designed to parse map entries with out the keys.  For
 * example the entry:
 *
 * usr -ro pluto:/usr/local
 *
 * should be passed to the parser as:
 *
 * -ro pluto:/usr/local
 *
 * The reason for this is that the Amd info services already strip off
 * the key when they read map info.
 */
struct sun_entry *
sun_map_parse_read(const char *map_data)
{
  struct sun_entry *retval = NULL;

  /* pass map_data to lex */
  sun_map_tok_setbuff(map_data);

  /* call yacc */
  sun_map_parse();

  if (sun_entry_list != NULL) {
    /* return the first Sun entry in the list */
    retval = (struct sun_entry*)sun_entry_list->first;
    sun_entry_list = NULL;
  }
  else {
    plog(XLOG_ERROR, "Sun map parser did not produce data structs.");
  }

  return retval;
}


static struct sun_list *
get_sun_entry_list(void)
{
  if (sun_entry_list == NULL) {
    sun_entry_list = CALLOC(struct sun_list);
  }
  return sun_entry_list;
}


static struct sun_list *
get_mountpt_list(void)
{
  if (mountpt_list == NULL) {
    mountpt_list = CALLOC(struct sun_list);
  }
  return mountpt_list;
}


static struct sun_list *
get_sun_location_list(void)
{
  if (sun_location_list == NULL) {
    sun_location_list = CALLOC(struct sun_list);
  }
  return sun_location_list;
}


static struct sun_list *
get_sun_host_list(void)
{
  if (sun_host_list == NULL) {
    sun_host_list = CALLOC(struct sun_list);
  }
  return sun_host_list;
}


static struct sun_list *
get_sun_opt_list(void)
{
  if (sun_opt_list == NULL) {
    sun_opt_list = CALLOC(struct sun_list);
  }
  return sun_opt_list;
}
