/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.FileUtil;

public final class TempDirHelper {
    public static final String DEFAULT_PATTERN = "${java.io.tmpdir}/camel/camel-tmp-#uuid#";

    private TempDirHelper() {
    }

    public static String resolveDefaultTempDir(CamelContext camelContext, String path) {
        return TempDirHelper.resolveTempDir(camelContext, DEFAULT_PATTERN, path);
    }

    public static String resolveTempDir(CamelContext camelContext, String pattern, String path) {
        String answer;
        if (pattern != null && path != null) {
            path = pattern + "/" + (String)path;
        } else if (path == null) {
            path = pattern;
        }
        if (camelContext.getManagementNameStrategy() != null) {
            String name = camelContext.getManagementNameStrategy().resolveManagementName((String)path, camelContext.getName(), false);
            if (name != null) {
                name = TempDirHelper.customResolveManagementName(camelContext, name);
            }
            if (name != null) {
                name = camelContext.getManagementNameStrategy().resolveManagementName(name, camelContext.getName(), true);
            }
            answer = name;
        } else {
            answer = TempDirHelper.defaultManagementName(camelContext, (String)path);
        }
        answer = FileUtil.compactPath((String)answer);
        return answer;
    }

    private static String defaultManagementName(CamelContext camelContext, String path) {
        String name = camelContext.getName();
        String answer = path;
        answer = answer.replace("#camelId#", name);
        answer = answer.replace("#name#", name);
        answer = TempDirHelper.customResolveManagementName(camelContext, answer);
        return answer;
    }

    private static String customResolveManagementName(CamelContext camelContext, String pattern) {
        if (pattern.contains("#uuid#")) {
            String uuid = camelContext.getUuidGenerator().generateUuid();
            pattern = pattern.replace("#uuid#", uuid);
        }
        return FilePathResolver.resolvePath((String)pattern);
    }
}

