/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;

public final class ApiMethodImpl
implements ApiMethod {
    private final String name;
    private final Class<?> resultType;
    private final List<String> argNames;
    private final List<String> setterArgNames;
    private final List<Class<?>> argTypes;
    private final Method method;

    public ApiMethodImpl(Class<?> proxyType, Class<?> resultType, String name, ApiMethodArg ... args) throws IllegalArgumentException {
        this.name = name;
        this.resultType = resultType;
        ArrayList<String> tmpSetterArgNames = new ArrayList<String>();
        ArrayList<String> tmpArgNames = new ArrayList<String>();
        ArrayList tmpArgTypes = new ArrayList();
        for (ApiMethodArg arg : args) {
            if (arg.isSetter()) {
                tmpSetterArgNames.add(arg.getName());
                continue;
            }
            tmpArgTypes.add(arg.getType());
            tmpArgNames.add(arg.getName());
        }
        this.argNames = Collections.unmodifiableList(tmpArgNames);
        this.argTypes = Collections.unmodifiableList(tmpArgTypes);
        this.setterArgNames = Collections.unmodifiableList(tmpSetterArgNames);
        try {
            this.method = proxyType.getMethod(name, this.argTypes.toArray(new Class[this.argNames.size()]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Missing method %s %s", name, this.argTypes.toString().replace('[', '(').replace(']', ')')), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getResultType() {
        return this.resultType;
    }

    @Override
    public List<String> getArgNames() {
        return this.argNames;
    }

    @Override
    public List<String> getSetterArgNames() {
        return this.setterArgNames;
    }

    @Override
    public List<Class<?>> getArgTypes() {
        return this.argTypes;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("{").append("name=").append(this.name).append(", resultType=").append(this.resultType).append(", argNames=").append(this.argNames).append(", argTypes=").append(this.argTypes).append("}");
        return builder.toString();
    }
}

