--
-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
local _M = {}

local openai_compatible_chat_schema = {
        type = "object",
        properties = {
            messages = {
                type = "array",
                minItems = 1,
                items = {
                    properties = {
                        role = {
                            type = "string",
                            enum = {"system", "user", "assistant"}
                        },
                        content = {
                            type = "string",
                            minLength = "1",
                        },
                    },
                    additionalProperties = false,
                    required = {"role", "content"},
                },
            }
        },
        required = {"messages"}
    }

_M.chat_request_schema = {
    ["openai"] = openai_compatible_chat_schema,
    ["deepseek"] = openai_compatible_chat_schema,
    ["openai-compatible"] = openai_compatible_chat_schema,
    ["azure-openai"] = openai_compatible_chat_schema
}

function _M.is_openai_compatible_provider(provider)
    if provider == "openai" or
       provider == "deepseek" or
       provider == "openai-compatible" or
       provider == "azure-openai" then
        return true
    end
    return false
end

return  _M
