/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.MultiResponse;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.junit.Assert;
import org.junit.Test;

public class MultiResponseTest
extends ZKTestCase {
    public void testRoundTrip() throws IOException {
        MultiResponse response = new MultiResponse();
        response.add((OpResult)new OpResult.CheckResult());
        response.add((OpResult)new OpResult.CreateResult("foo-bar"));
        response.add((OpResult)new OpResult.DeleteResult());
        Stat s = new Stat();
        s.setCzxid(546L);
        response.add((OpResult)new OpResult.SetDataResult(s));
        MultiResponse decodedResponse = this.codeDecode(response);
        Assert.assertEquals((Object)response, (Object)decodedResponse);
        Assert.assertEquals((long)response.hashCode(), (long)decodedResponse.hashCode());
    }

    @Test
    public void testEmptyRoundTrip() throws IOException {
        MultiResponse result = new MultiResponse();
        MultiResponse decodedResult = this.codeDecode(result);
        Assert.assertEquals((Object)result, (Object)decodedResult);
        Assert.assertEquals((long)result.hashCode(), (long)decodedResult.hashCode());
    }

    private MultiResponse codeDecode(MultiResponse request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        request.serialize((OutputArchive)boa, "result");
        baos.close();
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        bb.rewind();
        BinaryInputArchive bia = BinaryInputArchive.getArchive((InputStream)new ByteBufferInputStream(bb));
        MultiResponse decodedRequest = new MultiResponse();
        decodedRequest.deserialize((InputArchive)bia, "result");
        return decodedRequest;
    }
}

