/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DigestCalculator;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.metric.SimpleCounter;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerMainTest;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDigestTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDigestTest.class);
    private ZooKeeper zk;
    private ZooKeeperServer server;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.serverFactory.getZooKeeperServer();
        this.zk = this.createClient();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.zk != null) {
            this.zk.close();
        }
    }

    @Override
    public void setupCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled((boolean)true);
        System.setProperty("zookeeper.snapCount", "100");
    }

    @Override
    public void cleanUpCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled((boolean)false);
        System.clearProperty("zookeeper.snapCount");
    }

    @Test
    public void testSnapshotDigest() throws Exception {
        this.server.takeSnapshot();
        this.reloadSnapshotAndCheckDigest();
        String pathPrefix = "/testSnapshotDigest";
        for (int i = 0; i < 1000; ++i) {
            String path = pathPrefix + i;
            this.zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        String firstNode = pathPrefix + 0;
        this.zk.setData(firstNode, "new_setdata".getBytes(), -1);
        this.zk.delete(firstNode, -1);
        ArrayList<Op> subTxns = new ArrayList<Op>();
        for (int i = 0; i < 3; ++i) {
            String path = pathPrefix + "-m" + i;
            subTxns.add(Op.create((String)path, (byte[])path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        }
        this.zk.multi(subTxns);
        this.reloadSnapshotAndCheckDigest();
        this.server = this.serverFactory.getZooKeeperServer();
        this.server.takeSnapshot();
        this.reloadSnapshotAndCheckDigest();
    }

    @Test
    public void testDifferentDigestVersion() throws Exception {
        int currentVersion = new DigestCalculator().getDigestVersion();
        String path = "/testDifferentDigestVersion";
        this.zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.server.takeSnapshot();
        int newVersion = currentVersion + 1;
        DigestCalculator newVersionDigestCalculator = (DigestCalculator)Mockito.spy(DigestCalculator.class);
        Mockito.when((Object)newVersionDigestCalculator.getDigestVersion()).thenReturn((Object)newVersion);
        Assert.assertEquals((long)newVersion, (long)newVersionDigestCalculator.getDigestVersion());
        FileTxnSnapLog txnSnapLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        DataTree dataTree = (DataTree)Mockito.spy((Object)new DataTree(newVersionDigestCalculator));
        Mockito.when((Object)dataTree.getTreeDigest()).thenReturn((Object)0L);
        txnSnapLog.restore(dataTree, new ConcurrentHashMap(), (FileTxnSnapLog.PlayBackListener)Mockito.mock(FileTxnSnapLog.PlayBackListener.class));
        ((DataTree)Mockito.verify((Object)dataTree, (VerificationMode)Mockito.never())).reportDigestMismatch(Mockito.anyLong());
    }

    @Test
    public void testBackwardCompatible() throws Exception {
        this.testCompatibleHelper(false, true);
        this.testCompatibleHelper(true, false);
    }

    private void testCompatibleHelper(Boolean enabledBefore, Boolean enabledAfter) throws Exception {
        ZooKeeperServer.setDigestEnabled((boolean)enabledBefore);
        this.reloadSnapshotAndCheckDigest();
        String path = "/testCompatible-" + enabledBefore + "-" + enabledAfter;
        this.zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.server.takeSnapshot();
        ZooKeeperServer.setDigestEnabled((boolean)enabledAfter);
        this.reloadSnapshotAndCheckDigest();
        Assert.assertEquals((Object)path, (Object)new String(this.zk.getData(path, false, null)));
    }

    private void reloadSnapshotAndCheckDigest() throws Exception {
        this.stopServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTING);
        ((SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT).reset();
        this.startServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTED);
        this.server = this.serverFactory.getZooKeeperServer();
        Assert.assertEquals((long)0L, (long)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT.get());
        Assert.assertNull((Object)this.server.getZKDatabase().getDataTree().getDigestFromLoadedSnapshot());
    }
}

