/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterController;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterControllerService
extends AbstractLifecycleComponent<StorageConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ClusterControllerService.class);
    private final Supplier<ClusterController> controllerSupplier;
    private ClusterController controller;

    public ClusterControllerService(StorageConfiguration conf, Supplier<ClusterController> controllerSupplier, StatsLogger statsLogger) {
        super("cluster-controller", (ComponentConfiguration)conf, statsLogger);
        this.controllerSupplier = controllerSupplier;
    }

    protected void doStart() {
        if (null == this.controller) {
            this.controller = this.controllerSupplier.get();
            this.controller.start();
            log.info("Successfully started the cluster controller.");
        }
    }

    protected void doStop() {
        if (null != this.controller) {
            this.controller.stop();
        }
    }

    protected void doClose() throws IOException {
    }
}

