/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.CBCodec;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.CassandraUInt;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class QueryOptions {
    public static final QueryOptions DEFAULT = new DefaultQueryOptions(ConsistencyLevel.ONE, Collections.emptyList(), false, SpecificOptions.DEFAULT, ProtocolVersion.CURRENT);
    public static final CBCodec<QueryOptions> codec = new Codec();
    private static final long UNSET_NOWINSEC = Long.MIN_VALUE;
    private List<Map<ColumnIdentifier, Term>> jsonValuesCache;

    public static QueryOptions forInternalCalls(ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new DefaultQueryOptions(consistency, values, false, SpecificOptions.DEFAULT, ProtocolVersion.V3);
    }

    public static QueryOptions forInternalCallsWithNowInSec(long nowInSec, ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new DefaultQueryOptions(consistency, values, false, SpecificOptions.DEFAULT.withNowInSec(nowInSec), ProtocolVersion.CURRENT);
    }

    public static QueryOptions forInternalCalls(List<ByteBuffer> values) {
        return new DefaultQueryOptions(ConsistencyLevel.ONE, values, false, SpecificOptions.DEFAULT, ProtocolVersion.V3);
    }

    public static QueryOptions forProtocolVersion(ProtocolVersion protocolVersion) {
        return new DefaultQueryOptions(null, null, true, null, protocolVersion);
    }

    public static QueryOptions create(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency, ProtocolVersion version, String keyspace) {
        return QueryOptions.create(consistency, values, skipMetadata, pageSize, pagingState, serialConsistency, version, keyspace, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    public static QueryOptions create(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency, ProtocolVersion version, String keyspace, long timestamp, long nowInSeconds) {
        return new DefaultQueryOptions(consistency, values, skipMetadata, new SpecificOptions(pageSize, pagingState, serialConsistency, timestamp, keyspace, nowInSeconds), version);
    }

    public static QueryOptions addColumnSpecifications(QueryOptions options, List<ColumnSpecification> columnSpecs) {
        return new OptionsWithColumnSpecifications(options, columnSpecs);
    }

    public static QueryOptions withConsistencyLevel(QueryOptions options, ConsistencyLevel consistencyLevel) {
        return new OptionsWithConsistencyLevel(options, consistencyLevel);
    }

    public static QueryOptions withPageSize(QueryOptions options, int pageSize) {
        return new OptionsWithPageSize(options, pageSize);
    }

    public abstract ConsistencyLevel getConsistency();

    public abstract List<ByteBuffer> getValues();

    public abstract boolean skipMetadata();

    public Term getJsonColumnValue(int bindIndex, ColumnIdentifier columnName, Collection<ColumnMetadata> expectedReceivers) throws InvalidRequestException {
        Map<ColumnIdentifier, Term> jsonValue;
        if (this.jsonValuesCache == null) {
            this.jsonValuesCache = new ArrayList<Object>(Collections.nCopies(this.getValues().size(), null));
        }
        if ((jsonValue = this.jsonValuesCache.get(bindIndex)) == null) {
            ByteBuffer value = this.getValues().get(bindIndex);
            if (value == null) {
                throw new InvalidRequestException("Got null for INSERT JSON values");
            }
            jsonValue = Json.parseJson(UTF8Type.instance.getSerializer().deserialize(value), expectedReceivers);
            this.jsonValuesCache.set(bindIndex, jsonValue);
        }
        return jsonValue.get(columnName);
    }

    public boolean hasColumnSpecifications() {
        return false;
    }

    public ImmutableList<ColumnSpecification> getColumnSpecifications() {
        throw new UnsupportedOperationException();
    }

    public int getPageSize() {
        return this.getSpecificOptions().pageSize;
    }

    public PagingState getPagingState() {
        return this.getSpecificOptions().state;
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.getSpecificOptions().serialConsistency;
    }

    public long getTimestamp(QueryState state) {
        long tstamp = this.getSpecificOptions().timestamp;
        return tstamp != Long.MIN_VALUE ? tstamp : state.getTimestamp();
    }

    public long getNowInSeconds(QueryState state) {
        long nowInSeconds = this.getSpecificOptions().nowInSeconds;
        return nowInSeconds != Long.MIN_VALUE ? nowInSeconds : state.getNowInSeconds();
    }

    public String getKeyspace() {
        return this.getSpecificOptions().keyspace;
    }

    public long getNowInSec(long ifNotSet) {
        long nowInSec = this.getSpecificOptions().nowInSeconds;
        return nowInSec != Long.MIN_VALUE ? nowInSec : ifNotSet;
    }

    public abstract ProtocolVersion getProtocolVersion();

    abstract SpecificOptions getSpecificOptions();

    abstract ReadThresholds getReadThresholds();

    public boolean isReadThresholdsEnabled() {
        return this.getReadThresholds().isEnabled();
    }

    public long getCoordinatorReadSizeWarnThresholdBytes() {
        return this.getReadThresholds().getCoordinatorReadSizeWarnThresholdBytes();
    }

    public long getCoordinatorReadSizeAbortThresholdBytes() {
        return this.getReadThresholds().getCoordinatorReadSizeFailThresholdBytes();
    }

    public QueryOptions prepare(List<ColumnSpecification> specs) {
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class Codec
    implements CBCodec<QueryOptions> {
        private Codec() {
        }

        @Override
        public QueryOptions decode(ByteBuf body, ProtocolVersion version) {
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            EnumSet<Flag> flags = Flag.deserialize(version.isGreaterOrEqualTo(ProtocolVersion.V5) ? (int)body.readUnsignedInt() : body.readUnsignedByte());
            List values = Collections.emptyList();
            List names = null;
            if (flags.contains((Object)Flag.VALUES)) {
                if (flags.contains((Object)Flag.NAMES_FOR_VALUES)) {
                    Pair<List<String>, List<ByteBuffer>> namesAndValues = CBUtil.readNameAndValueList(body, version);
                    names = (List)namesAndValues.left;
                    values = (List)namesAndValues.right;
                } else {
                    values = CBUtil.readValueList(body, version);
                }
            }
            boolean skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
            flags.remove((Object)Flag.VALUES);
            flags.remove((Object)Flag.SKIP_METADATA);
            SpecificOptions options = SpecificOptions.DEFAULT;
            if (!flags.isEmpty()) {
                int pageSize = flags.contains((Object)Flag.PAGE_SIZE) ? body.readInt() : -1;
                PagingState pagingState = flags.contains((Object)Flag.PAGING_STATE) ? PagingState.deserialize(CBUtil.readValueNoCopy(body), version) : null;
                ConsistencyLevel serialConsistency = flags.contains((Object)Flag.SERIAL_CONSISTENCY) ? CBUtil.readConsistencyLevel(body) : ConsistencyLevel.SERIAL;
                long timestamp = Long.MIN_VALUE;
                if (flags.contains((Object)Flag.TIMESTAMP)) {
                    long ts = body.readLong();
                    if (ts == Long.MIN_VALUE) {
                        throw new ProtocolException(String.format("Out of bound timestamp, must be in [%d, %d] (got %d)", -9223372036854775807L, Long.MAX_VALUE, ts));
                    }
                    timestamp = ts;
                }
                String keyspace = flags.contains((Object)Flag.KEYSPACE) ? CBUtil.readString(body) : null;
                long nowInSeconds = flags.contains((Object)Flag.NOW_IN_SECONDS) ? CassandraUInt.toLong(body.readInt()) : Long.MIN_VALUE;
                options = new SpecificOptions(pageSize, pagingState, serialConsistency, timestamp, keyspace, nowInSeconds);
            }
            DefaultQueryOptions opts = new DefaultQueryOptions(consistency, values, skipMetadata, options, version);
            return names == null ? opts : new OptionsWithNames(opts, names);
        }

        @Override
        public void encode(QueryOptions options, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeConsistencyLevel(options.getConsistency(), dest);
            EnumSet<Flag> flags = this.gatherFlags(options, version);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                dest.writeInt(Flag.serialize(flags));
            } else {
                dest.writeByte((int)((byte)Flag.serialize(flags)));
            }
            if (flags.contains((Object)Flag.VALUES)) {
                CBUtil.writeValueList(options.getValues(), dest);
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                dest.writeInt(options.getPageSize());
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                CBUtil.writeValue(options.getPagingState().serialize(version), dest);
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                CBUtil.writeConsistencyLevel(options.getSerialConsistency(), dest);
            }
            if (flags.contains((Object)Flag.TIMESTAMP)) {
                dest.writeLong(options.getSpecificOptions().timestamp);
            }
            if (flags.contains((Object)Flag.KEYSPACE)) {
                CBUtil.writeAsciiString(options.getSpecificOptions().keyspace, dest);
            }
            if (flags.contains((Object)Flag.NOW_IN_SECONDS)) {
                dest.writeInt(CassandraUInt.fromLong(options.getSpecificOptions().nowInSeconds));
            }
        }

        @Override
        public int encodedSize(QueryOptions options, ProtocolVersion version) {
            int size = 0;
            size += CBUtil.sizeOfConsistencyLevel(options.getConsistency());
            EnumSet<Flag> flags = this.gatherFlags(options, version);
            size += version.isGreaterOrEqualTo(ProtocolVersion.V5) ? 4 : 1;
            if (flags.contains((Object)Flag.VALUES)) {
                size += CBUtil.sizeOfValueList(options.getValues());
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                size += 4;
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                size += CBUtil.sizeOfValue(options.getPagingState().serializedSize(version));
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                size += CBUtil.sizeOfConsistencyLevel(options.getSerialConsistency());
            }
            if (flags.contains((Object)Flag.TIMESTAMP)) {
                size += 8;
            }
            if (flags.contains((Object)Flag.KEYSPACE)) {
                size += CBUtil.sizeOfAsciiString(options.getSpecificOptions().keyspace);
            }
            if (flags.contains((Object)Flag.NOW_IN_SECONDS)) {
                size += 4;
            }
            return size;
        }

        private EnumSet<Flag> gatherFlags(QueryOptions options, ProtocolVersion version) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (options.getValues().size() > 0) {
                flags.add(Flag.VALUES);
            }
            if (options.skipMetadata()) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (options.getPageSize() >= 0) {
                flags.add(Flag.PAGE_SIZE);
            }
            if (options.getPagingState() != null) {
                flags.add(Flag.PAGING_STATE);
            }
            if (options.getSerialConsistency() != ConsistencyLevel.SERIAL) {
                flags.add(Flag.SERIAL_CONSISTENCY);
            }
            if (options.getSpecificOptions().timestamp != Long.MIN_VALUE) {
                flags.add(Flag.TIMESTAMP);
            }
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                if (options.getSpecificOptions().keyspace != null) {
                    flags.add(Flag.KEYSPACE);
                }
                if (options.getSpecificOptions().nowInSeconds != Long.MIN_VALUE) {
                    flags.add(Flag.NOW_IN_SECONDS);
                }
            }
            return flags;
        }

        private static enum Flag {
            VALUES,
            SKIP_METADATA,
            PAGE_SIZE,
            PAGING_STATE,
            SERIAL_CONSISTENCY,
            TIMESTAMP,
            NAMES_FOR_VALUES,
            KEYSPACE,
            NOW_IN_SECONDS;

            private static final Flag[] ALL_VALUES;

            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                for (int n = 0; n < ALL_VALUES.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(ALL_VALUES[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }

            static {
                ALL_VALUES = Flag.values();
            }
        }
    }

    static class SpecificOptions {
        private static final SpecificOptions DEFAULT = new SpecificOptions(-1, null, null, Long.MIN_VALUE, null, Long.MIN_VALUE);
        private final int pageSize;
        private final PagingState state;
        private final ConsistencyLevel serialConsistency;
        private final long timestamp;
        private final String keyspace;
        private final long nowInSeconds;

        private SpecificOptions(int pageSize, PagingState state, ConsistencyLevel serialConsistency, long timestamp, String keyspace, long nowInSeconds) {
            this.pageSize = pageSize;
            this.state = state;
            this.serialConsistency = serialConsistency == null ? ConsistencyLevel.SERIAL : serialConsistency;
            this.timestamp = timestamp;
            this.keyspace = keyspace;
            this.nowInSeconds = nowInSeconds;
        }

        public SpecificOptions withNowInSec(long nowInSec) {
            return new SpecificOptions(this.pageSize, this.state, this.serialConsistency, this.timestamp, this.keyspace, nowInSec);
        }
    }

    static class OptionsWithNames
    extends QueryOptionsWrapper {
        private final List<String> names;
        private List<ByteBuffer> orderedValues;

        OptionsWithNames(DefaultQueryOptions wrapped, List<String> names) {
            super(wrapped);
            this.names = names;
        }

        @Override
        public QueryOptions prepare(List<ColumnSpecification> specs) {
            super.prepare(specs);
            this.orderedValues = new ArrayList<ByteBuffer>(specs.size());
            block0: for (int i = 0; i < specs.size(); ++i) {
                String name = specs.get((int)i).name.toString();
                for (int j = 0; j < this.names.size(); ++j) {
                    if (!name.equals(this.names.get(j))) continue;
                    this.orderedValues.add(this.wrapped.getValues().get(j));
                    continue block0;
                }
            }
            return this;
        }

        @Override
        public List<ByteBuffer> getValues() {
            assert (this.orderedValues != null);
            return this.orderedValues;
        }
    }

    static class OptionsWithColumnSpecifications
    extends QueryOptionsWrapper {
        private final ImmutableList<ColumnSpecification> columnSpecs;

        OptionsWithColumnSpecifications(QueryOptions wrapped, List<ColumnSpecification> columnSpecs) {
            super(wrapped);
            this.columnSpecs = ImmutableList.copyOf(columnSpecs);
        }

        @Override
        public boolean hasColumnSpecifications() {
            return true;
        }

        @Override
        public ImmutableList<ColumnSpecification> getColumnSpecifications() {
            return this.columnSpecs;
        }
    }

    static class OptionsWithPageSize
    extends QueryOptionsWrapper {
        private final int pageSize;

        OptionsWithPageSize(QueryOptions wrapped, int pageSize) {
            super(wrapped);
            this.pageSize = pageSize;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }
    }

    static class OptionsWithConsistencyLevel
    extends QueryOptionsWrapper {
        private final ConsistencyLevel consistencyLevel;

        OptionsWithConsistencyLevel(QueryOptions wrapped, ConsistencyLevel consistencyLevel) {
            super(wrapped);
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public ConsistencyLevel getConsistency() {
            return this.consistencyLevel;
        }
    }

    static class QueryOptionsWrapper
    extends QueryOptions {
        protected final QueryOptions wrapped;

        QueryOptionsWrapper(QueryOptions wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public List<ByteBuffer> getValues() {
            return this.wrapped.getValues();
        }

        @Override
        public ConsistencyLevel getConsistency() {
            return this.wrapped.getConsistency();
        }

        @Override
        public boolean skipMetadata() {
            return this.wrapped.skipMetadata();
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.wrapped.getProtocolVersion();
        }

        @Override
        SpecificOptions getSpecificOptions() {
            return this.wrapped.getSpecificOptions();
        }

        @Override
        ReadThresholds getReadThresholds() {
            return this.wrapped.getReadThresholds();
        }

        @Override
        public QueryOptions prepare(List<ColumnSpecification> specs) {
            this.wrapped.prepare(specs);
            return this;
        }
    }

    static class DefaultQueryOptions
    extends QueryOptions {
        private final ConsistencyLevel consistency;
        private final List<ByteBuffer> values;
        private final boolean skipMetadata;
        private final SpecificOptions options;
        private final transient ProtocolVersion protocolVersion;
        private final transient ReadThresholds readThresholds = ReadThresholds.create();

        DefaultQueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, SpecificOptions options, ProtocolVersion protocolVersion) {
            this.consistency = consistency;
            this.values = values;
            this.skipMetadata = skipMetadata;
            this.options = options;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public ConsistencyLevel getConsistency() {
            return this.consistency;
        }

        @Override
        public List<ByteBuffer> getValues() {
            return this.values;
        }

        @Override
        public boolean skipMetadata() {
            return this.skipMetadata;
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        SpecificOptions getSpecificOptions() {
            return this.options;
        }

        @Override
        ReadThresholds getReadThresholds() {
            return this.readThresholds;
        }
    }

    private static class DefaultReadThresholds
    implements ReadThresholds {
        private final long warnThresholdBytes;
        private final long abortThresholdBytes;

        public DefaultReadThresholds(DataStorageSpec.LongBytesBound warnThreshold, DataStorageSpec.LongBytesBound abortThreshold) {
            this.warnThresholdBytes = warnThreshold == null ? -1L : warnThreshold.toBytes();
            this.abortThresholdBytes = abortThreshold == null ? -1L : abortThreshold.toBytes();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public long getCoordinatorReadSizeWarnThresholdBytes() {
            return this.warnThresholdBytes;
        }

        @Override
        public long getCoordinatorReadSizeFailThresholdBytes() {
            return this.abortThresholdBytes;
        }
    }

    private static enum DisabledReadThresholds implements ReadThresholds
    {
        INSTANCE;


        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public long getCoordinatorReadSizeWarnThresholdBytes() {
            return -1L;
        }

        @Override
        public long getCoordinatorReadSizeFailThresholdBytes() {
            return -1L;
        }
    }

    static interface ReadThresholds {
        public boolean isEnabled();

        public long getCoordinatorReadSizeWarnThresholdBytes();

        public long getCoordinatorReadSizeFailThresholdBytes();

        public static ReadThresholds create() {
            if (!DatabaseDescriptor.isDaemonInitialized() || !DatabaseDescriptor.getReadThresholdsEnabled()) {
                return DisabledReadThresholds.INSTANCE;
            }
            return new DefaultReadThresholds(DatabaseDescriptor.getCoordinatorReadSizeWarnThreshold(), DatabaseDescriptor.getCoordinatorReadSizeFailThreshold());
        }
    }
}

