/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.analyzer.filter;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FilterPipeline {
    private final Task head;
    private Task tail;

    public FilterPipeline(Task first) {
        this(first, first);
    }

    private FilterPipeline(Task first, Task tail) {
        this.head = first;
        this.tail = tail;
    }

    public FilterPipeline add(String name, Task task) {
        Preconditions.checkArgument((task != this.tail ? 1 : 0) != 0, (Object)("Provided last task [" + task.name + "] cannot be set to itself"));
        this.tail.next = task;
        this.tail.name = name;
        this.tail = task;
        return this;
    }

    public Task head() {
        return this.head;
    }

    public static abstract class Task {
        public String name;
        public Task next;

        public abstract String process(String var1);
    }
}

