/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.v1.MetadataSource;
import org.apache.cassandra.index.sai.disk.v1.PerColumnIndexFiles;
import org.apache.cassandra.index.sai.disk.v1.segment.Segment;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.iterators.KeyRangeUnionIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Throwables;

public class V1SSTableIndex
extends SSTableIndex {
    private final ImmutableList<Segment> segments;
    private final List<SegmentMetadata> metadatas;
    private final AbstractBounds<PartitionPosition> bounds;
    private final ByteBuffer minTerm;
    private final ByteBuffer maxTerm;
    private final long minSSTableRowId;
    private final long maxSSTableRowId;
    private final long numRows;
    private PerColumnIndexFiles indexFiles;

    public V1SSTableIndex(SSTableContext sstableContext, StorageAttachedIndex index) {
        super(sstableContext, index);
        try {
            this.indexFiles = new PerColumnIndexFiles(sstableContext.indexDescriptor, this.indexTermType, this.indexIdentifier);
            ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
            MetadataSource source = MetadataSource.loadColumnMetadata(sstableContext.indexDescriptor, this.indexIdentifier);
            this.metadatas = SegmentMetadata.load(source, sstableContext.indexDescriptor.primaryKeyFactory);
            for (SegmentMetadata metadata : this.metadatas) {
                segmentsBuilder.add((Object)new Segment(index, sstableContext, this.indexFiles, metadata));
            }
            this.segments = segmentsBuilder.build();
            assert (!this.segments.isEmpty());
            DecoratedKey minKey = this.metadatas.get((int)0).minKey.partitionKey();
            DecoratedKey maxKey = this.metadatas.get((int)(this.metadatas.size() - 1)).maxKey.partitionKey();
            this.bounds = AbstractBounds.bounds(minKey, true, maxKey, true);
            this.minTerm = this.metadatas.stream().map(m -> m.minTerm).min(this.indexTermType.comparator()).orElse(null);
            this.maxTerm = this.metadatas.stream().map(m -> m.maxTerm).max(this.indexTermType.comparator()).orElse(null);
            this.numRows = this.metadatas.stream().mapToLong(m -> m.numRows).sum();
            this.minSSTableRowId = this.metadatas.get((int)0).minSSTableRowId;
            this.maxSSTableRowId = this.metadatas.get((int)(this.metadatas.size() - 1)).maxSSTableRowId;
        }
        catch (Throwable t) {
            FileUtils.closeQuietly(this.indexFiles);
            FileUtils.closeQuietly(sstableContext);
            throw Throwables.unchecked(t);
        }
    }

    @Override
    public long indexFileCacheSize() {
        return this.segments.stream().mapToLong(Segment::indexFileCacheSize).sum();
    }

    @Override
    public long getRowCount() {
        return this.numRows;
    }

    @Override
    public long minSSTableRowId() {
        return this.minSSTableRowId;
    }

    @Override
    public long maxSSTableRowId() {
        return this.maxSSTableRowId;
    }

    @Override
    public ByteBuffer minTerm() {
        return this.minTerm;
    }

    @Override
    public ByteBuffer maxTerm() {
        return this.maxTerm;
    }

    @Override
    public AbstractBounds<PartitionPosition> bounds() {
        return this.bounds;
    }

    @Override
    public List<KeyRangeIterator> search(Expression expression, AbstractBounds<PartitionPosition> keyRange, QueryContext context) throws IOException {
        ArrayList<KeyRangeIterator> segmentIterators = new ArrayList<KeyRangeIterator>();
        for (Segment segment : this.segments) {
            if (!segment.intersects(keyRange)) continue;
            segmentIterators.add(segment.search(expression, keyRange, context));
        }
        return segmentIterators;
    }

    @Override
    public KeyRangeIterator limitToTopKResults(QueryContext context, List<PrimaryKey> primaryKeys, Expression expression) throws IOException {
        KeyRangeUnionIterator.Builder unionIteratorBuilder = KeyRangeUnionIterator.builder(this.segments.size());
        for (Segment segment : this.segments) {
            unionIteratorBuilder.add(segment.limitToTopKResults(context, primaryKeys, expression));
        }
        return unionIteratorBuilder.build();
    }

    @Override
    public void populateSegmentView(SimpleDataSet dataset) {
        SSTableReader sstable = this.getSSTable();
        Token.TokenFactory tokenFactory = sstable.metadata().partitioner.getTokenFactory();
        for (SegmentMetadata metadata : this.metadatas) {
            dataset.row(sstable.metadata().keyspace, this.indexIdentifier.indexName, sstable.getFilename(), metadata.rowIdOffset).column("table_name", sstable.descriptor.cfname).column("column_name", this.indexTermType.columnName()).column("cell_count", metadata.numRows).column("min_sstable_row_id", metadata.minSSTableRowId).column("max_sstable_row_id", metadata.maxSSTableRowId).column("start_token", tokenFactory.toString(metadata.minKey.token())).column("end_token", tokenFactory.toString(metadata.maxKey.token())).column("min_term", this.indexTermType.indexType().getSerializer().deserialize(metadata.minTerm).toString()).column("max_term", this.indexTermType.indexType().getSerializer().deserialize(metadata.maxTerm).toString()).column("component_metadata", metadata.componentMetadatas.asMap());
        }
    }

    @Override
    protected void internalRelease() {
        FileUtils.closeQuietly(this.indexFiles);
        FileUtils.closeQuietly(this.segments);
    }
}

