/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.NoPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPullVerbHandler
implements IVerbHandler<NoPayload> {
    public static final SchemaPullVerbHandler instance = new SchemaPullVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(SchemaPullVerbHandler.class);
    private final List<Consumer<Message<NoPayload>>> handlers = new CopyOnWriteArrayList<Consumer<Message<NoPayload>>>();

    public void register(Consumer<Message<NoPayload>> handler) {
        this.handlers.add(handler);
    }

    @Override
    public void doVerb(Message<NoPayload> message) {
        logger.trace("Received schema pull request from {}", (Object)message.from());
        List<Consumer<Message<NoPayload>>> handlers = this.handlers;
        if (handlers.isEmpty()) {
            throw new UnsupportedOperationException("There is no handler registered for schema pull verb");
        }
        handlers.forEach(h -> h.accept(message));
    }
}

