/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiEncoding;
import org.agrona.AsciiNumberFormatException;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;

public class ExpandableDirectByteBuffer
implements MutableDirectBuffer {
    public static final int MAX_BUFFER_LENGTH = 0x40000000;
    public static final int INITIAL_CAPACITY = 128;
    private long address;
    private int capacity;
    private ByteBuffer byteBuffer;

    public ExpandableDirectByteBuffer() {
        this(128);
    }

    public ExpandableDirectByteBuffer(int initialCapacity) {
        this.byteBuffer = ByteBuffer.allocateDirect(initialCapacity);
        this.capacity = initialCapacity;
        this.address = BufferUtil.address(this.byteBuffer);
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressOffset() {
        return this.address;
    }

    @Override
    public byte[] byteArray() {
        return null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        this.ensureCapacity(index, length);
        long offset = this.address + (long)index;
        if (UnsafeAccess.MEMSET_HACK_REQUIRED && length > UnsafeAccess.MEMSET_HACK_THRESHOLD && 0L == (offset & 1L)) {
            UnsafeAccess.UNSAFE.putByte(null, offset, value);
            UnsafeAccess.UNSAFE.setMemory(null, offset + 1L, length - 1, value);
        } else {
            UnsafeAccess.UNSAFE.setMemory(null, offset, length, value);
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public void checkLimit(int limit) {
        if (limit < 0) {
            throw new IndexOutOfBoundsException("limit cannot be negative: limit=" + limit);
        }
        this.ensureCapacity(limit, 1);
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        long bits = UnsafeAccess.UNSAFE.getLong(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(null, this.address + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getLong(null, this.address + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putLong(null, this.address + (long)index, value);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(null, this.address + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(null, this.address + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(null, this.address + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(null, this.address + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getDouble(null, this.address + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putDouble(null, this.address + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(null, this.address + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(null, this.address + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getFloat(null, this.address + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putFloat(null, this.address + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        short bits = UnsafeAccess.UNSAFE.getShort(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(null, this.address + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getShort(null, this.address + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putShort(null, this.address + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        this.boundsCheck0(index, 1);
        return UnsafeAccess.UNSAFE.getByte(null, this.address + (long)index);
    }

    private byte getByte0(int index) {
        this.boundsCheck0(index, 1);
        return UnsafeAccess.UNSAFE.getByte(null, this.address + (long)index);
    }

    @Override
    public void putByte(int index, byte value) {
        this.ensureCapacity(index, 1);
        UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index, value);
    }

    private void putByte0(int index, byte value) {
        this.ensureCapacity(index, 1);
        UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index, value);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        this.boundsCheck0(index, length);
        BufferUtil.boundsCheck(dst, (long)offset, length);
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        this.boundsCheck0(index, length);
        BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        if (dstBuffer.isDirect()) {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        } else {
            dstByteArray = BufferUtil.array(dstBuffer);
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        this.ensureCapacity(index, length);
        BufferUtil.boundsCheck(src, (long)offset, length);
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, null, this.address + (long)index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        this.ensureCapacity(index, length);
        BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        if (srcBuffer.isDirect()) {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        } else {
            srcByteArray = BufferUtil.array(srcBuffer);
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, null, this.address + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        srcBuffer.boundsCheck(srcIndex, length);
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, null, this.address + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        char bits = UnsafeAccess.UNSAFE.getChar(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(null, this.address + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getChar(null, this.address + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putChar(null, this.address + (long)index, value);
    }

    @Override
    public String getStringAscii(int index) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, int length) {
        this.boundsCheck0(index + 4, length);
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index + 4L, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringAscii(int index, int length, Appendable appendable) {
        this.boundsCheck0(index, length + 4);
        try {
            int limit = index + 4 + length;
            for (int i = index + 4; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(null, this.address + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, String value, ByteOrder byteOrder) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        int bits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, CharSequence value, ByteOrder byteOrder) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        int bits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public String getStringWithoutLengthAscii(int index, int length) {
        this.boundsCheck0(index, length);
        byte[] dst = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(dst, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringWithoutLengthAscii(int index, int length, Appendable appendable) {
        this.boundsCheck0(index, length);
        try {
            int limit = index + length;
            for (int i = index; i < limit; ++i) {
                char c = (char)UnsafeAccess.UNSAFE.getByte(null, this.address + (long)i);
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value, int valueOffset, int length) {
        int len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        this.ensureCapacity(index, len);
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, CharSequence value, int valueOffset, int length) {
        int len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        this.ensureCapacity(index, len);
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(null, this.address + (long)index + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public String getStringUtf8(int index) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(null, this.address + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        this.boundsCheck0(index + 4, length);
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index + 4L, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bytes.length);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, null, this.address + (long)index + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        int bits = bytes.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, bits);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, null, this.address + (long)index + 4L, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        this.boundsCheck0(index, length);
        byte[] stringInBytes = new byte[length];
        UnsafeAccess.UNSAFE.copyMemory(null, this.address + (long)index, stringInBytes, BufferUtil.ARRAY_BASE_OFFSET, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.ensureCapacity(index, bytes.length);
        UnsafeAccess.UNSAFE.copyMemory(bytes, BufferUtil.ARRAY_BASE_OFFSET, null, this.address + (long)index, bytes.length);
        return bytes.length;
    }

    @Override
    public int parseNaturalIntAscii(int index, int length) {
        this.boundsCheck0(index, length);
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 10) {
            return this.parsePositiveIntAscii(index, length, index, index + length);
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, index, index + length);
        if (tally >= AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)tally;
    }

    @Override
    public long parseNaturalLongAscii(int index, int length) {
        this.boundsCheck0(index, length);
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        if (length < 19) {
            return this.parsePositiveLongAscii(index, length, index, index + length);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, index, index + length);
    }

    @Override
    public int parseIntAscii(int index, int length) {
        int end;
        this.boundsCheck0(index, length);
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(null, this.address + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseIntError(index, length);
            }
        }
        if ((end = index + length) - i < 10) {
            int tally = this.parsePositiveIntAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        long tally = this.parsePositiveIntAsciiOverflowCheck(index, length, i, end);
        if (tally > AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE || AsciiEncoding.INTEGER_ABSOLUTE_MIN_VALUE == tally && !negative) {
            this.throwParseIntOverflowError(index, length);
        }
        return (int)(negative ? -tally : tally);
    }

    @Override
    public long parseLongAscii(int index, int length) {
        int end;
        this.boundsCheck0(index, length);
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = 45 == UnsafeAccess.UNSAFE.getByte(null, this.address + (long)index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                this.throwParseLongError(index, length);
            }
        }
        if ((end = index + length) - i < 19) {
            long tally = this.parsePositiveLongAscii(index, length, i, end);
            return negative ? -tally : tally;
        }
        if (negative) {
            return -this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MIN_VALUE_DIGITS, i, end);
        }
        return this.parseLongAsciiOverflowCheck(index, length, AsciiEncoding.LONG_MAX_VALUE_DIGITS, i, end);
    }

    @Override
    public void putInt(int index, int value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putInt(null, this.address + (long)index, value);
    }

    @Override
    public int putIntAscii(int index, int value) {
        long offset;
        int length;
        int digitCount;
        if (0 == value) {
            this.putByte0(index, (byte)48);
            return 1;
        }
        int quotient = value;
        if (value < 0) {
            if (Integer.MIN_VALUE == value) {
                this.putBytes(index, AsciiEncoding.MIN_INTEGER_VALUE);
                return AsciiEncoding.MIN_INTEGER_VALUE.length;
            }
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            this.ensureCapacity(index, length);
            offset = this.address + (long)index;
            UnsafeAccess.UNSAFE.putByte(null, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            this.ensureCapacity(index, length);
            offset = this.address + (long)index;
        }
        ExpandableDirectByteBuffer.putPositiveIntAscii(offset, quotient, digitCount);
        return length;
    }

    @Override
    public int putNaturalIntAscii(int index, int value) {
        if (0 == value) {
            this.putByte0(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        this.ensureCapacity(index, digitCount);
        ExpandableDirectByteBuffer.putPositiveIntAscii(this.address + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public void putNaturalPaddedIntAscii(int offset, int length, int value) {
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            this.putByte0(index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new NumberFormatException("Cannot write " + value + " in " + length + " bytes");
        }
    }

    @Override
    public int putNaturalIntAsciiFromEnd(int value, int endExclusive) {
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            this.putByte0(--index, (byte)(48 + digit));
        }
        return index;
    }

    @Override
    public int putNaturalLongAscii(int index, long value) {
        if (0L == value) {
            this.putByte0(index, (byte)48);
            return 1;
        }
        int digitCount = AsciiEncoding.digitCount(value);
        this.ensureCapacity(index, digitCount);
        ExpandableDirectByteBuffer.putPositiveLongAscii(this.address + (long)index, value, digitCount);
        return digitCount;
    }

    @Override
    public int putLongAscii(int index, long value) {
        long offset;
        int length;
        int digitCount;
        if (0L == value) {
            this.putByte0(index, (byte)48);
            return 1;
        }
        long quotient = value;
        if (value < 0L) {
            if (Long.MIN_VALUE == value) {
                this.putBytes(index, AsciiEncoding.MIN_LONG_VALUE);
                return AsciiEncoding.MIN_LONG_VALUE.length;
            }
            quotient = -quotient;
            digitCount = AsciiEncoding.digitCount(quotient);
            length = digitCount + 1;
            this.ensureCapacity(index, length);
            offset = this.address + (long)index;
            UnsafeAccess.UNSAFE.putByte(null, offset, (byte)45);
            ++offset;
        } else {
            length = digitCount = AsciiEncoding.digitCount(quotient);
            this.ensureCapacity(index, length);
            offset = this.address + (long)index;
        }
        ExpandableDirectByteBuffer.putPositiveLongAscii(offset, quotient, digitCount);
        return length;
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpandableDirectByteBuffer that = (ExpandableDirectByteBuffer)obj;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int hashCode = 1;
        long address = this.address;
        int length = this.capacity;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + UnsafeAccess.UNSAFE.getByte(null, address + (long)i);
        }
        return hashCode;
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int thisCapacity = this.capacity();
        int thatCapacity = that.capacity();
        byte[] thatByteArray = that.byteArray();
        long thisOffset = this.addressOffset();
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        for (int i = 0; i < length; ++i) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(null, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        if (thisCapacity != thatCapacity) {
            return thisCapacity - thatCapacity;
        }
        return 0;
    }

    public String toString() {
        return "ExpandableDirectByteBuffer{address=" + this.address + ", capacity=" + this.capacity + ", byteBuffer=" + this.byteBuffer + '}';
    }

    private void ensureCapacity(int index, int length) {
        if (index < 0 || length < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        long resultingPosition = (long)index + (long)length;
        int currentCapacity = this.capacity;
        if (resultingPosition > (long)currentCapacity) {
            if (resultingPosition > 0x40000000L) {
                throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " maxCapacity=" + 0x40000000);
            }
            int newCapacity = this.calculateExpansion(currentCapacity, resultingPosition);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            this.getBytes(0, newBuffer, 0, this.capacity);
            this.address = BufferUtil.address(newBuffer);
            this.capacity = newCapacity;
            this.byteBuffer = newBuffer;
        }
    }

    private int calculateExpansion(int currentLength, long requiredLength) {
        long value = Math.max(currentLength, 128);
        while (value < requiredLength) {
            if ((value += value >> 1) <= 0x40000000L) continue;
            value = 0x40000000L;
        }
        return (int)value;
    }

    private void boundsCheck0(int index, int length) {
        int currentCapacity = this.capacity;
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || length < 0 || resultingPosition > (long)currentCapacity) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + currentCapacity);
        }
    }

    private int parsePositiveIntAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long offset = this.address;
        int i = startIndex;
        int tally = 0;
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(null, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(null, offset + (long)i))) {
            tally = tally * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private long parsePositiveIntAsciiOverflowCheck(int index, int length, int startIndex, int end) {
        if (end - startIndex > 10) {
            this.throwParseIntOverflowError(index, length);
        }
        long offset = this.address;
        int i = startIndex;
        long tally = 0L;
        long octet = UnsafeAccess.UNSAFE.getLong(null, offset + (long)i);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(octet)) {
            byte digit;
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
            while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(null, offset + (long)i))) {
                tally = tally * 10L + (long)(digit - 48);
                ++i;
            }
        }
        if (i != end) {
            this.throwParseIntError(index, length);
        }
        return tally;
    }

    private void throwParseIntError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing int: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseIntOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("int overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private long parsePositiveLongAscii(int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long octet;
        long offset = this.address;
        int i = startIndex;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(null, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            tally = tally * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
        }
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = UnsafeAccess.UNSAFE.getInt(null, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                quartet = Integer.reverseBytes(quartet);
            }
            tally = tally * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(null, offset + (long)i))) {
            tally = tally * 10L + (long)(digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        }
        return tally;
    }

    private long parseLongAsciiOverflowCheck(int index, int length, int[] maxValue, int startIndex, int end) {
        byte digit;
        long octet;
        if (end - startIndex > 19) {
            this.throwParseLongOverflowError(index, length);
        }
        long offset = this.address;
        int i = startIndex;
        int k = 0;
        boolean checkOverflow = true;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = UnsafeAccess.UNSAFE.getLong(null, offset + (long)i))) {
            if (BufferUtil.NATIVE_BYTE_ORDER != ByteOrder.LITTLE_ENDIAN) {
                octet = Long.reverseBytes(octet);
            }
            int eightDigits = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            if (checkOverflow) {
                if (eightDigits > maxValue[k]) {
                    this.throwParseLongOverflowError(index, length);
                } else if (eightDigits < maxValue[k]) {
                    checkOverflow = false;
                }
                ++k;
            }
            tally = tally * 100000000L + (long)eightDigits;
            i += 8;
        }
        int lastDigits = 0;
        while (i < end && AsciiEncoding.isDigit(digit = UnsafeAccess.UNSAFE.getByte(null, offset + (long)i))) {
            lastDigits = lastDigits * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            this.throwParseLongError(index, length);
        } else if (checkOverflow && lastDigits > maxValue[k]) {
            this.throwParseLongOverflowError(index, length);
        }
        return tally * 1000L + (long)lastDigits;
    }

    private void throwParseLongError(int index, int length) {
        throw new AsciiNumberFormatException("error parsing long: " + this.getStringWithoutLengthAscii(index, length));
    }

    private void throwParseLongOverflowError(int index, int length) {
        throw new AsciiNumberFormatException("long overflow parsing: " + this.getStringWithoutLengthAscii(index, length));
    }

    private static void putPositiveIntAscii(long offset, int value, int digitCount) {
        int position;
        int quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 10000; quotient /= 10000) {
            int lastFourDigits = quotient % 10000;
            int p1 = lastFourDigits / 100 << 1;
            int p2 = lastFourDigits % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)(i -= 4), AsciiEncoding.ASCII_DIGITS[p1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[p1 + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[p2]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[p2 + 1]);
        }
        if (quotient >= 100) {
            position = quotient % 100 << 1;
            quotient /= 100;
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i - 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i - 2L, AsciiEncoding.ASCII_DIGITS[position]);
        }
        if (quotient >= 10) {
            position = quotient << 1;
            UnsafeAccess.UNSAFE.putByte(null, offset + 1L, AsciiEncoding.ASCII_DIGITS[position + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset, AsciiEncoding.ASCII_DIGITS[position]);
        } else {
            UnsafeAccess.UNSAFE.putByte(null, offset, (byte)(48 + quotient));
        }
    }

    private static void putPositiveLongAscii(long offset, long value, int digitCount) {
        long quotient;
        int i = digitCount;
        for (quotient = value; quotient >= 100000000L; quotient /= 100000000L) {
            int lastEightDigits = (int)(quotient % 100000000L);
            int upperPart = lastEightDigits / 10000;
            int lowerPart = lastEightDigits % 10000;
            int u1 = upperPart / 100 << 1;
            int u2 = upperPart % 100 << 1;
            int l1 = lowerPart / 100 << 1;
            int l2 = lowerPart % 100 << 1;
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)(i -= 8), AsciiEncoding.ASCII_DIGITS[u1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 1L, AsciiEncoding.ASCII_DIGITS[u1 + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 2L, AsciiEncoding.ASCII_DIGITS[u2]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 3L, AsciiEncoding.ASCII_DIGITS[u2 + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 4L, AsciiEncoding.ASCII_DIGITS[l1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 5L, AsciiEncoding.ASCII_DIGITS[l1 + 1]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 6L, AsciiEncoding.ASCII_DIGITS[l2]);
            UnsafeAccess.UNSAFE.putByte(null, offset + (long)i + 7L, AsciiEncoding.ASCII_DIGITS[l2 + 1]);
        }
        ExpandableDirectByteBuffer.putPositiveIntAscii(offset, (int)quotient, i);
    }
}

