/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.options;

import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.documentation.options.AbstractOption;

public class CLIOption
extends AbstractOption {
    public static String createName(Option option) {
        return StringUtils.defaultIfBlank(option.getLongOpt(), option.getOpt());
    }

    public CLIOption(Option option) {
        super(option, CLIOption.createName(option));
    }

    @Override
    public String getText() {
        StringBuilder result = new StringBuilder();
        if (this.option.getLongOpt() != null) {
            result.append("--").append(this.option.getLongOpt());
            if (this.option.getOpt() != null) {
                result.append(" or -").append(this.option.getArgs());
            }
        } else {
            result.append("-").append(this.option.getArgs());
        }
        return result.toString();
    }

    @Override
    protected String cleanupName(Option option) {
        return CLIOption.createName(option);
    }

    @Override
    public String getExample() {
        StringBuilder sb = new StringBuilder("-");
        if (this.option.getLongOpt() != null) {
            sb.append("-").append(this.option.getLongOpt());
        } else {
            sb.append(this.option.getOpt());
        }
        if (this.option.hasArg()) {
            String argName = StringUtils.defaultIfBlank(this.option.getArgName(), "Arg");
            sb.append(" ").append(argName);
            if (this.option.hasArgs()) {
                sb.append(" [").append(argName).append("2 [").append(argName).append("3 [...]]] --");
            }
        }
        return sb.toString();
    }
}

