/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cli.debugger;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.daffodil.api.debugger.DaffodilDebuggerRunner;
import org.apache.daffodil.cli.debugger.CLIDebuggerCompleter;
import org.apache.daffodil.cli.debugger.CLIDebuggerRunner$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.DumbTerminal;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CLIDebuggerRunner
implements DaffodilDebuggerRunner {
    private final Iterator<String> cmdsIter;
    private final InputStream in;
    private final PrintStream out;
    private final String prompt;
    private Option reader;

    public static InputStream $lessinit$greater$default$1() {
        return CLIDebuggerRunner$.MODULE$.$lessinit$greater$default$1();
    }

    public static PrintStream $lessinit$greater$default$2() {
        return CLIDebuggerRunner$.MODULE$.$lessinit$greater$default$2();
    }

    public CLIDebuggerRunner(Iterator<String> cmdsIter, InputStream in, PrintStream out) {
        this.cmdsIter = cmdsIter;
        this.in = in;
        this.out = out;
        this.prompt = "(debug) ";
        this.reader = None$.MODULE$;
    }

    public CLIDebuggerRunner(InputStream in, PrintStream out) {
        this((Iterator<String>)package$.MODULE$.Iterator().empty(), in, out);
    }

    public CLIDebuggerRunner(File file, InputStream in, PrintStream out) {
        this((Iterator<String>)Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).getLines(), in, out);
    }

    public CLIDebuggerRunner(Seq<String> seq, InputStream in, PrintStream out) {
        this((Iterator<String>)seq.iterator(), in, out);
    }

    public Option<LineReader> reader() {
        return this.reader;
    }

    public void reader_$eq(Option<LineReader> x$1) {
        this.reader = x$1;
    }

    public void init() {
        throw new IllegalArgumentException("Must pass in InteractiveDebugger to the init function for CLIDebuggerRunner");
    }

    public void init(DaffodilDebugger id) {
        DumbTerminal terminal = this.in != System.in || this.out != System.out ? new DumbTerminal(this.in, (OutputStream)this.out) : TerminalBuilder.builder().build();
        CLIDebuggerCompleter completer = new CLIDebuggerCompleter(id);
        LineReader r = LineReaderBuilder.builder().terminal((Terminal)terminal).completer((Completer)completer).build();
        this.reader_$eq((Option<LineReader>)Some$.MODULE$.apply((Object)r));
    }

    public void fini() {
        this.reader().map((Function1)(JProcedure1 & Serializable)_$1 -> _$1.getTerminal().close());
        this.reader_$eq((Option<LineReader>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public String getCommand() {
        String string;
        if (this.cmdsIter.hasNext()) {
            String line = (String)this.cmdsIter.next();
            if (line.length() > 0) {
                ((LineReader)this.reader().get()).getHistory().add(line);
            }
            this.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.prompt, line})));
            string = line;
        } else {
            void var3_2;
            String string2;
            try {
                string2 = ((LineReader)this.reader().get()).readLine(this.prompt);
            }
            catch (UserInterruptException userInterruptException) {
                string2 = "quit";
            }
            catch (EndOfFileException endOfFileException) {
                string2 = "quit";
            }
            String line = string2;
            string = var3_2;
        }
        void cmd = string;
        return cmd.trim();
    }

    public void lineOutput(String line) {
        this.out.println("  " + line);
    }
}

