/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.messages;

public enum ModeType {
    RESERVED(0, "Reserved mode."),
    SYMMETRIC_ACTIVE(1, "Symmetric active mode."),
    RESERVED_PASSIVE(2, "Symmetric passive mode."),
    CLIENT(3, "Client mode."),
    SERVER(4, "Server mode."),
    BROADCAST(5, "Broadcast mode."),
    RESERVED_FOR_NTP_CONTROL(6, "Reserved for NTP control message."),
    RESERVED_FOR_PRIVATE_USE(7, "Reserved for private use.");

    private String name;
    private int ordinal;

    private ModeType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static ModeType getTypeByOrdinal(int type) {
        for (ModeType mt : ModeType.values()) {
            if (type != mt.getOrdinal()) continue;
            return mt;
        }
        return SERVER;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }
}

