/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import java.lang.reflect.Array;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemLogger {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.felix.http");

    public static String formatMessage(ServiceReference<?> ref, String message) {
        if (ref == null) {
            return message;
        }
        Bundle bundle = ref.getBundle();
        StringBuilder ib = new StringBuilder();
        ib.append("[ServiceReference ");
        ib.append(String.valueOf(ref.getProperty("service.id")));
        ib.append(" from bundle ");
        if (bundle == null) {
            ib.append("<uninstalled>");
        } else {
            ib.append(bundle.getBundleId());
            if (bundle.getSymbolicName() != null) {
                ib.append(" : ");
                ib.append(bundle.getSymbolicName());
                ib.append(":");
                ib.append(bundle.getVersion());
            }
        }
        ib.append(" ref=");
        ib.append(ref);
        ib.append(" properties={");
        boolean first = true;
        for (String name : ref.getPropertyKeys()) {
            if (first) {
                first = false;
            } else {
                ib.append(", ");
            }
            Object val = ref.getProperty(name);
            ib.append(name);
            ib.append("=");
            if (val.getClass().isArray()) {
                boolean fa = true;
                ib.append('[');
                for (int i = 0; i < Array.getLength(val); ++i) {
                    if (fa) {
                        fa = false;
                    } else {
                        ib.append(", ");
                    }
                    ib.append(Array.get(val, i));
                }
                ib.append(']');
                continue;
            }
            ib.append(val);
        }
        ib.append("}] ");
        ib.append(message);
        return ib.toString();
    }
}

