/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjarharmonybeans.BeansUtils;
import groovyjarjarharmonybeans.internal.nls.Messages;
import groovyjarjaropenbeans.Encoder;
import groovyjarjaropenbeans.Expression;
import groovyjarjaropenbeans.Statement;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class XMLEncoder
extends Encoder {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static int DEADLOCK_THRESHOLD = 7;
    private static final int INDENT_UNIT = 1;
    private static final boolean isStaticConstantsSupported = true;
    private ArrayList<Object> flushPending = new ArrayList();
    private ArrayList<Object> flushPendingStat = new ArrayList();
    private ArrayList<Object> flushPrePending = new ArrayList();
    private boolean hasXmlHeader = false;
    private boolean needOwner = false;
    private PrintWriter out;
    private Object owner = null;
    private IdentityHashMap<Object, Record> objRecordMap = new IdentityHashMap();
    private IdentityHashMap<Class<?>, Integer> clazzCounterMap = new IdentityHashMap();
    private IdentityHashMap<Object, ArrayList<Object>> objPrePendingCache = new IdentityHashMap();
    private boolean writingObject = false;

    public XMLEncoder(OutputStream out) {
        if (null != out) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(out, DEFAULT_ENCODING), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.flush();
        this.out.println("</java> ");
        this.out.close();
    }

    private StringBuffer decapitalize(String s) {
        StringBuffer buf = new StringBuffer(s);
        buf.setCharAt(0, Character.toLowerCase(buf.charAt(0)));
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        XMLEncoder xMLEncoder = this;
        synchronized (xMLEncoder) {
            if (!this.hasXmlHeader) {
                this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?> ");
                this.out.println("<java version=\"" + System.getProperty("java.version") + "\" class=\"com.googlecode.openbeans.XMLDecoder\"> ");
                this.hasXmlHeader = true;
            }
            for (Object o : this.flushPending) {
                Record rec = this.objRecordMap.get(o);
                if (rec == null) continue;
                this.preprocess(o, rec);
            }
            Iterator<Object> iter = this.flushPending.iterator();
            while (iter.hasNext()) {
                Object o;
                o = iter.next();
                this.flushObject(o, 1);
                iter.remove();
            }
            this.objRecordMap.clear();
            this.flushPendingStat.clear();
            this.objPrePendingCache.clear();
            this.clazzCounterMap.clear();
            super.clear();
        }
    }

    private void flushBasicObject(Object obj, int indent) {
        if (obj instanceof Proxy) {
            return;
        }
        this.flushIndent(indent);
        if (obj == null) {
            this.out.println("<null /> ");
        } else if (obj instanceof String) {
            Record rec = this.objRecordMap.get(obj);
            if (null != rec) {
                this.flushExpression(obj, rec, indent - 3, this.flushPendingStat.contains(obj));
                return;
            }
            this.out.print("<string>");
            this.flushString((String)obj);
            this.out.println("</string> ");
        } else if (obj instanceof Class) {
            this.out.println("<class>" + ((Class)obj).getName() + "</class> ");
        } else if (obj instanceof Boolean) {
            this.out.println("<boolean>" + obj + "</boolean> ");
        } else if (obj instanceof Byte) {
            this.out.println("<byte>" + obj + "</byte> ");
        } else if (obj instanceof Character) {
            char objChar = ((Character)obj).charValue();
            if (this.invalidCharacter(objChar)) {
                this.out.println("<char code=\"#" + Integer.toString(objChar, 16) + "\"/>");
            } else {
                this.out.println("<char>" + objChar + "</char> ");
            }
        } else if (obj instanceof Double) {
            this.out.println("<double>" + obj + "</double> ");
        } else if (obj instanceof Float) {
            this.out.println("<float>" + obj + "</float> ");
        } else if (obj instanceof Integer) {
            this.out.println("<int>" + obj + "</int> ");
        } else if (obj instanceof Long) {
            this.out.println("<long>" + obj + "</long> ");
        } else if (obj instanceof Short) {
            this.out.println("<short>" + obj + "</short> ");
        } else {
            this.getExceptionListener().exceptionThrown(new Exception(Messages.getString("beans.73", obj)));
        }
    }

    private boolean invalidCharacter(char c) {
        return '\u0000' <= c && c < '\t' || '\n' < c && c < '\r' || '\r' < c && c < ' ' || '\ud7ff' < c && c < '\ue000' || c == '\ufffe';
    }

    private void flushExpression(Object obj, Record rec, int indent, boolean asStatement) {
        Statement stat;
        Statement statement = stat = asStatement ? new Statement(rec.exp.getTarget(), rec.exp.getMethodName(), rec.exp.getArguments()) : rec.exp;
        if ("getField".equals(stat.getMethodName())) {
            this.flushStatField(stat, indent);
            return;
        }
        if (rec.id != null) {
            this.flushIndent(indent);
            this.out.print("<object idref=\"");
            this.out.print(rec.id);
            this.out.println("\"/> ");
            return;
        }
        if (rec.refCount > 1 && rec.id == null) {
            rec.id = this.idSerialNoOfObject(obj);
        }
        this.flushStatement(stat, rec.id, rec.stats, indent);
    }

    private void flushIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.out.print(' ');
        }
    }

    private void flushObject(Object obj, int indent) {
        Record rec = this.objRecordMap.get(obj);
        if (rec == null && !this.isBasicType(obj)) {
            return;
        }
        if (obj == this.owner && this.needOwner) {
            this.flushOwner(obj, rec, indent);
            this.needOwner = false;
            return;
        }
        if (this.isBasicType(obj)) {
            this.flushBasicObject(obj, indent);
        } else {
            this.flushExpression(obj, rec, indent, this.flushPendingStat.contains(obj));
        }
    }

    private void flushOwner(Object obj, Record rec, int indent) {
        if (rec.refCount > 1 && rec.id == null) {
            rec.id = this.idSerialNoOfObject(obj);
        }
        this.flushIndent(indent);
        String tagName = "void";
        this.out.print("<");
        this.out.print(tagName);
        if (rec.id != null) {
            this.out.print(" id=\"");
            this.out.print(rec.id);
            this.out.print("\"");
        }
        this.out.print(" property=\"owner\"");
        if (rec.exp.getArguments().length == 0 && rec.stats.isEmpty()) {
            this.out.println("/> ");
            return;
        }
        this.out.println("> ");
        for (int i = 0; i < rec.exp.getArguments().length; ++i) {
            this.flushObject(rec.exp.getArguments()[i], indent + 1);
        }
        this.flushSubStatements(rec.stats, indent);
        this.flushIndent(indent);
        this.out.print("</");
        this.out.print(tagName);
        this.out.println("> ");
    }

    private void flushStatArray(Statement stat, String id, List<?> subStats, int indent) {
        this.flushIndent(indent);
        this.out.print("<array");
        if (id != null) {
            this.out.print(" id=\"");
            this.out.print(id);
            this.out.print("\"");
        }
        this.out.print(" class=\"");
        this.out.print(((Class)stat.getArguments()[0]).getName());
        this.out.print("\" length=\"");
        this.out.print(stat.getArguments()[1]);
        this.out.print("\"");
        if (subStats.isEmpty()) {
            this.out.println("/> ");
            return;
        }
        this.out.println("> ");
        this.flushSubStatements(subStats, indent);
        this.flushIndent(indent);
        this.out.println("</array> ");
    }

    private void flushStatCommon(Statement stat, String id, List<?> subStats, int indent) {
        this.flushIndent(indent);
        String tagName = stat instanceof Expression ? "object" : "void";
        this.out.print("<");
        this.out.print(tagName);
        if (id != null) {
            this.out.print(" id=\"");
            this.out.print(id);
            this.out.print("\"");
        }
        if (stat.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)stat.getTarget()).getName());
            this.out.print("\"");
        }
        if (!"new".equals(stat.getMethodName())) {
            this.out.print(" method=\"");
            this.out.print(stat.getMethodName());
            this.out.print("\"");
        }
        if (stat.getArguments().length == 0 && subStats.isEmpty()) {
            this.out.println("/> ");
            return;
        }
        this.out.println("> ");
        for (int i = 0; i < stat.getArguments().length; ++i) {
            this.flushObject(stat.getArguments()[i], indent + 1);
        }
        this.flushSubStatements(subStats, indent);
        this.flushIndent(indent);
        this.out.print("</");
        this.out.print(tagName);
        this.out.println("> ");
    }

    private void flushStatement(Statement stat, String id, List<?> subStats, int indent) {
        Object target = stat.getTarget();
        String method = stat.getMethodName();
        Object[] args = stat.getArguments();
        if (Array.class == target && "newInstance".equals(method)) {
            this.flushStatArray(stat, id, subStats, indent);
            return;
        }
        if (this.isGetArrayStat(target, method, args) || this.isSetArrayStat(target, method, args)) {
            this.flushStatIndexed(stat, id, subStats, indent);
            return;
        }
        if (this.isGetPropertyStat(method, args) || this.isSetPropertyStat(method, args)) {
            this.flushStatGetterSetter(stat, id, subStats, indent);
            return;
        }
        if ("getField".equals(stat.getMethodName())) {
            this.flushStatField(stat, indent);
            return;
        }
        this.flushStatCommon(stat, id, subStats, indent);
    }

    private void flushStatField(Statement stat, int indent) {
        this.flushIndent(indent);
        this.out.print("<object");
        Object target = stat.getTarget();
        if (target instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)target).getName());
            this.out.print("\"");
        }
        Field field = null;
        if (target instanceof Class && stat.getArguments().length == 1 && stat.getArguments()[0] instanceof String) {
            try {
                field = ((Class)target).getField((String)stat.getArguments()[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (field != null && Modifier.isStatic(field.getModifiers())) {
            this.out.print(" field=\"");
            this.out.print(stat.getArguments()[0]);
            this.out.print("\"");
            this.out.println("/> ");
        } else {
            this.out.print(" method=\"");
            this.out.print(stat.getMethodName());
            this.out.print("\"");
            this.out.println("> ");
            this.flushObject(stat.getArguments()[0], indent + 1);
            this.flushIndent(indent);
            this.out.println("</object> ");
        }
    }

    private void flushStatGetterSetter(Statement stat, String id, List<?> subStats, int indent) {
        this.flushIndent(indent);
        String tagName = "void";
        this.out.print("<");
        this.out.print(tagName);
        if (id != null) {
            this.out.print(" id=\"");
            this.out.print(id);
            this.out.print("\"");
        }
        if (stat.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)stat.getTarget()).getName());
            this.out.print("\"");
        }
        this.out.print(" property=\"");
        this.out.print(this.decapitalize(stat.getMethodName().substring(3)));
        this.out.print("\"");
        if (stat.getArguments().length == 0 && subStats.isEmpty()) {
            this.out.println("/> ");
            return;
        }
        this.out.println("> ");
        for (int i = 0; i < stat.getArguments().length; ++i) {
            this.flushObject(stat.getArguments()[i], indent + 1);
        }
        this.flushSubStatements(subStats, indent);
        this.flushIndent(indent);
        this.out.print("</");
        this.out.print(tagName);
        this.out.println("> ");
    }

    private void flushStatIndexed(Statement stat, String id, List<?> subStats, int indent) {
        this.flushIndent(indent);
        String tagName = stat instanceof Expression ? "object" : "void";
        this.out.print("<");
        this.out.print(tagName);
        if (id != null) {
            this.out.print(" id=\"");
            this.out.print(id);
            this.out.print("\"");
        }
        if (stat.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)stat.getTarget()).getName());
            this.out.print("\"");
        }
        this.out.print(" index=\"");
        this.out.print(stat.getArguments()[0]);
        this.out.print("\"");
        if (stat.getArguments().length == 1 && subStats.isEmpty()) {
            this.out.println("/> ");
            return;
        }
        this.out.println("> ");
        for (int i = 1; i < stat.getArguments().length; ++i) {
            this.flushObject(stat.getArguments()[i], indent + 1);
        }
        this.flushSubStatements(subStats, indent);
        this.flushIndent(indent);
        this.out.print("</");
        this.out.print(tagName);
        this.out.println("> ");
    }

    private void flushString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            if (c == '>') {
                this.out.print("&gt;");
                continue;
            }
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '\'') {
                this.out.print("&apos;");
                continue;
            }
            if (c == '\"') {
                this.out.print("&quot;");
                continue;
            }
            if (this.invalidCharacter(c)) {
                this.out.print("<char code=\"#" + Integer.toString(c, 16) + "\"/>");
                continue;
            }
            this.out.print(c);
        }
    }

    private void flushSubStatements(List<?> subStats, int indent) {
        for (int i = 0; i < subStats.size(); ++i) {
            Statement subStat = (Statement)subStats.get(i);
            try {
                if (subStat.getClass() == Expression.class) {
                    Expression subExp = (Expression)subStat;
                    Object obj = subExp.getValue();
                    Record rec = this.objRecordMap.get(obj);
                    this.flushExpression(obj, rec, indent + 1, true);
                    continue;
                }
                this.flushStatement(subStat, null, Collections.EMPTY_LIST, indent + 1);
                continue;
            }
            catch (Exception e) {
                this.getExceptionListener().exceptionThrown(e);
            }
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    private boolean isBasicType(Object value) {
        return value == null || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Class || value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof String || value instanceof Proxy;
    }

    private boolean isGetArrayStat(Object target, String method, Object[] args) {
        return "get".equals(method) && args.length == 1 && args[0] instanceof Integer && target.getClass().isArray();
    }

    private boolean isGetPropertyStat(String method, Object[] args) {
        return method.startsWith("get") && method.length() > 3 && args.length == 0;
    }

    private boolean isSetArrayStat(Object target, String method, Object[] args) {
        return "set".equals(method) && args.length == 2 && args[0] instanceof Integer && target.getClass().isArray();
    }

    private boolean isSetPropertyStat(String method, Object[] args) {
        return method.startsWith("set") && method.length() > 3 && args.length == 1;
    }

    private String idSerialNoOfObject(Object obj) {
        Class<?> clazz = obj.getClass();
        Integer serialNo = this.clazzCounterMap.get(clazz);
        serialNo = serialNo == null ? 0 : serialNo;
        String id = BeansUtils.idOfClass(obj.getClass()) + serialNo;
        serialNo = serialNo + 1;
        this.clazzCounterMap.put(clazz, serialNo);
        return id;
    }

    private void preprocess(Object obj, Record rec) {
        if (this.writingObject && this.isBasicType(obj)) {
            return;
        }
        if (obj instanceof Class) {
            return;
        }
        ++rec.refCount;
        if (rec.refCount > 1) {
            return;
        }
        if (null != rec.exp) {
            Record targetRec = this.objRecordMap.get(rec.exp.getTarget());
            if (targetRec != null && targetRec.exp != null && "getField".equals(targetRec.exp.getMethodName())) {
                this.objRecordMap.remove(obj);
            }
            Object[] args = rec.exp.getArguments();
            for (int i = 0; i < args.length; ++i) {
                Record argRec = this.objRecordMap.get(args[i]);
                if (argRec == null) continue;
                this.preprocess(args[i], argRec);
            }
        }
        Iterator<Statement> iter = rec.stats.iterator();
        while (iter.hasNext()) {
            Statement subStat = iter.next();
            if (subStat.getClass() == Expression.class) {
                try {
                    Expression subExp = (Expression)subStat;
                    Record subRec = this.objRecordMap.get(subExp.getValue());
                    if (subRec == null || subRec.exp == null || subRec.exp != subExp) {
                        iter.remove();
                        continue;
                    }
                    this.preprocess(subExp.getValue(), subRec);
                    if (!subRec.stats.isEmpty() || !this.isGetArrayStat(subExp.getTarget(), subExp.getMethodName(), subExp.getArguments()) && !this.isGetPropertyStat(subExp.getMethodName(), subExp.getArguments())) continue;
                    iter.remove();
                }
                catch (Exception e) {
                    this.getExceptionListener().exceptionThrown(e);
                    iter.remove();
                }
                continue;
            }
            Object[] subStatArgs = subStat.getArguments();
            for (int i = 0; i < subStatArgs.length; ++i) {
                Record argRec = this.objRecordMap.get(subStatArgs[i]);
                if (argRec == null) continue;
                this.preprocess(subStatArgs[i], argRec);
            }
        }
    }

    private void recordExpression(Object value, Expression exp) {
        Record rec = this.objRecordMap.get(value);
        if (rec == null) {
            rec = new Record();
            this.objRecordMap.put(value, rec);
        }
        if (rec.exp == null) {
            for (Statement statement : rec.stats) {
                if (statement.getClass() != Expression.class) continue;
                this.flushPrePending.add(value);
            }
        }
        rec.exp = exp;
        if (value == this.owner && this.owner != null) {
            this.needOwner = true;
        }
        this.recordStatement(exp);
    }

    private void recordStatement(Statement stat) {
        Object[] args;
        Record rec;
        if (null == stat) {
            return;
        }
        Object target = stat.getTarget();
        if (target == this.owner && this.owner != null) {
            this.needOwner = true;
        }
        if ((rec = this.objRecordMap.get(target)) == null) {
            rec = new Record();
            this.objRecordMap.put(target, rec);
        }
        boolean hasRecord = false;
        String methodName = stat.getMethodName();
        if (this.isSetPropertyStat(methodName, args = stat.getArguments()) || this.isSetArrayStat(target, methodName, args)) {
            for (Statement subStat : rec.stats) {
                Object[] subArgs;
                if (target != subStat.getTarget() || !methodName.equals(subStat.getMethodName()) || args.length != (subArgs = subStat.getArguments()).length) continue;
                boolean equals = true;
                for (int index = 0; index < args.length; ++index) {
                    if (this.getPersistenceDelegate(args[index].getClass()).mutatesTo(args[index], subArgs[index])) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                hasRecord = true;
                break;
            }
        }
        if (!hasRecord) {
            rec.stats.add(stat);
        }
    }

    private boolean checkDeadLoop(Object value) {
        Record rec;
        int n = 0;
        Object obj = value;
        while (obj != null && (rec = this.objRecordMap.get(obj)) != null && rec.exp != null) {
            obj = rec.exp.getTarget();
            if (obj == null || !obj.getClass().isAssignableFrom(value.getClass()) || !obj.equals(value) || ++n < DEADLOCK_THRESHOLD) continue;
            return true;
        }
        return false;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public void writeExpression(Expression oldExp) {
        if (null == oldExp) {
            throw new NullPointerException();
        }
        boolean oldWritingObject = this.writingObject;
        this.writingObject = true;
        Object oldValue = this.expressionValue(oldExp);
        if (oldValue == null || this.get(oldValue) != null && (oldWritingObject || oldValue.getClass() != String.class)) {
            return;
        }
        if (!this.isBasicType(oldValue) || !oldWritingObject && oldValue.getClass() == String.class) {
            this.recordExpression(oldValue, oldExp);
        }
        if (this.checkDeadLoop(oldValue)) {
            return;
        }
        super.writeExpression(oldExp);
        this.writingObject = oldWritingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object o) {
        XMLEncoder xMLEncoder = this;
        synchronized (xMLEncoder) {
            ArrayList<Object> prePending = this.objPrePendingCache.get(o);
            if (prePending == null) {
                boolean oldWritingObject = this.writingObject;
                this.writingObject = true;
                try {
                    super.writeObject(o);
                }
                finally {
                    this.writingObject = oldWritingObject;
                }
            } else {
                this.flushPrePending.clear();
                this.flushPrePending.addAll(prePending);
            }
            if (!this.writingObject) {
                boolean isNotCached;
                boolean bl = isNotCached = prePending == null;
                if (isNotCached && o != null) {
                    prePending = new ArrayList();
                    prePending.addAll(this.flushPrePending);
                    this.objPrePendingCache.put(o, prePending);
                }
                this.flushPending.addAll(this.flushPrePending);
                this.flushPendingStat.addAll(this.flushPrePending);
                this.flushPrePending.clear();
                if (isNotCached && this.flushPending.contains(o)) {
                    this.flushPendingStat.remove(o);
                } else {
                    this.flushPending.add(o);
                }
                if (this.needOwner) {
                    this.flushPending.remove(this.owner);
                    this.flushPending.add(0, this.owner);
                }
            }
        }
    }

    @Override
    public void writeStatement(Statement oldStat) {
        if (null == oldStat) {
            System.err.println("java.lang.Exception: XMLEncoder: discarding statement null");
            System.err.println("Continuing...");
            return;
        }
        this.recordStatement(oldStat);
        super.writeStatement(oldStat);
    }

    private static class Record {
        Expression exp = null;
        String id = null;
        int refCount = 0;
        ArrayList<Statement> stats = new ArrayList();

        private Record() {
        }
    }
}

