/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.NHttpMessageParserFactory;
import org.apache.hc.core5.http.nio.NHttpMessageWriterFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.HttpTestServer;
import org.apache.hc.core5.testing.nio.InternalServerHttp1EventHandlerFactory;

public class Http1TestServer
extends HttpTestServer {
    private Http1Config http1Config;
    private NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;

    public Http1TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig, sslContext, sslSessionInitializer, sslSessionVerifier);
    }

    public Http1TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void configure(Http1Config http1Config) {
        this.ensureNotRunning();
        this.http1Config = http1Config;
    }

    public void configure(NHttpMessageParserFactory<HttpRequest> requestParserFactory) {
        this.ensureNotRunning();
        this.requestParserFactory = requestParserFactory;
    }

    public void configure(NHttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
        this.ensureNotRunning();
        this.responseWriterFactory = responseWriterFactory;
    }

    @Deprecated
    public InetSocketAddress start(IOEventHandlerFactory handlerFactory) throws Exception {
        return this.startExecution(handlerFactory);
    }

    @Deprecated
    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, Http1Config http1Config) throws Exception {
        this.configure(http1Config);
        this.configure(exchangeHandlerDecorator);
        this.configure(httpProcessor);
        return this.start();
    }

    @Deprecated
    public InetSocketAddress start(HttpProcessor httpProcessor, Http1Config http1Config) throws Exception {
        this.configure(http1Config);
        this.configure(httpProcessor);
        return this.start();
    }

    @Override
    public InetSocketAddress start() throws Exception {
        return this.startExecution(new InternalServerHttp1EventHandlerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, (List)this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null), this.exchangeHandlerDecorator != null ? this.exchangeHandlerDecorator : BasicAsyncServerExpectationDecorator::new), this.http1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.requestParserFactory, this.responseWriterFactory, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }
}

