/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.util.Locale;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class EchoHandler
implements HttpRequestHandler {
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        ContentType contentType;
        byte[] data;
        String method = request.getMethod().toUpperCase(Locale.ROOT);
        if (!("GET".equals(method) || "HEAD".equals(method) || "POST".equals(method) || "PUT".equals(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        HttpEntity entity = request.getEntity();
        if (entity == null) {
            data = new byte[]{};
            contentType = null;
        } else {
            data = EntityUtils.toByteArray((HttpEntity)entity);
            String contentTypeStr = entity.getContentType();
            contentType = contentTypeStr == null ? null : ContentType.parse((CharSequence)contentTypeStr);
        }
        entity = new ByteArrayEntity(data, contentType);
        response.setCode(200);
        response.setEntity(entity);
    }
}

