/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.impl;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;

public final class ObservationAsyncExecInterceptor
implements AsyncExecChainHandler {
    private final ObservationRegistry registry;
    private final ObservingOptions opts;

    public ObservationAsyncExecInterceptor(ObservationRegistry registry, ObservingOptions opts) {
        this.registry = registry;
        this.opts = opts;
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        if (!this.opts.spanSampling.test(request.getRequestUri())) {
            chain.proceed(request, entityProducer, scope, asyncExecCallback);
            return;
        }
        final Observation observation = Observation.createNotStarted((String)"http.client.request", (ObservationRegistry)this.registry).contextualName(request.getMethod() + " " + request.getRequestUri()).lowCardinalityKeyValue("http.method", request.getMethod()).lowCardinalityKeyValue("net.peer.name", scope.route.getTargetHost().getHostName()).start();
        AsyncExecCallback wrappedCallback = new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                observation.lowCardinalityKeyValue("http.status_code", Integer.toString(response.getCode()));
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            public void completed() {
                observation.stop();
                asyncExecCallback.completed();
            }

            public void failed(Exception cause) {
                observation.error((Throwable)cause);
                observation.stop();
                asyncExecCallback.failed(cause);
            }
        };
        chain.proceed(request, entityProducer, scope, wrappedCallback);
    }
}

