/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class IgniteCliRpcRequestClosure
implements Closure {
    private final Node node;
    private final RpcRequestClosure delegate;

    IgniteCliRpcRequestClosure(Node node, RpcRequestClosure closure) {
        this.node = node;
        this.delegate = closure;
    }

    public RpcContext getRpcCtx() {
        return this.delegate.getRpcCtx();
    }

    public RaftMessagesFactory getMsgFactory() {
        return this.delegate.getMsgFactory();
    }

    public void sendResponse(Message msg) {
        RpcRequests.ErrorResponse err;
        if (msg instanceof RpcRequests.ErrorResponse && (err = (RpcRequests.ErrorResponse)msg).errorCode() == RaftError.EPERM.getNumber()) {
            PeerId newLeader = this.node.getLeaderId();
            String leaderId = newLeader != null ? newLeader.toString() : null;
            this.delegate.sendResponse(RaftRpcFactory.DEFAULT.newResponse(leaderId, this.getMsgFactory(), RaftError.EPERM, err.errorMsg(), new Object[0]));
            return;
        }
        this.delegate.sendResponse(msg);
    }

    @Override
    public void run(Status status) {
        this.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.getMsgFactory(), status));
    }
}

