/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.deployment.DeploymentUnitInfo;
import org.apache.ignite.internal.compute.loader.JobClassLoader;
import org.apache.ignite.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.table.partition.Partition;
import org.jetbrains.annotations.Nullable;

public class JobExecutionContextImpl
implements JobExecutionContext {
    private final Ignite ignite;
    private final AtomicBoolean isInterrupted;
    private final JobClassLoader classLoader;
    @Nullable
    private final Partition partition;
    private final Lazy<Collection<DeploymentUnitInfo>> deploymentUnits;

    public JobExecutionContextImpl(Ignite ignite, AtomicBoolean isInterrupted, JobClassLoader classLoader, @Nullable Partition partition) {
        this.ignite = ignite;
        this.isInterrupted = isInterrupted;
        this.classLoader = classLoader;
        this.partition = partition;
        this.deploymentUnits = new Lazy(this::initDeploymentUnits);
    }

    public Ignite ignite() {
        return this.ignite;
    }

    public boolean isCancelled() {
        return this.isInterrupted.get();
    }

    @Nullable
    public Partition partition() {
        return this.partition;
    }

    public Collection<DeploymentUnitInfo> deploymentUnits() {
        return (Collection)this.deploymentUnits.get();
    }

    public JobClassLoader classLoader() {
        return this.classLoader;
    }

    private Collection<DeploymentUnitInfo> initDeploymentUnits() {
        List<DisposableDeploymentUnit> units = this.classLoader.units();
        ArrayList<DeploymentUnitInfo> result = new ArrayList<DeploymentUnitInfo>(units.size());
        for (DisposableDeploymentUnit unit : units) {
            result.add(new DeploymentUnitInfo(unit.unit().name(), unit.unit().version(), unit.path()));
        }
        return result;
    }
}

