/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.tx;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteTuple3;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.TransactionException;

public class ClientTransactionCommitRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, ClockService clockService, IgniteTablesInternal igniteTables, boolean enableDirectMapping, HybridTimestampTracker tsTracker) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        InternalTransaction tx = resources.remove(resourceId).get(InternalTransaction.class);
        if (enableDirectMapping && !tx.isReadOnly()) {
            TableViewInternal table;
            int cnt = in.unpackInt();
            ArrayList<IgniteTuple3<TablePartitionId, String, Long>> list = new ArrayList<IgniteTuple3<TablePartitionId, String, Long>>();
            for (int i = 0; i < cnt; ++i) {
                int tableId = in.unpackInt();
                int n = in.unpackInt();
                String consistentId = in.unpackString();
                long token = in.unpackLong();
                list.add(new IgniteTuple3<TablePartitionId, String, Long>(new TablePartitionId(tableId, n), consistentId, token));
            }
            if (cnt > 0) {
                long causality = in.unpackLong();
                clockService.updateClock(HybridTimestamp.hybridTimestamp(causality));
            }
            TransactionException ex = null;
            for (IgniteTuple3 igniteTuple3 : list) {
                table = igniteTables.cachedTable(((TablePartitionId)igniteTuple3.get1()).tableId());
                if (table == null) {
                    ex = new TransactionException(ErrorGroups.Transactions.TX_COMMIT_ERR, "Table not found [id=" + ((TablePartitionId)igniteTuple3.get1()).tableId() + "]");
                    break;
                }
                if (ClientTransactionCommitRequest.merge(table.internalTable(), ((TablePartitionId)igniteTuple3.get1()).partitionId(), (String)igniteTuple3.get2(), (Long)igniteTuple3.get3(), tx, true)) continue;
                ex = new TransactionException(ErrorGroups.Transactions.TX_COMMIT_ERR, "Invalid enlistment token [id=" + ((TablePartitionId)igniteTuple3.get1()).tableId() + "]");
                break;
            }
            if (ex != null) {
                for (IgniteTuple3 igniteTuple3 : list) {
                    table = igniteTables.cachedTable(((TablePartitionId)igniteTuple3.get1()).tableId());
                    if (table == null) continue;
                    ClientTransactionCommitRequest.merge(table.internalTable(), ((TablePartitionId)igniteTuple3.get1()).partitionId(), (String)igniteTuple3.get2(), (Long)igniteTuple3.get3(), tx, false);
                }
                TransactionException finalEx = ex;
                return tx.rollbackAsync().handle((res, err) -> {
                    if (err != null) {
                        finalEx.addSuppressed((Throwable)err);
                    }
                    metrics.transactionsActiveDecrement();
                    ExceptionUtils.sneakyThrow(finalEx);
                    return null;
                });
            }
        }
        return tx.commitAsync().handle((res, err) -> {
            if (!tx.isReadOnly()) {
                tsTracker.update(clockService.current());
            }
            metrics.transactionsActiveDecrement();
            if (err != null) {
                throw (RuntimeException)ExceptionUtils.sneakyThrow(err);
            }
            return null;
        });
    }

    public static boolean merge(InternalTable table, int partId, String consistentId, long token, InternalTransaction tx, boolean commit) {
        ReplicationGroupId replicationGroupId = table.targetReplicationGroupId(partId);
        PendingTxPartitionEnlistment existing = tx.enlistedPartition(replicationGroupId);
        if (existing != null) {
            return !commit || existing.consistencyToken() == token;
        }
        tx.enlist(replicationGroupId, table.tableId(), consistentId, token);
        return true;
    }
}

