/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;
import java.util.function.IntFunction;
import org.apache.ignite3.internal.lang.IgniteUuid;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite3.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite3.internal.network.serialization.marshal.ProtocolMarshalling;
import org.apache.ignite3.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite3.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite3.internal.network.serialization.marshal.ValueReader;
import org.apache.ignite3.internal.network.serialization.marshal.ValueWriter;
import org.apache.ignite3.internal.util.StringIntrospection;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;

class BuiltInMarshalling {
    private static final ValueWriter<Class<?>> classWriter = (obj, out, ctx) -> BuiltInMarshalling.writeClass(obj, out);
    private static final IntFunction<Class<?>[]> classArrayFactory = Class[]::new;
    private static final ValueReader<Class<?>> classReader = BuiltInMarshalling::readClass;
    private static final IgniteDataInput.Materializer<String> LATIN1_MATERIALIZER = (bytes, offset, len) -> new String(bytes, offset, len, StandardCharsets.ISO_8859_1);
    private static final Field singletonListElementField;

    static void writeString(String string, DataOutput output) throws IOException {
        output.writeUTF(string);
    }

    static String readString(DataInput input) throws IOException {
        return input.readUTF();
    }

    static void writeLatin1String(String string, IgniteDataOutput output) throws IOException {
        byte[] bytes = StringIntrospection.fastLatin1Bytes(string);
        BuiltInMarshalling.writeByteArray(bytes, output);
    }

    static String readLatin1String(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.materializeFromNextBytes(length, LATIN1_MATERIALIZER);
    }

    static Object readBareObject(DataInput input) {
        return new Object();
    }

    static void writeUuid(UUID uuid, DataOutput output) throws IOException {
        output.writeLong(uuid.getMostSignificantBits());
        output.writeLong(uuid.getLeastSignificantBits());
    }

    static UUID readUuid(DataInput input) throws IOException {
        return new UUID(input.readLong(), input.readLong());
    }

    static void writeIgniteUuid(IgniteUuid uuid, DataOutput output) throws IOException {
        output.writeLong(uuid.localId());
        BuiltInMarshalling.writeUuid(uuid.globalId(), output);
    }

    static IgniteUuid readIgniteUuid(DataInput input) throws IOException {
        long localId = input.readLong();
        UUID globalId = BuiltInMarshalling.readUuid(input);
        return new IgniteUuid(globalId, localId);
    }

    static void writeDate(Date date, DataOutput output) throws IOException {
        output.writeLong(date.getTime());
    }

    static Date readDate(DataInput input) throws IOException {
        return new Date(input.readLong());
    }

    static void writeByteArray(byte[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeByteArray(array);
    }

    static byte[] readByteArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readByteArray(length);
    }

    static void writeShortArray(short[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeShortArray(array);
    }

    static short[] readShortArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readShortArray(length);
    }

    static void writeIntArray(int[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeIntArray(array);
    }

    static int[] readIntArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readIntArray(length);
    }

    static void writeFloatArray(float[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeFloatArray(array);
    }

    static float[] readFloatArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readFloatArray(length);
    }

    static void writeLongArray(long[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeLongArray(array);
    }

    static long[] readLongArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readLongArray(length);
    }

    static void writeDoubleArray(double[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeDoubleArray(array);
    }

    static double[] readDoubleArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readDoubleArray(length);
    }

    static void writeBooleanArray(boolean[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        int bits = 0;
        int writtenBytes = 0;
        for (int i = 0; i < array.length; ++i) {
            boolean bit = array[i];
            int bitIndex = i % 8;
            if (bit) {
                bits = (byte)(bits | 1 << bitIndex);
            }
            if (bitIndex != 7) continue;
            output.writeByte(bits);
            ++writtenBytes;
            bits = 0;
        }
        int totalBytesToWrite = BuiltInMarshalling.numberOfBytesToPackBits(array.length);
        if (writtenBytes < totalBytesToWrite) {
            output.writeByte(bits);
        }
    }

    private static int numberOfBytesToPackBits(int length) {
        return length / 8 + (length % 8 == 0 ? 0 : 1);
    }

    static boolean[] readBooleanArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        boolean[] array = new boolean[length];
        int totalBytesToRead = BuiltInMarshalling.numberOfBytesToPackBits(length);
        for (int byteIndex = 0; byteIndex < totalBytesToRead; ++byteIndex) {
            byte bits = input.readByte();
            int bitsToReadInThisByte = byteIndex < totalBytesToRead - 1 ? 8 : length - (totalBytesToRead - 1) * 8;
            for (int bitIndex = 0; bitIndex < bitsToReadInThisByte; ++bitIndex) {
                if ((bits & 1 << bitIndex) == 0) continue;
                array[byteIndex * 8 + bitIndex] = true;
            }
        }
        return array;
    }

    static void writeCharArray(char[] array, IgniteDataOutput output) throws IOException {
        ProtocolMarshalling.writeLength(array.length, output);
        output.writeCharArray(array);
    }

    static char[] readCharArray(IgniteDataInput input) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return input.readCharArray(length);
    }

    static void writeBigDecimal(BigDecimal object, DataOutput output) throws IOException {
        BuiltInMarshalling.writeString(object.toString(), output);
    }

    static BigDecimal readBigDecimal(DataInput input) throws IOException {
        return new BigDecimal(BuiltInMarshalling.readString(input));
    }

    static void writeEnum(Enum<?> object, DataOutput output) throws IOException {
        BuiltInMarshalling.writeString(object.name(), output);
    }

    static <T extends Enum<T>> Enum<T> readEnum(DataInput input, Class<T> enumClass) throws IOException {
        return Enum.valueOf(enumClass, BuiltInMarshalling.readString(input));
    }

    private static <T> Class<T> classByName(String className, ClassLoader classLoader) throws UnmarshalException {
        try {
            Class<?> castedClass = Class.forName(className, true, classLoader);
            return castedClass;
        }
        catch (ClassNotFoundException e) {
            throw new UnmarshalException("Can not load a class: " + className, (Throwable)e);
        }
    }

    static void writeClass(Class<?> classToWrite, DataOutput output) throws IOException {
        BuiltInMarshalling.writeString(classToWrite.getName(), output);
    }

    static Class<?> readClass(DataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        String className = BuiltInMarshalling.readString(input);
        return BuiltInMarshalling.classByName(className, context.classLoader());
    }

    static void writeClassArray(Class<?>[] classes, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        BuiltInMarshalling.writeRefArray(classes, output, classWriter, context);
    }

    static Class<?>[] readClassArray(IgniteDataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        return BuiltInMarshalling.readRefArray(input, classArrayFactory, classReader, context);
    }

    private static <T> void writeRefArray(T[] array, IgniteDataOutput output, ValueWriter<T> valueWriter, MarshallingContext context) throws IOException, MarshalException {
        ProtocolMarshalling.writeLength(array.length, output);
        for (T object : array) {
            valueWriter.write(object, output, context);
        }
    }

    private static <T> T[] readRefArray(IgniteDataInput input, IntFunction<T[]> arrayFactory, ValueReader<T> valueReader, UnmarshallingContext context) throws IOException, UnmarshalException {
        int length = ProtocolMarshalling.readLength(input);
        T[] array = arrayFactory.apply(length);
        BuiltInMarshalling.fillRefArrayFrom(input, array, valueReader, context);
        return array;
    }

    private static <T> void fillRefArrayFrom(IgniteDataInput input, T[] array, ValueReader<T> valueReader, UnmarshallingContext context) throws IOException, UnmarshalException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = valueReader.read(input, context);
        }
    }

    private static <T> IntFunction<T[]> readTypeAndCreateArrayFactory(DataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        Class<?> componentType = BuiltInMarshalling.readClass(input, context);
        return len -> (Object[])Array.newInstance(componentType, len);
    }

    static <T> T[] preInstantiateGenericRefArray(DataInput input, UnmarshallingContext context) throws IOException, UnmarshalException {
        IntFunction<T[]> arrayFactory = BuiltInMarshalling.readTypeAndCreateArrayFactory(input, context);
        int length = ProtocolMarshalling.readLength(input);
        return arrayFactory.apply(length);
    }

    static <T> void writeCollection(Collection<T> collection, IgniteDataOutput output, ValueWriter<T> valueWriter, MarshallingContext context) throws IOException, MarshalException {
        ProtocolMarshalling.writeLength(collection.size(), output);
        if (collection instanceof List && collection instanceof RandomAccess) {
            BuiltInMarshalling.writeRandomAccessListElements(output, valueWriter, context, (List)collection);
        } else {
            for (T object : collection) {
                valueWriter.write(object, output, context);
            }
        }
    }

    private static <T> void writeRandomAccessListElements(IgniteDataOutput output, ValueWriter<T> valueWriter, MarshallingContext context, List<T> list) throws IOException, MarshalException {
        for (int i = 0; i < list.size(); ++i) {
            valueWriter.write(list.get(i), output, context);
        }
    }

    static <T, C extends Collection<T>> void fillCollectionFrom(IgniteDataInput input, C collection, ValueReader<T> valueReader, UnmarshallingContext context) throws IOException, UnmarshalException {
        int length = ProtocolMarshalling.readLength(input);
        for (int i = 0; i < length; ++i) {
            collection.add(valueReader.read(input, context));
        }
    }

    static <T, C extends Collection<T>> C preInstantiateCollection(DataInput input, IntFunction<C> collectionFactory) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return (C)((Collection)collectionFactory.apply(length));
    }

    static <T, C extends Collection<T>> void fillSingletonCollectionFrom(IgniteDataInput input, C collection, ValueReader<T> elementReader, UnmarshallingContext context) throws IOException, UnmarshalException {
        T element = elementReader.read(input, context);
        try {
            singletonListElementField.set(collection, element);
        }
        catch (ReflectiveOperationException e) {
            throw new UnmarshalException("Cannot set field value", (Throwable)e);
        }
    }

    static <K, V> void writeMap(Map<K, V> map, IgniteDataOutput output, ValueWriter<K> keyWriter, ValueWriter<V> valueWriter, MarshallingContext context) throws IOException, MarshalException {
        ProtocolMarshalling.writeLength(map.size(), output);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyWriter.write(entry.getKey(), output, context);
            valueWriter.write(entry.getValue(), output, context);
        }
    }

    static <K, V, M extends Map<K, V>> void fillMapFrom(IgniteDataInput input, M map, ValueReader<K> keyReader, ValueReader<V> valueReader, UnmarshallingContext context) throws IOException, UnmarshalException {
        int length = ProtocolMarshalling.readLength(input);
        for (int i = 0; i < length; ++i) {
            map.put(keyReader.read(input, context), valueReader.read(input, context));
        }
    }

    static <K, V, M extends Map<K, V>> M preInstantiateMap(DataInput input, IntFunction<M> mapFactory) throws IOException {
        int length = ProtocolMarshalling.readLength(input);
        return (M)((Map)mapFactory.apply(length));
    }

    static void writeBitSet(BitSet object, IgniteDataOutput output) throws IOException {
        BuiltInMarshalling.writeByteArray(object.toByteArray(), output);
    }

    static BitSet readBitSet(IgniteDataInput input) throws IOException {
        return BitSet.valueOf(BuiltInMarshalling.readByteArray(input));
    }

    private BuiltInMarshalling() {
    }

    static {
        try {
            singletonListElementField = Collections.singletonList(null).getClass().getDeclaredField("element");
            singletonListElementField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

