/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.internal.util.IgniteStripedReadWriteLock;

class TransactionExpirationRegistry {
    private static final IgniteLogger LOG = Loggers.forClass(TransactionExpirationRegistry.class);
    private final NavigableMap<Long, Object> txsByExpirationTime = new ConcurrentSkipListMap<Long, Object>();
    private final IgniteStripedReadWriteLock watermarkLock = new IgniteStripedReadWriteLock();
    private volatile long watermark = Long.MIN_VALUE;

    TransactionExpirationRegistry() {
    }

    private static long physicalExpirationTimeMillis(HybridTimestamp beginTimestamp, long effectiveTimeoutMillis) {
        return TransactionExpirationRegistry.sumWithSaturation(beginTimestamp.getPhysical(), effectiveTimeoutMillis);
    }

    private static long sumWithSaturation(long a, long b) {
        assert (a >= 0L) : a;
        assert (b >= 0L) : b;
        long sum = a + b;
        if (sum < 0L) {
            return Long.MAX_VALUE;
        }
        return sum;
    }

    void register(InternalTransaction tx) {
        this.register(tx, TransactionExpirationRegistry.physicalExpirationTimeMillis(TransactionIds.beginTimestamp(tx.id()), tx.getTimeout()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(InternalTransaction tx, long txExpirationTime) {
        if (this.isExpired(txExpirationTime)) {
            TransactionExpirationRegistry.abortTransaction(tx);
            return;
        }
        this.watermarkLock.readLock().lock();
        try {
            if (this.isExpired(txExpirationTime)) {
                TransactionExpirationRegistry.abortTransaction(tx);
                return;
            }
            this.txsByExpirationTime.compute(txExpirationTime, (k, txOrSet) -> {
                Set txsExpiringAtTs;
                if (txOrSet == null) {
                    return tx;
                }
                if (txOrSet instanceof Set) {
                    txsExpiringAtTs = (Set)txOrSet;
                } else {
                    txsExpiringAtTs = ConcurrentHashMap.newKeySet();
                    txsExpiringAtTs.add((InternalTransaction)txOrSet);
                }
                txsExpiringAtTs.add(tx);
                return txsExpiringAtTs;
            });
        }
        finally {
            this.watermarkLock.readLock().unlock();
        }
    }

    private boolean isExpired(long expirationTime) {
        return expirationTime <= this.watermark;
    }

    private static void abortTransaction(InternalTransaction tx) {
        tx.rollbackTimeoutExceededAsync().whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("Transaction has aborted due to timeout [txId={}]", (Throwable)ex, (Object)tx.id());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireUpTo(long expirationTime) {
        ArrayList transactionsAndSetsToExpire;
        this.watermarkLock.writeLock().lock();
        try {
            NavigableMap<Long, Object> headMap = this.txsByExpirationTime.headMap(expirationTime, true);
            transactionsAndSetsToExpire = new ArrayList(headMap.values());
            headMap.clear();
            this.watermark = expirationTime;
        }
        finally {
            this.watermarkLock.writeLock().unlock();
        }
        for (Object txOrSet : transactionsAndSetsToExpire) {
            if (txOrSet instanceof Set) {
                for (InternalTransaction tx : (Set)txOrSet) {
                    TransactionExpirationRegistry.abortTransaction(tx);
                }
                continue;
            }
            InternalTransaction tx = (InternalTransaction)txOrSet;
            TransactionExpirationRegistry.abortTransaction(tx);
        }
    }

    void abortAllRegistered() {
        this.expireUpTo(Long.MAX_VALUE);
    }

    void unregister(InternalTransaction tx) {
        this.unregister(tx, TransactionExpirationRegistry.physicalExpirationTimeMillis(TransactionIds.beginTimestamp(tx.id()), tx.getTimeout()));
    }

    void unregister(InternalTransaction tx, long expirationTime) {
        this.txsByExpirationTime.computeIfPresent(expirationTime, (k, txOrSet) -> {
            if (txOrSet instanceof Set) {
                Set set = (Set)txOrSet;
                set.remove(tx);
                int newSize = set.size();
                if (newSize == 0) {
                    return null;
                }
                if (newSize == 1) {
                    try {
                        return set.iterator().next();
                    }
                    catch (NoSuchElementException e) {
                        return null;
                    }
                }
                return set;
            }
            InternalTransaction registeredTx = (InternalTransaction)txOrSet;
            if (registeredTx.id().equals(tx.id())) {
                return null;
            }
            return registeredTx;
        });
    }
}

