/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.spark.connector.mapping;

import org.apache.hugegraph.spark.connector.constant.DataTypeEnum;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VertexMapping extends ElementMapping {

    @JsonProperty("id")
    private final String idField;

    public VertexMapping(String idField) {
        this.idField = idField;
    }

    @Override
    public DataTypeEnum type() {
        return DataTypeEnum.VERTEX;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
    }

    public String idField() {
        return this.idField;
    }

    @Override
    public String toString() {
        return String.format("vertex-mapping(label=%s)", this.label());
    }
}
