/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.region;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;

public class RegionGroupStatistics {
    private final RegionGroupStatus regionGroupStatus;
    private final Map<Integer, RegionStatistics> regionStatisticsMap;

    public RegionGroupStatistics(RegionGroupStatus regionGroupStatus, Map<Integer, RegionStatistics> regionStatisticsMap) {
        this.regionGroupStatus = regionGroupStatus;
        this.regionStatisticsMap = regionStatisticsMap;
    }

    public static RegionGroupStatistics generateDefaultRegionGroupStatistics() {
        return new RegionGroupStatistics(RegionGroupStatus.Disabled, new TreeMap<Integer, RegionStatistics>());
    }

    public RegionGroupStatus getRegionGroupStatus() {
        return this.regionGroupStatus;
    }

    public RegionStatus getRegionStatus(int dataNodeId) {
        return this.regionStatisticsMap.containsKey(dataNodeId) ? this.regionStatisticsMap.get(dataNodeId).getRegionStatus() : RegionStatus.Unknown;
    }

    public Map<Integer, RegionStatistics> getRegionStatisticsMap() {
        return this.regionStatisticsMap;
    }

    public List<Integer> getRegionIds() {
        return new ArrayList<Integer>(this.regionStatisticsMap.keySet());
    }

    public boolean isNewerThan(RegionGroupStatistics o) {
        for (Integer dataNodeId : this.regionStatisticsMap.keySet()) {
            if (o.regionStatisticsMap.containsKey(dataNodeId) && !this.regionStatisticsMap.get(dataNodeId).isNewerThan(o.regionStatisticsMap.get(dataNodeId))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionGroupStatistics that = (RegionGroupStatistics)o;
        return this.regionGroupStatus == that.regionGroupStatus && this.regionStatisticsMap.equals(that.regionStatisticsMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.regionGroupStatus, this.regionStatisticsMap});
    }

    public String toString() {
        return "RegionGroupStatistics{regionGroupStatus=" + (Object)((Object)this.regionGroupStatus) + '}';
    }
}

