/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connector;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.ops4j.pax.transx.connector.SubjectSource;
import org.ops4j.pax.transx.connector.impl.GenericConnectionManager;
import org.ops4j.pax.transx.tm.TransactionManager;

public class ConnectionManagerBuilder {
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long HOUSE_KEEPING_PERIOD = TimeUnit.SECONDS.toMillis(30L);
    private static final long ALIVE_BYPASS_WINDOW = TimeUnit.MILLISECONDS.toMillis(500L);
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final Logger LOG = Logger.getLogger(ConnectionManagerBuilder.class.getName());
    private ManagedConnectionFactory managedConnectionFactory;
    private TransactionManager transactionManager;
    private TransactionSupport.TransactionSupportLevel transaction;
    private SubjectSource subjectSource;
    private String name;
    private int minIdle = -1;
    private int maxPoolSize = -1;
    private long connectionTimeout = CONNECTION_TIMEOUT;
    private long idleTimeout = IDLE_TIMEOUT;
    private long maxLifetime = MAX_LIFETIME;
    private long aliveBypassWindow = ALIVE_BYPASS_WINDOW;
    private long houseKeepingPeriod = HOUSE_KEEPING_PERIOD;

    private ConnectionManagerBuilder() {
    }

    public static ConnectionManagerBuilder builder() {
        return new ConnectionManagerBuilder();
    }

    public ConnectionManagerBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ConnectionManagerBuilder managedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = managedConnectionFactory;
        return this;
    }

    public ConnectionManagerBuilder transaction(TransactionSupport.TransactionSupportLevel transaction) {
        this.transaction = transaction;
        return this;
    }

    public ConnectionManagerBuilder transactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    public ConnectionManagerBuilder minIdle(int minSize) {
        this.minIdle = minSize;
        return this;
    }

    public ConnectionManagerBuilder maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public ConnectionManagerBuilder aliveBypassWindow(long aliveBypassWindow) {
        this.aliveBypassWindow = aliveBypassWindow;
        return this;
    }

    public ConnectionManagerBuilder houseKeepingPeriod(long houseKeepingPeriod) {
        this.houseKeepingPeriod = houseKeepingPeriod;
        return this;
    }

    public ConnectionManagerBuilder connectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ConnectionManagerBuilder idleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public ConnectionManagerBuilder maxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
        return this;
    }

    public ConnectionManager build() throws Exception {
        TransactionSupport ts;
        TransactionSupport.TransactionSupportLevel txSupportLevel;
        if (this.transactionManager == null && this.transaction != TransactionSupport.TransactionSupportLevel.NoTransaction) {
            throw new IllegalArgumentException("transactionManager must be set");
        }
        if (this.managedConnectionFactory == null) {
            throw new IllegalArgumentException("managedConnectionFactory must be set");
        }
        if (this.transaction == null && this.managedConnectionFactory instanceof TransactionSupport && (txSupportLevel = (ts = (TransactionSupport)TransactionSupport.class.cast(this.managedConnectionFactory)).getTransactionSupport()) != null) {
            this.transaction = txSupportLevel;
        }
        String name = this.name != null ? this.name : this.managedConnectionFactory.getClass().getSimpleName();
        String poolName = "TransxPool-" + ConnectionManagerBuilder.generatePoolNumber() + "-" + name;
        if (this.maxLifetime != 0L && this.maxLifetime < TimeUnit.SECONDS.toMillis(30L)) {
            LOG.warning(() -> poolName + " - maxLifetime is less than 30000ms, setting to default " + MAX_LIFETIME + " ms.");
            this.maxLifetime = MAX_LIFETIME;
        }
        if (this.idleTimeout + TimeUnit.SECONDS.toMillis(1L) > this.maxLifetime && this.maxLifetime > 0L) {
            LOG.warning(() -> poolName + " - idleTimeout is close to or more than maxLifetime, disabling it.");
            this.idleTimeout = 0L;
        }
        if (this.idleTimeout != 0L && this.idleTimeout < TimeUnit.SECONDS.toMillis(10L)) {
            LOG.warning(() -> poolName + " - idleTimeout is less than 10000ms, setting to default " + IDLE_TIMEOUT + "ms.");
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (this.connectionTimeout < 250L) {
            LOG.warning(() -> poolName + " - connectionTimeout is less than 250ms, setting to " + CONNECTION_TIMEOUT + "ms.");
            this.connectionTimeout = CONNECTION_TIMEOUT;
        }
        if (this.maxPoolSize < 1) {
            int n = this.maxPoolSize = this.minIdle <= 0 ? 10 : this.minIdle;
        }
        if (this.minIdle < 0 || this.minIdle > this.maxPoolSize) {
            this.minIdle = this.maxPoolSize;
        }
        return new GenericConnectionManager(this.transactionManager, this.transaction, this.subjectSource, this.getClass().getClassLoader(), this.managedConnectionFactory, name, poolName, this.minIdle, this.maxPoolSize, this.connectionTimeout, this.idleTimeout, this.maxLifetime, this.aliveBypassWindow, this.houseKeepingPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generatePoolNumber() {
        Properties properties = System.getProperties();
        synchronized (properties) {
            int next = Integer.getInteger("org.ops4j.pax.transx.pool_number", 0) + 1;
            System.setProperty("org.ops4j.pax.transx.pool_number", String.valueOf(next));
            return next;
        }
    }
}

