/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.json.JsonValidationResponseParser;
import org.jasig.cas.client.validation.json.TicketValidationJsonResponse;

public class Cas30JsonServiceTicketValidator
extends Cas30ServiceTicketValidator {
    public Cas30JsonServiceTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        this.setCustomParameters(Collections.singletonMap("format", "JSON"));
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            TicketValidationJsonResponse json = new JsonValidationResponseParser().parse(response);
            return json.getAssertion(this.getProxyGrantingTicketStorage(), this.getProxyRetriever());
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Unable parse the JSON response. Falling back to XML", (Throwable)e);
            return super.parseResponseFromServer(response);
        }
        catch (IOException e) {
            throw new TicketValidationException(e.getMessage(), e);
        }
    }

    @Override
    protected Map<String, Object> extractCustomAttributes(String xml) {
        return Collections.emptyMap();
    }
}

