/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.resources;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.i18n.resources.Resources;
import org.apache.knox.gateway.i18n.resources.ResourcesInvoker;

public class ResourcesFactory {
    private static Map<Class<?>, Object> proxies = new ConcurrentHashMap();

    public static <T> T get(Class<T> clazz) {
        Object proxy = proxies.get(clazz);
        if (proxy == null) {
            Resources anno = clazz.getAnnotation(Resources.class);
            if (anno == null) {
                throw new IllegalArgumentException(clazz.getName() + " missing @" + Resources.class.getCanonicalName());
            }
            ResourcesInvoker invoker = new ResourcesInvoker(clazz);
            proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)invoker);
            proxies.put(clazz, proxy);
        }
        return (T)proxy;
    }
}

