/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shirorealm;

import java.util.LinkedHashSet;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.shirorealm.UnixUserPrincipal;
import org.apache.knox.gateway.shirorealm.impl.i18n.KnoxShiroMessages;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

public class KnoxPamRealm
extends AuthorizingRealm {
    private static final String HASHING_ALGORITHM = "SHA-256";
    private static final String SUBJECT_USER_ROLES = "subject.userRoles";
    private static final String SUBJECT_USER_GROUPS = "subject.userGroups";
    private static final AuditService auditService = AuditServiceFactory.getAuditService();
    private static final Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private final HashService hashService = new DefaultHashService();
    private final KnoxShiroMessages shiroLog = (KnoxShiroMessages)MessagesFactory.get(KnoxShiroMessages.class);
    private final GatewayMessages gatewayLog = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private String service;

    public KnoxPamRealm() {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher(HASHING_ALGORITHM);
        this.setCredentialsMatcher((CredentialsMatcher)credentialsMatcher);
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LinkedHashSet roles = new LinkedHashSet();
        UnixUserPrincipal user = (UnixUserPrincipal)principals.oneByType(UnixUserPrincipal.class);
        if (user != null) {
            roles.addAll(user.getUnixUser().getGroups());
        }
        SecurityUtils.getSubject().getSession().setAttribute((Object)SUBJECT_USER_ROLES, roles);
        SecurityUtils.getSubject().getSession().setAttribute((Object)SUBJECT_USER_GROUPS, roles);
        String userName = null;
        if (user != null) {
            userName = user.getName();
        }
        this.gatewayLog.lookedUpUserRoles(roles, userName);
        return new SimpleAuthorizationInfo(roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        PAM pam = null;
        UnixUser user = null;
        try {
            pam = new PAM(this.getService());
            UsernamePasswordToken upToken = (UsernamePasswordToken)token;
            user = pam.authenticate(upToken.getUsername(), new String(upToken.getPassword()));
        }
        catch (PAMException e) {
            this.handleAuthFailure(token, e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (pam != null) {
                pam.dispose();
            }
        }
        HashRequest hashRequest = new HashRequest.Builder().setSource(token.getCredentials()).setAlgorithmName(HASHING_ALGORITHM).build();
        Hash credentialsHash = this.hashService.computeHash(hashRequest);
        if (credentialsHash == null) {
            this.handleAuthFailure(token, "Failed to compute hash", null);
        }
        return new SimpleAuthenticationInfo((Object)new UnixUserPrincipal(user), (Object)credentialsHash.toHex(), credentialsHash.getSalt(), this.getName());
    }

    private void handleAuthFailure(AuthenticationToken token, String errorMessage, Exception e) {
        auditor.audit("authentication", token.getPrincipal().toString(), "principal", "failure", errorMessage);
        this.shiroLog.failedLoginInfo(token);
        if (e != null) {
            this.shiroLog.failedLoginAttempt(e.getCause());
            throw new AuthenticationException((Throwable)e);
        }
        throw new AuthenticationException(errorMessage);
    }
}

