/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.generic;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.StringConverter;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;

public class GenericOAuth20ProfileDefinition
extends OAuth20ProfileDefinition<OAuth20Profile, OAuth20Configuration> {
    private final Map<String, String> profileAttributes = new HashMap<String, String>();
    private String profileUrl = null;
    private Verb profileVerb = null;
    private String firstNodePath = null;

    public void setProfileVerb(Verb value) {
        this.profileVerb = value;
    }

    @Override
    public Verb getProfileVerb() {
        if (this.profileVerb != null) {
            return this.profileVerb;
        }
        return super.getProfileVerb();
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return this.profileUrl;
    }

    @Override
    public OAuth20Profile extractUserProfile(String body) {
        OAuth20Profile profile = new OAuth20Profile();
        JsonNode json = JsonHelper.getFirstNode(body, this.getFirstNodePath());
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((BasicUserProfile)profile, (Object)JsonHelper.getElement(json, this.getProfileId())));
            for (String string : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, string, JsonHelper.getElement(json, string));
            }
            for (String string : this.getSecondaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, string, JsonHelper.getElement(json, string));
            }
            for (Map.Entry entry : this.getProfileAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, key, JsonHelper.getElement(json, value));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }

    public Map<String, String> getProfileAttributes() {
        return this.profileAttributes;
    }

    public void profileAttribute(String name, AttributeConverter<? extends Object> converter) {
        this.profileAttribute(name, name, converter);
    }

    public void profileAttribute(String name, String tag, AttributeConverter<? extends Object> converter) {
        this.profileAttributes.put(name, tag);
        if (converter != null) {
            this.getConverters().put(name, converter);
        } else {
            this.getConverters().put(name, new StringConverter());
        }
    }

    public String getFirstNodePath() {
        return this.firstNodePath;
    }

    public void setFirstNodePath(String firstNodePath) {
        this.firstNodePath = firstNodePath;
    }
}

