/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.util.EnumSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.async.AbandonOperation;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.async.AsyncSearchOperation;
import org.ldaptive.async.handler.AsyncRequestHandler;
import org.ldaptive.async.handler.ExceptionHandler;
import org.ldaptive.control.PersistentSearchChangeType;
import org.ldaptive.control.PersistentSearchRequestControl;
import org.ldaptive.control.util.PersistentSearchItem;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final EnumSet<PersistentSearchChangeType> changeTypes;
    private final boolean changesOnly;
    private final boolean returnEcs;

    public PersistentSearchClient(Connection conn, EnumSet<PersistentSearchChangeType> types, boolean co, boolean re) {
        this.connection = conn;
        this.changeTypes = types;
        this.changesOnly = co;
        this.returnEcs = re;
    }

    public BlockingQueue<PersistentSearchItem> execute(SearchRequest request) throws LdapException {
        return this.execute(request, Integer.MAX_VALUE);
    }

    public BlockingQueue<PersistentSearchItem> execute(SearchRequest request, int capacity) throws LdapException {
        final LinkedBlockingQueue<PersistentSearchItem> queue = new LinkedBlockingQueue<PersistentSearchItem>(capacity);
        final AsyncSearchOperation search = new AsyncSearchOperation(this.connection);
        search.setOperationResponseHandlers(new OperationResponseHandler<SearchRequest, SearchResult>(){

            @Override
            public HandlerResult<Response<SearchResult>> handle(Connection conn, SearchRequest request, Response<SearchResult> response) throws LdapException {
                try {
                    PersistentSearchClient.this.logger.debug("received {}", response);
                    search.shutdown();
                    queue.put(new PersistentSearchItem(response));
                }
                catch (Exception e) {
                    PersistentSearchClient.this.logger.warn("Unable to enqueue response {}", response);
                }
                return new HandlerResult<Response<SearchResult>>(response);
            }
        });
        search.setAsyncRequestHandlers(new AsyncRequestHandler(){

            @Override
            public HandlerResult<AsyncRequest> handle(Connection conn, Request request, AsyncRequest asyncRequest) throws LdapException {
                try {
                    PersistentSearchClient.this.logger.debug("received {}", (Object)asyncRequest);
                    queue.put(new PersistentSearchItem(asyncRequest));
                }
                catch (Exception e) {
                    PersistentSearchClient.this.logger.warn("Unable to enqueue async request {}", (Object)asyncRequest);
                }
                return new HandlerResult<Object>(null);
            }
        });
        search.setExceptionHandler(new ExceptionHandler(){

            @Override
            public HandlerResult<Exception> handle(Connection conn, Request request, Exception exception) {
                try {
                    PersistentSearchClient.this.logger.debug("received exception:", (Throwable)exception);
                    search.shutdown();
                    queue.put(new PersistentSearchItem(exception));
                }
                catch (Exception e) {
                    PersistentSearchClient.this.logger.warn("Unable to enqueue exception:", (Throwable)exception);
                }
                return new HandlerResult<Object>(null);
            }
        });
        request.setControls(new PersistentSearchRequestControl(this.changeTypes, this.changesOnly, this.returnEcs, true));
        request.setSearchEntryHandlers(new SearchEntryHandler(){

            @Override
            public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
                try {
                    PersistentSearchClient.this.logger.debug("received {}", (Object)entry);
                    PersistentSearchItem item = new PersistentSearchItem(new PersistentSearchItem.Entry(entry));
                    queue.put(item);
                }
                catch (Exception e) {
                    PersistentSearchClient.this.logger.warn("Unable to enqueue entry {}", (Object)entry);
                }
                return new HandlerResult<Object>(null);
            }

            @Override
            public void initializeRequest(SearchRequest request) {
            }
        });
        search.execute(request);
        return queue;
    }

    public void abandon(int messageId) throws LdapException {
        AbandonOperation abandon = new AbandonOperation(this.connection);
        abandon.execute(messageId);
    }
}

