/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kylin.rest.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
public class ClusterStatusResponse {
    @JsonProperty("active_instances")
    private int activeInstances;

    @JsonProperty("query_status")
    private NodeState queryStatus;

    @JsonProperty("job_status")
    private NodeState jobStatus;

    @JsonProperty("job")
    private List<NodeStateResponse> job;

    @JsonProperty("query")
    private List<NodeStateResponse> query;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class NodeStateResponse {
        @JsonProperty("instance")
        private String instance;
        @JsonProperty("status")
        private NodeState status;
    }

    public enum NodeState {
        GOOD, WARNING, CRASH
    }
}
