/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Json;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class Parameters
extends HashMap<String, Object> {
    public Integer getInt(String key) {
        return this.checkValidityAndCast(key, Integer.class);
    }

    public Boolean getBoolean(String key) {
        return this.checkValidityAndCast(key, Boolean.class);
    }

    public String getString(String key) {
        return this.checkValidityAndCast(key, String.class);
    }

    private <T> T checkValidityAndCast(String key, Class<T> type) {
        Preconditions.checkArgument((boolean)this.containsKey(key), (Object)("Parameter '" + key + "' not present"));
        Preconditions.checkArgument((boolean)type.isAssignableFrom(this.get(key).getClass()), (Object)("Parameter " + key + " is not of type " + type.getSimpleName()));
        return (T)this.get(key);
    }

    public static Parameters empty() {
        return new Parameters();
    }

    public static Parameters from(Map<String, Object> parameterMap) {
        Parameters parameters = new Parameters();
        parameters.putAll(parameterMap);
        return parameters;
    }

    public static Parameters one(String name, Object value) {
        return Parameters.from((Map<String, Object>)ImmutableMap.of((Object)name, (Object)value));
    }

    public <T> T as(Class<T> myDataClass) {
        return Json.mapToObject(this, myDataClass);
    }

    public static <T> Parameters of(T myData) {
        return Parameters.from(Json.objectToMap(myData));
    }
}

